/*
 * Decompiled with CFR 0.152.
 */
package com.infor.erpln.jca.bdeclient;

import com.infor.erpln.jca.bdeclient.BdeException;
import com.infor.erpln.util.XmlUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class BusinessDataEntity {
    private Element mRoot;

    BusinessDataEntity(String iRootName) {
        Document doc = XmlUtil.newDocument();
        this.mRoot = doc.createElement(iRootName);
    }

    BusinessDataEntity(Element iRootElement) {
        this.mRoot = iRootElement;
    }

    String getValue(String tag) throws BdeException {
        if (this.mRoot == null) {
            throw new BdeException("BDE data object not initialized");
        }
        Element e = (Element)this.mRoot.getElementsByTagName(tag).item(0);
        if (e == null || e.getFirstChild() == null) {
            throw new BdeException("value for '" + tag + "' not set");
        }
        return e.getFirstChild().getNodeValue();
    }

    String getValueNoChecks(String tag) {
        try {
            return this.getValue(tag);
        }
        catch (BdeException e) {
            return "";
        }
    }

    protected void addValue(String tagName, String value) {
        XmlUtil.createChildElementWithText(this.mRoot, tagName, value);
    }

    protected void addValue(String tagName, int value) {
        String strValue = Integer.toString(value);
        XmlUtil.createChildElementWithText(this.mRoot, tagName, strValue);
    }

    protected void setAttribute(String attributeName, String value) {
        try {
            this.mRoot.setAttribute(attributeName, value);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    String getAttribute(String attributeName) {
        try {
            return this.mRoot.getAttribute(attributeName);
        }
        catch (Exception e) {
            return null;
        }
    }

    boolean hasValue(String tagName) {
        try {
            this.getValue(tagName);
        }
        catch (BdeException e) {
            return false;
        }
        return true;
    }

    public Element asElement() {
        return this.getRoot();
    }

    final Element getRoot() {
        return this.mRoot;
    }

    final void setRoot(Element newRoot) {
        this.mRoot = newRoot;
    }

    String getRootName() {
        return this.mRoot.getNodeName();
    }

    boolean hasComponent(String componentName) {
        NodeList nl = this.mRoot.getElementsByTagName(componentName);
        int size = nl.getLength();
        return size != 0;
    }

    Element getComponent(String componentName) throws BdeException {
        NodeList nl = this.mRoot.getElementsByTagName(componentName);
        int size = nl.getLength();
        if (size == 0) {
            throw new BdeException("No matching component found for tag: " + componentName);
        }
        return (Element)nl.item(0);
    }

    protected Element addComponent(String componentName) {
        return XmlUtil.createChildElement(this.mRoot, componentName);
    }

    protected void addComponent(Element child) {
        XmlUtil.appendChild(this.mRoot, child);
    }

    protected void addBde(BusinessDataEntity bde) {
        this.addComponent(bde.getRoot());
    }

    public String toString() {
        return this.toString(this.mRoot, "");
    }

    private String toString(Element eRoot, String ident) {
        NodeList nl = eRoot.getChildNodes();
        StringBuffer sb = new StringBuffer();
        sb.append(ident + eRoot.getNodeName() + "\n");
        try {
            Element e;
            Node n;
            int i;
            int maxLength = 1;
            for (i = 0; i < nl.getLength(); ++i) {
                int iL;
                n = nl.item(i);
                if (!(n instanceof Element) || (iL = (e = (Element)n).getNodeName().length()) <= maxLength) continue;
                maxLength = iL;
            }
            for (i = 0; i < nl.getLength(); ++i) {
                n = nl.item(i);
                if (!(n instanceof Element)) continue;
                e = (Element)n;
                if (e.getFirstChild() instanceof Text || e.getFirstChild() == null) {
                    sb.append(ident + this.printNode(e, maxLength));
                    sb.append("\n");
                    continue;
                }
                sb.append(this.toString(e, ident + "   "));
            }
        }
        catch (Exception e) {
            return super.toString();
        }
        return sb.toString();
    }

    private String printNode(Element e, int maxLength) {
        String NodeName = e.getNodeName() + "                                                                         ";
        Node n = e.getFirstChild();
        String sNodeValue = n != null ? n.getNodeValue() : "";
        return "- " + (NodeName.substring(0, maxLength) + " = '" + sNodeValue + "'").trim();
    }
}

