/*
 * Decompiled with CFR 0.152.
 */
package com.infor.erpln.jca.bdeclient;

import com.infor.erpln.jca.bdeclient.BdeConstants;
import com.infor.erpln.jca.bdeclient.BusinessDataEntity;
import com.infor.erpln.util.XmlUtil;
import java.util.Enumeration;
import java.util.Hashtable;
import org.w3c.dom.Element;

public class BdeRequest {
    private Element mSelection;
    private Element mFilter;
    private Element mApplicationControlData;
    private String mMethodName;
    private Element mBdeElement;
    private int mProcessingScope;
    private int mMaxNrObjects;
    private int mIteratorFetchSize;
    private int mIteratorId;
    private Hashtable m_ControlTags;
    private boolean mLocalTime = false;

    public BdeRequest(String methodName) {
        this.mMethodName = methodName;
        this.mProcessingScope = -1;
        this.mMaxNrObjects = -1;
        this.mIteratorFetchSize = -1;
        this.mIteratorId = -1;
        this.m_ControlTags = new Hashtable();
    }

    public void setSelection(Element selection) {
        this.mSelection = selection;
    }

    public void setFilter(Element filter) {
        this.mFilter = filter;
    }

    public void setApplicationControlData(Element applicationControlData) {
        this.mApplicationControlData = applicationControlData;
    }

    public Element getApplicationControlData() {
        return this.mApplicationControlData;
    }

    public void setBdeElement(Element bdeElement) {
        this.mBdeElement = bdeElement;
    }

    public void setProcessingScope(int processingScope) {
        this.mProcessingScope = processingScope;
    }

    public void setLocalTime(boolean iSet) {
        this.mLocalTime = iSet;
    }

    public void setIteratorFetchSize(int iIteratorFetchSize) {
        this.mIteratorFetchSize = iIteratorFetchSize;
    }

    public void setMaxNrObjects(int iMaxNrObjects) {
        this.mMaxNrObjects = iMaxNrObjects;
    }

    public void setIteratorId(int iIteratorId) {
        this.mIteratorId = iIteratorId;
    }

    public Element createRequestElement() {
        Element request = XmlUtil.newDocument().createElement(this.mMethodName + "Request");
        Element controlArea = XmlUtil.createChildElement(request, "ControlArea");
        BusinessDataEntity controlAreaWrapper = new BusinessDataEntity(controlArea);
        if (this.mSelection != null) {
            XmlUtil.appendChild(controlArea, this.mSelection);
        }
        if (this.mFilter != null) {
            XmlUtil.appendChild(controlArea, this.mFilter);
        }
        if (this.mApplicationControlData != null) {
            XmlUtil.appendChild(controlArea, this.mApplicationControlData);
        }
        if (this.mProcessingScope >= 0 && this.mProcessingScope < BdeConstants.PROCESSING_SCOPE.length) {
            controlAreaWrapper.addValue("processingScope", BdeConstants.PROCESSING_SCOPE[this.mProcessingScope]);
        }
        if (this.mLocalTime) {
            controlAreaWrapper.setAttribute("LocalTime", "true");
        }
        if (this.mMaxNrObjects >= 0) {
            controlAreaWrapper.addValue("maxNumberOfObjects", this.mMaxNrObjects);
        }
        if (this.mIteratorId >= 0) {
            controlAreaWrapper.addValue("iteratorID", this.mIteratorId);
        }
        if (this.mIteratorFetchSize > 0) {
            controlAreaWrapper.addValue("iteratorFetchSize", this.mIteratorFetchSize);
        }
        this.setControlAreaTags(controlAreaWrapper);
        if (this.mBdeElement != null) {
            Element dataArea = XmlUtil.createChildElement(request, "DataArea");
            XmlUtil.appendChild(dataArea, this.mBdeElement);
        }
        return request;
    }

    public void setControlAreaTag(String attribute, String value) {
        this.m_ControlTags.put(attribute, value);
    }

    private void setControlAreaTags(BusinessDataEntity controlAreaWrapper) {
        Enumeration attributes = this.m_ControlTags.keys();
        while (attributes.hasMoreElements()) {
            String attribute = (String)attributes.nextElement();
            String value = (String)this.m_ControlTags.get(attribute);
            controlAreaWrapper.addValue(attribute, value);
        }
    }
}

