/*
 * Decompiled with CFR 0.152.
 */
package com.infor.erpln.jca.bdeclient;

import com.infor.erpln.jca.bdeclient.BusinessDataEntity;
import org.w3c.dom.Element;

public class BdeFilter
extends BusinessDataEntity {
    private static final String LIKE = "like";
    private static final String EQUAL = "eq";
    private static final String NOT_EQUAL = "ne";
    private static final String LESS = "lt";
    private static final String LESS_OR_EQUAL = "le";
    private static final String GREATER = "gt";
    private static final String GREATER_OR_EQUAL = "ge";
    private static final String AND = "and";
    private static final String OR = "or";
    private static final String LOGICAL_EXPRESSION = "LogicalExpression";
    private static final String LOGICAL_OPERATOR = "logicalOperator";
    private static final String COMPARISON_EXPRESSION = "ComparisonExpression";
    private static final String COMPARISON_OPERATOR = "comparisonOperator";
    private static final String ATTRIBUTE_NAME = "attributeName";
    private static final String INSTANCE_VALUE = "instanceValue";
    private static final String EMPTY_VALUE = "emptyValue";

    protected BdeFilter(Element iFilter) {
        super(iFilter);
    }

    protected BdeFilter() {
        super("Filter");
    }

    public void setExpression(Expression expression) {
        try {
            this.addBde(expression);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Expression createLogicalAnd(Expression expression1, Expression expression2) {
        return this.createLogicalExpression(AND, expression1, expression2);
    }

    public Expression createLogicalOr(Expression expression1, Expression expression2) {
        return this.createLogicalExpression(OR, expression1, expression2);
    }

    public Expression createComparisonEqual(String attribute, String value) {
        return this.createComparisonExpression(EQUAL, attribute, value);
    }

    public Expression createComparisonNotEqual(String attribute, String value) {
        return this.createComparisonExpression(NOT_EQUAL, attribute, value);
    }

    public Expression createComparisonLess(String attribute, String value) {
        return this.createComparisonExpression(LESS, attribute, value);
    }

    public Expression createComparisonLessOrEqual(String attribute, String value) {
        return this.createComparisonExpression(LESS_OR_EQUAL, attribute, value);
    }

    public Expression createComparisonGreater(String attribute, String value) {
        return this.createComparisonExpression(GREATER, attribute, value);
    }

    public Expression createComparisonGreaterOrEqual(String attribute, String value) {
        return this.createComparisonExpression(GREATER_OR_EQUAL, attribute, value);
    }

    public Expression createComparisonLike(String attribute, String value) {
        return this.createComparisonExpression(LIKE, attribute, value);
    }

    public Expression createAttributeComparisonEqual(String attribute1, String attribute2) {
        return this.createAttributeComparisonExpression(EQUAL, attribute1, attribute2);
    }

    public Expression createAttributeComparisonNotEqual(String attribute1, String attribute2) {
        return this.createAttributeComparisonExpression(NOT_EQUAL, attribute1, attribute2);
    }

    public Expression createAttributeComparisonLess(String attribute1, String attribute2) {
        return this.createAttributeComparisonExpression(LESS, attribute1, attribute2);
    }

    public Expression createAttributeComparisonLessOrEqual(String attribute1, String attribute2) {
        return this.createAttributeComparisonExpression(LESS_OR_EQUAL, attribute1, attribute2);
    }

    public Expression createAttributeComparisonGreater(String attribute1, String attribute2) {
        return this.createAttributeComparisonExpression(GREATER, attribute1, attribute2);
    }

    public Expression createAttributeComparisonGreaterOrEqual(String attribute1, String attribute2) {
        return this.createAttributeComparisonExpression(GREATER_OR_EQUAL, attribute1, attribute2);
    }

    public Expression createAttributeComparisonLike(String attribute1, String attribute2) {
        return this.createAttributeComparisonExpression(LIKE, attribute1, attribute2);
    }

    protected LogicalExpression createLogicalExpression(String operator, Expression ce1, Expression ce2) {
        return new LogicalExpression(operator, ce1, ce2);
    }

    protected ComparisonExpression createComparisonExpression(String operator, String attr, String value) {
        return new ComparisonExpression(operator, attr, value);
    }

    protected AttributeComparisonExpression createAttributeComparisonExpression(String operator, String attr1, String attr2) {
        return new AttributeComparisonExpression(operator, attr1, attr2);
    }

    public class Expression
    extends BusinessDataEntity {
        protected Expression(String tag) {
            super(tag);
        }
    }

    public class ComparisonExpression
    extends Expression {
        protected ComparisonExpression(String operator, String attribute, String value) {
            super(BdeFilter.COMPARISON_EXPRESSION);
            try {
                this.addValue(BdeFilter.COMPARISON_OPERATOR, operator);
                this.addValue(BdeFilter.ATTRIBUTE_NAME, attribute);
                if (value != null) {
                    this.addValue(BdeFilter.INSTANCE_VALUE, value);
                } else {
                    this.addValue(BdeFilter.EMPTY_VALUE, "");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public class AttributeComparisonExpression
    extends Expression {
        protected AttributeComparisonExpression(String operator, String attribute1, String attribute2) {
            super(BdeFilter.COMPARISON_EXPRESSION);
            try {
                this.addValue(BdeFilter.COMPARISON_OPERATOR, operator);
                this.addValue(BdeFilter.ATTRIBUTE_NAME, attribute1);
                this.addValue(BdeFilter.ATTRIBUTE_NAME, attribute2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public class LogicalExpression
    extends Expression {
        protected LogicalExpression(String operator, Expression ce1, Expression ce2) {
            super(BdeFilter.LOGICAL_EXPRESSION);
            try {
                this.addValue(BdeFilter.LOGICAL_OPERATOR, operator);
                this.addBde(ce1);
                this.addBde(ce2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

