/*
 * Decompiled with CFR 0.152.
 */
package com.infor.erpln.jca.bdeclient;

import com.infor.erpln.jca.BDEConsumer;
import com.infor.erpln.jca.ConnectionImpl;
import com.infor.erpln.jca.bdeclient.BdeException;
import com.infor.erpln.jca.bdeclient.IBdeEventListener;
import com.infor.erpln.util.XmlUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.resource.ResourceException;
import javax.resource.cci.Connection;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.Logger;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class BdeEventReceiver
implements BDEConsumer {
    private static final Logger LOG = ESAPI.getLogger(BdeEventReceiver.class);
    private ConnectionImpl mConnection;
    private IBdeEventListener mListener;
    private DocumentBuilder mDocBuilder;

    public BdeEventReceiver() throws BdeException {
        this.init();
    }

    public BdeEventReceiver(ConnectionImpl iConnection) throws BdeException {
        this.mConnection = iConnection;
        this.init();
    }

    private void init() throws BdeException {
        try {
            this.mDocBuilder = XmlUtil.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new BdeException("ParserConfigurationException", e, false);
        }
    }

    public void attachConnection(ConnectionImpl iConnection) {
        this.mConnection = iConnection;
    }

    public Connection detachConnection() throws BdeException {
        this.stopListener();
        ConnectionImpl retVal = this.mConnection;
        this.mConnection = null;
        return retVal;
    }

    public void startListener(IBdeEventListener iListener) throws BdeException {
        this.mListener = iListener;
        LOG.info(Logger.EVENT_UNSPECIFIED, "startListener");
        try {
            this.mConnection.activateListener(this);
        }
        catch (ResourceException e) {
            LOG.error(Logger.EVENT_FAILURE, "Activating BDE listener failed", (Throwable)e);
            throw new BdeException("Activating BDE listener failed", e, false);
        }
    }

    public void stopListener() throws BdeException {
        if (this.mConnection != null) {
            try {
                this.mConnection.close();
            }
            catch (ResourceException e) {
                throw new BdeException("Closing listener connection failed", e, false);
            }
        }
    }

    public boolean isRunning() {
        return this.mConnection != null && this.mConnection.isRunning();
    }

    @Override
    public int onBDEMessage(byte[] iBdeMessage) {
        int retVal = 0;
        LOG.info(Logger.EVENT_UNSPECIFIED, "onBDEMessage: received BDE Event");
        ByteArrayInputStream bdeMessageStream = new ByteArrayInputStream(iBdeMessage);
        try {
            Document doc = this.mDocBuilder.parse(bdeMessageStream);
            this.mListener.onEvent(doc.getDocumentElement());
        }
        catch (SAXException e) {
            LOG.error(Logger.EVENT_FAILURE, "onBDEMessage: failed parsing BDE Event: " + e.getMessage(), (Throwable)e);
            retVal = -1;
        }
        catch (IOException e) {
            LOG.error(Logger.EVENT_FAILURE, "onBDEMessage: incomplete BDE Event: " + e.getMessage(), (Throwable)e);
            retVal = -2;
        }
        return retVal;
    }
}

