/*
 * Decompiled with CFR 0.152.
 */
package com.infor.erpln.jca.bdeclient;

import com.infor.erpln.jca.bdeclient.BdeException;
import com.infor.erpln.jca.bdeclient.BdeReply;
import com.infor.erpln.jca.bdeclient.BdeRequest;
import com.infor.erpln.jca.bdeclient.BdeSelection;
import com.infor.erpln.jca.bdeclient.BusinessDataEntity;
import com.infor.erpln.jca.bdeclient.ElementIterator;
import com.infor.erpln.jca.bdeclient.JcaBdeManager;
import com.infor.erpln.jca.bdeclient.JcaBdeResultException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.w3c.dom.Element;

public class BdeElementIterator
implements Iterator {
    private JcaBdeManager mManager;
    private int mIteratorFetchSize;
    private String mBdeName;
    private String mMethodName;
    private int mIteratorId;
    private ElementIterator mElementIterator;

    public BdeElementIterator(JcaBdeManager iManager, int iMaxNrObjects, int iIteratorFetchSize, String iBdeName, String iMethodName, Element iSelection, Element iFilter) throws BdeException, JcaBdeResultException {
        this.mManager = iManager;
        this.mIteratorFetchSize = iIteratorFetchSize;
        this.mBdeName = iBdeName;
        this.mMethodName = iMethodName;
        this.mIteratorId = -1;
        this.doFirstRequest(iMaxNrObjects, iSelection, iFilter);
    }

    public BdeElementIterator(JcaBdeManager jcaBdeManager, int iteratorFetchSize, BdeSelection selection, Element bdeElement, String bdeName, String bdeMethod) throws BdeException {
        this.mManager = jcaBdeManager;
        this.mIteratorFetchSize = iteratorFetchSize;
        this.mBdeName = bdeName;
        this.mMethodName = bdeMethod;
        this.mIteratorId = -1;
        this.doFirstRequest(selection, bdeElement);
    }

    private void doFirstRequest(BdeSelection selection, Element bdeElement) throws BdeException {
        BdeRequest requestWrapper = new BdeRequest(this.mMethodName);
        if (selection != null) {
            requestWrapper.setSelection(selection.getRoot());
        }
        requestWrapper.setIteratorFetchSize(this.mIteratorFetchSize);
        requestWrapper.setBdeElement(bdeElement);
        BdeReply replyWrapper = this.mManager.executeBdeCall(this.mBdeName, this.mMethodName, requestWrapper);
        this.handleListResponse(replyWrapper);
    }

    private void doFirstRequest(int iMaxNrObjects, Element iSelection, Element iFilter) throws BdeException, JcaBdeResultException {
        BdeRequest requestWrapper = new BdeRequest(this.mMethodName);
        requestWrapper.setSelection(iSelection);
        requestWrapper.setFilter(iFilter);
        requestWrapper.setMaxNrObjects(iMaxNrObjects);
        requestWrapper.setIteratorFetchSize(this.mIteratorFetchSize);
        BdeReply replyWrapper = this.mManager.executeBdeCall(this.mBdeName, this.mMethodName, requestWrapper);
        this.handleListResponse(replyWrapper);
    }

    private void doNextRequest() throws BdeException, JcaBdeResultException {
        BdeRequest requestWrapper = new BdeRequest(this.mMethodName);
        requestWrapper.setIteratorFetchSize(this.mIteratorFetchSize);
        requestWrapper.setIteratorId(this.mIteratorId);
        BdeReply replyWrapper = this.mManager.executeBdeCall(this.mBdeName, this.mMethodName, requestWrapper);
        this.handleListResponse(replyWrapper);
    }

    private void handleListResponse(BdeReply iReplyWrapper) throws BdeException {
        Element dataArea;
        BusinessDataEntity controlAreaWrapper;
        String iteratorStr;
        this.mIteratorId = -1;
        Element controlArea = iReplyWrapper.getControlArea();
        if (controlArea != null && (iteratorStr = (controlAreaWrapper = new BusinessDataEntity(controlArea)).getValueNoChecks("iteratorID")).length() > 0) {
            this.mIteratorId = Integer.parseInt(iteratorStr);
        }
        if ((dataArea = iReplyWrapper.getBdeDataArea()) != null) {
            this.mElementIterator = new ElementIterator(dataArea);
        }
    }

    @Override
    public boolean hasNext() {
        if (this.mElementIterator != null && this.mElementIterator.hasMoreElements()) {
            return true;
        }
        return this.hasMoreBatches();
    }

    public Object next() {
        if (this.hasNext()) {
            try {
                return this.nextElement();
            }
            catch (Exception e) {
                throw new NoSuchElementException();
            }
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    boolean hasMoreElements() {
        return this.hasNext();
    }

    public Element nextElement() throws BdeException, JcaBdeResultException {
        if (this.mElementIterator != null) {
            if (this.mElementIterator.hasNext()) {
                return this.mElementIterator.nextElement();
            }
            this.mElementIterator = null;
        }
        if (this.hasMoreBatches()) {
            this.doNextRequest();
            return this.nextElement();
        }
        return null;
    }

    private boolean hasMoreBatches() {
        return this.mIteratorId >= 0;
    }
}

