/*
 * Decompiled with CFR 0.152.
 */
package com.infor.erpln.jca;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javax.resource.cci.ResourceAdapterMetaData;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.Logger;

public class ResourceAdapterMetaDataImpl
implements ResourceAdapterMetaData {
    private final Properties mProperties = new Properties();
    private static final Logger LOG = ESAPI.getLogger(ResourceAdapterMetaDataImpl.class);
    private static final String VERSIONFILE = "jcaversion.properties";

    public ResourceAdapterMetaDataImpl() {
        InputStream input = null;
        try {
            input = this.getClass().getClassLoader().getResourceAsStream(VERSIONFILE);
            if (input == null) {
                LOG.error(Logger.EVENT_FAILURE, "Failed to open properties file: jcaversion.properties");
            } else {
                this.mProperties.load(input);
                LOG.info(Logger.EVENT_SUCCESS, "Succeeded loading: jcaversion.properties");
            }
        }
        catch (IOException e) {
            LOG.error(Logger.EVENT_FAILURE, "Failed loading the properties file: jcaversion.properties", (Throwable)e);
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public String getAdapterName() {
        return "JCAConnector4ERPln";
    }

    public String getAdapterShortDescription() {
        return "JCA Compliant Adapter for ERPln";
    }

    public String getAdapterVendorName() {
        return "Infor";
    }

    public String getAdapterVersion() {
        String version = (String)this.mProperties.get("version");
        if (version == null) {
            version = "internal";
        }
        return version;
    }

    public String[] getInteractionSpecsSupported() {
        return null;
    }

    public String getSpecVersion() {
        return null;
    }

    public boolean supportsExecuteWithInputAndOutputRecord() {
        return false;
    }

    public boolean supportsExecuteWithInputRecordOnly() {
        return false;
    }

    public boolean supportsLocalTransactionDemarcation() {
        return false;
    }
}

