/*
 * Decompiled with CFR 0.152.
 */
package com.infor.erpln.jca;

import com.infor.erpln.jca.ActivationSpecBDE;
import com.infor.erpln.jca.BDEReceiver;
import com.infor.erpln.jca.ConnectionSpecImpl;
import com.infor.erpln.jca.MessageReceiver;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.resource.ResourceException;
import javax.resource.spi.ActivationSpec;
import javax.resource.spi.BootstrapContext;
import javax.resource.spi.ResourceAdapter;
import javax.resource.spi.ResourceAdapterInternalException;
import javax.resource.spi.UnavailableException;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import javax.transaction.xa.XAResource;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.Logger;

public class ResourceAdapterImpl
implements ResourceAdapter {
    private static final Logger LOG = ESAPI.getLogger(ResourceAdapterImpl.class);
    private BootstrapContext mContext;
    private Hashtable<ConnectionSpecImpl, MessageReceiver> mSubscriber = new Hashtable();

    public void endpointActivation(MessageEndpointFactory iFactory, ActivationSpec iActivation) throws ResourceException {
        LOG.info(Logger.EVENT_UNSPECIFIED, "endpointActivation()");
        ConnectionSpecImpl conSpec = (ConnectionSpecImpl)iActivation;
        MessageReceiver receiver = null;
        if (this.mSubscriber.containsKey(conSpec)) {
            LOG.info(Logger.EVENT_UNSPECIFIED, "Add a new endpoint to existing receiver");
            receiver = this.mSubscriber.get(conSpec);
        }
        if (iActivation instanceof ActivationSpecBDE) {
            if (receiver == null) {
                receiver = new BDEReceiver(conSpec);
            } else if (!(receiver instanceof BDEReceiver)) {
                throw new ResourceException("Endpoint not suitable as BDEConsumer");
            }
        }
        if (receiver != null) {
            receiver.addFactory(iFactory);
            this.mSubscriber.put(conSpec, receiver);
        }
    }

    public void endpointDeactivation(MessageEndpointFactory iFactory, ActivationSpec iActivation) {
        LOG.info(Logger.EVENT_UNSPECIFIED, "endpointDeactivation()");
        ConnectionSpecImpl conSpec = (ConnectionSpecImpl)iActivation;
        MessageReceiver receiver = this.mSubscriber.get(conSpec);
        if (receiver != null) {
            receiver.removeFactory(iFactory);
            this.mSubscriber.remove(conSpec);
        }
    }

    public XAResource[] getXAResources(ActivationSpec[] arg0) throws ResourceException {
        LOG.info(Logger.EVENT_UNSPECIFIED, "getXAResources()");
        throw new UnavailableException("getXAResource not implemented");
    }

    public void start(BootstrapContext iContext) throws ResourceAdapterInternalException {
        LOG.info(Logger.EVENT_UNSPECIFIED, "Start ResourceAdapterImpl");
        this.mContext = iContext;
    }

    public void stop() {
        LOG.info(Logger.EVENT_UNSPECIFIED, "Stop ResourceAdapterImpl");
        Enumeration<MessageReceiver> e = this.mSubscriber.elements();
        while (e.hasMoreElements()) {
            MessageReceiver receiver = e.nextElement();
            receiver.stop();
        }
        this.mSubscriber.clear();
    }
}

