/*
 * Decompiled with CFR 0.152.
 */
package com.infor.erpln.jca;

import com.infor.erpln.jca.ConnectionSpecImpl;
import com.infor.erpln.jca.ManagedConnectionFactoryImpl;
import com.infor.erpln.jca.ManagedConnectionImpl;
import java.util.Vector;
import javax.resource.ResourceException;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.Logger;

public abstract class MessageReceiver {
    Vector<MessageEndpointFactory> mEndpointFactories;
    ConnectionSpecImpl mConnSpec;
    ManagedConnectionImpl mConnection;
    private static final Logger LOG = ESAPI.getLogger(MessageReceiver.class);

    MessageReceiver(ConnectionSpecImpl iConnSpec) {
        this.mConnSpec = iConnSpec;
        this.mConnSpec.setActivationType("socketin");
        this.mEndpointFactories = new Vector();
    }

    public void addFactory(MessageEndpointFactory iEndpointFactory) {
        this.mEndpointFactories.add(iEndpointFactory);
        if (this.mConnection == null) {
            try {
                this.init();
            }
            catch (ResourceException e) {
                LOG.info(Logger.EVENT_FAILURE, "Starting listener failed: " + e.toString());
            }
        }
    }

    public void removeFactory(MessageEndpointFactory iEndpointFactory) {
        this.mEndpointFactories.remove(iEndpointFactory);
        if (this.mEndpointFactories.isEmpty()) {
            this.stop();
        }
    }

    public void stop() {
        if (this.mConnection != null) {
            try {
                this.mConnection.destroy();
            }
            catch (ResourceException e) {
                LOG.info(Logger.EVENT_FAILURE, "Closing connection failed");
            }
            this.mConnection = null;
        }
    }

    protected void init() throws ResourceException {
        ManagedConnectionFactoryImpl factory = new ManagedConnectionFactoryImpl();
        this.mConnection = (ManagedConnectionImpl)factory.createManagedConnection(null, this.mConnSpec);
    }
}

