/*
 * Decompiled with CFR 0.152.
 */
package com.infor.erpln.jca;

import com.infor.erpln.jca.ActivationSpecImpl;
import com.infor.erpln.jca.ConnectionFactoryImpl;
import com.infor.erpln.jca.ConnectionSpecImpl;
import com.infor.erpln.jca.IExternalActivation;
import com.infor.erpln.jca.ManagedConnectionImpl;
import com.infor.erpln.jca.PrincipalMap;
import com.infor.erpln.jca.PrincipalMapEntry;
import com.infor.erpln.protocol.BaanConnectionException;
import com.infor.erpln.protocol.DsSessionLayer;
import com.infor.erpln.protocol.HttpSessionLayer;
import com.infor.erpln.protocol.SSLStoreParameters;
import com.infor.erpln.protocol.SessionLayer;
import com.infor.erpln.protocol.SocketSessionLayer;
import java.io.PrintWriter;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Iterator;
import java.util.Set;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.SecurityException;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.Logger;

public class ManagedConnectionFactoryImpl
implements ManagedConnectionFactory {
    private PrintWriter mLogWriter;
    private String mMapFile;
    private String mOutboundConnectionPoint;
    private PrincipalMap mPrincipalMap = null;
    private IExternalActivation m_externalActivation;
    private final SSLStoreParameters m_storeParameters = new SSLStoreParameters();
    private int m_replyTimeout = 43200;
    private static final Logger LOG = ESAPI.getLogger(ManagedConnectionFactoryImpl.class);

    ManagedConnectionFactoryImpl() {
    }

    ManagedConnectionFactoryImpl(IExternalActivation activationImpl) {
        this();
        this.m_externalActivation = activationImpl;
    }

    public Object createConnectionFactory() throws ResourceException {
        LOG.debug(Logger.EVENT_UNSPECIFIED, "createConnectionFactory()");
        this.processMapFile();
        return new ConnectionFactoryImpl(this, null);
    }

    public Object createConnectionFactory(ConnectionManager iConnectionManager) throws ResourceException {
        LOG.debug(Logger.EVENT_UNSPECIFIED, "createConnectionFactory((ConnectionManager)" + iConnectionManager.toString() + ")");
        this.processMapFile();
        return new ConnectionFactoryImpl(this, iConnectionManager);
    }

    public ManagedConnection createManagedConnection(Subject iSubject, ConnectionRequestInfo iConnectionRequestInfo) throws ResourceException {
        if (LOG.isDebugEnabled()) {
            LOG.debug(Logger.EVENT_UNSPECIFIED, "createManagedConnection((Subject),(ConnectionRequestInfo))");
        }
        if (iConnectionRequestInfo == null) {
            if (this.mOutboundConnectionPoint != null && this.mOutboundConnectionPoint.length() > 0) {
                iConnectionRequestInfo = new ConnectionSpecImpl(this.mOutboundConnectionPoint);
            } else {
                throw new ResourceException("No default connectionPoint available");
            }
        }
        if (iConnectionRequestInfo instanceof ActivationSpecImpl) {
            return this.createInboundConnection((ActivationSpecImpl)iConnectionRequestInfo);
        }
        if (!(iConnectionRequestInfo instanceof ConnectionSpecImpl)) {
            throw new ResourceException("ConnectionRequestInfo not of type ConnectionSpecImpl");
        }
        ConnectionSpecImpl connectionRequestInfo = (ConnectionSpecImpl)iConnectionRequestInfo;
        int connectionMethod = connectionRequestInfo.getConnectionMethod();
        if (connectionMethod == 5) {
            String activationType = connectionRequestInfo.getActivationType();
            LOG.info(Logger.EVENT_UNSPECIFIED, "External Activation detected, activation string = '" + activationType + "'");
            if (this.m_externalActivation != null) {
                String backendReference = this.m_externalActivation.startBackend(activationType);
                LOG.info(Logger.EVENT_UNSPECIFIED, "Returned reference from External Activation = '" + backendReference + "'");
                ConnectionSpecImpl returnedConnectionConfig = this.createConnectionConfig(backendReference);
                SocketSessionLayer session = new SocketSessionLayer();
                try {
                    session.connect(returnedConnectionConfig);
                    ManagedConnectionImpl connection = new ManagedConnectionImpl(this, connectionRequestInfo, session);
                    return connection;
                }
                catch (BaanConnectionException ex) {
                    LOG.error(Logger.EVENT_FAILURE, "createManagedConnection --> BaanConnectionException", (Throwable)ex);
                    throw new ResourceException("createManagedConnection (External Activation) failed", (Throwable)ex);
                }
            }
            String error = "Connection configured for external activation but no implementation provided";
            LOG.error(Logger.EVENT_FAILURE, "Connection configured for external activation but no implementation provided");
            throw new ResourceException("Connection configured for external activation but no implementation provided");
        }
        PasswordCredential pc = this.getPasswordCredential(iSubject, connectionRequestInfo);
        SessionLayer session = null;
        try {
            ConnectionSpecImpl config = this.createConnectionConfig(connectionRequestInfo, pc);
            session = this.getSessionLayer(connectionMethod);
            session.connect(config);
            ManagedConnectionImpl connection = new ManagedConnectionImpl(this, config, session);
            return connection;
        }
        catch (BaanConnectionException ex) {
            LOG.error(Logger.EVENT_FAILURE, "createManagedConnection --> BaanConnectionException", (Throwable)ex);
            if (this.mLogWriter != null) {
                this.mLogWriter.println(ex);
            }
            if (session != null) {
                session.close();
            }
            throw new ResourceException("createManagedConnection failed", (Throwable)ex);
        }
    }

    private ManagedConnection createInboundConnection(ActivationSpecImpl iActivationSpec) throws ResourceException {
        SocketSessionLayer session = new SocketSessionLayer();
        ManagedConnectionImpl connection = null;
        try {
            session.connect(iActivationSpec);
        }
        catch (BaanConnectionException ex) {
            LOG.error(Logger.EVENT_FAILURE, "createInboundConnection --> BaanConnectionException", (Throwable)ex);
            if (this.mLogWriter != null) {
                this.mLogWriter.println(ex);
            }
            throw new ResourceException("createInboundConnection failed", (Throwable)ex);
        }
        ConnectionSpecImpl spec = new ConnectionSpecImpl();
        spec.setPort(iActivationSpec.getPort());
        spec.setActivationType("socketin");
        connection = new ManagedConnectionImpl(this, spec, session);
        connection.setActivationSpec(iActivationSpec);
        return connection;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ManagedConnection matchManagedConnections(Set iConnections, Subject iSubject, ConnectionRequestInfo iConnectionRequestInfo) throws ResourceException {
        ConnectionSpecImpl connectionSpec;
        if (iConnectionRequestInfo == null) {
            if (this.mOutboundConnectionPoint == null || this.mOutboundConnectionPoint.length() <= 0) throw new ResourceException("No default connectionpoint available");
            connectionSpec = new ConnectionSpecImpl(this.mOutboundConnectionPoint);
        } else {
            if (!(iConnectionRequestInfo instanceof ConnectionSpecImpl)) {
                throw new ResourceException("ConnectionRequestInfo not of type ConnectionSpecImpl");
            }
            connectionSpec = (ConnectionSpecImpl)iConnectionRequestInfo;
        }
        Iterator it = iConnections.iterator();
        return this.matchManagedConnections(it, iSubject, connectionSpec);
    }

    public ManagedConnection matchManagedConnections(Iterator iConnections, Subject iSubject, ConnectionSpecImpl iConnectionSpec) throws ResourceException {
        if (LOG.isDebugEnabled()) {
            String message = "matchManagedConnections((Set)" + iConnections.toString() + ", (Subject)" + (iSubject == null ? "null" : iSubject.toString()) + ", (ConnectionRequestInfo)" + iConnectionSpec.toString() + ")";
            LOG.debug(Logger.EVENT_UNSPECIFIED, message);
        }
        PasswordCredential pc = this.getPasswordCredential(iSubject, iConnectionSpec);
        ConnectionSpecImpl config = this.createConnectionConfig(iConnectionSpec, pc);
        while (iConnections.hasNext()) {
            Object obj = iConnections.next();
            if (!(obj instanceof ManagedConnectionImpl)) continue;
            ManagedConnectionImpl managedConnection = (ManagedConnectionImpl)obj;
            ManagedConnectionFactoryImpl managedConnectionFactory = managedConnection.getManagedConnectionFactory();
            if (!config.equals(managedConnection.getConnectionSpec()) || !managedConnectionFactory.equals(this) || !managedConnection.isValid()) continue;
            LOG.debug(Logger.EVENT_UNSPECIFIED, "Re-using idle connection of ERP user: " + config.getUser());
            return managedConnection;
        }
        return null;
    }

    public PrintWriter getLogWriter() throws ResourceException {
        LOG.debug(Logger.EVENT_UNSPECIFIED, "getLogWriter()");
        return this.mLogWriter;
    }

    public void setLogWriter(PrintWriter iLogWriter) throws ResourceException {
        LOG.debug(Logger.EVENT_UNSPECIFIED, "setLogWriter((PrintWriter)" + iLogWriter.toString() + ")");
        this.mLogWriter = iLogWriter;
    }

    private PasswordCredential getPasswordCredential(final Subject subject, ConnectionSpecImpl info) throws ResourceException {
        PasswordCredential pc = null;
        if (subject == null) {
            if (info == null) {
                LOG.error(Logger.EVENT_UNSPECIFIED, "No Subject and no ConnectionRequestInfo supplied");
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(Logger.EVENT_UNSPECIFIED, "Using ConnectionRequestInfo to create PasswordCredential instance");
                }
                pc = new PasswordCredential(info.getUser(), info.getPassword().toCharArray());
                pc.setManagedConnectionFactory((ManagedConnectionFactory)this);
            }
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug(Logger.EVENT_UNSPECIFIED, "Using Subject to create PasswordCredential instance");
            }
            pc = (PasswordCredential)AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    Set<PasswordCredential> creds = subject.getPrivateCredentials(PasswordCredential.class);
                    for (PasswordCredential temp : creds) {
                        if (!temp.getManagedConnectionFactory().equals((Object)ManagedConnectionFactoryImpl.this)) continue;
                        if (LOG.isDebugEnabled()) {
                            LOG.debug(Logger.EVENT_UNSPECIFIED, "Found matching PasswordCredential for user:" + temp.getUserName());
                        }
                        return temp;
                    }
                    LOG.info(Logger.EVENT_UNSPECIFIED, "No matching PasswordCreditial found");
                    return null;
                }
            });
        }
        if (pc == null) {
            throw new SecurityException("No PasswordCredential found");
        }
        return pc;
    }

    private ConnectionSpecImpl createConnectionConfig(String backendReference) throws ResourceException {
        int port;
        ConnectionSpecImpl config = new ConnectionSpecImpl();
        if (backendReference == null || !backendReference.startsWith("tcp://")) {
            throw new ResourceException("Invalid backend reference: " + backendReference);
        }
        int lastColon = backendReference.lastIndexOf(":");
        String portNumber = backendReference.substring(lastColon + 1);
        String hostName = backendReference.substring(6, lastColon);
        try {
            port = Integer.parseInt(portNumber);
        }
        catch (NumberFormatException e) {
            throw new ResourceException("Invalid port number in backend reference: " + backendReference);
        }
        config.setBackend(hostName);
        config.setPort(port);
        return config;
    }

    public ConnectionSpecImpl createConnectionConfig(ConnectionSpecImpl iConnectionRequestInfo, PasswordCredential iCredential) {
        PrincipalMapEntry entry;
        ConnectionSpecImpl config = (ConnectionSpecImpl)iConnectionRequestInfo.clone();
        String erpUser = iCredential.getUserName();
        String erpPassword = new String(iCredential.getPassword());
        if (this.mPrincipalMap != null && (entry = this.mPrincipalMap.getEntry(config.getBackend(), iCredential.getUserName())) != null) {
            erpUser = entry.getUser();
            erpPassword = entry.getPassword();
            if (LOG.isDebugEnabled()) {
                LOG.debug(Logger.EVENT_UNSPECIFIED, "Map user: " + iCredential.getUserName() + " on ERP user: " + erpUser);
            }
        }
        config.setUser(erpUser);
        config.setPassword(erpPassword);
        return config;
    }

    public String getOutboundConnectionPoint() {
        return this.mOutboundConnectionPoint;
    }

    public void setOutboundConnectionPoint(String iOutboundConnectionPoint) {
        LOG.debug(Logger.EVENT_UNSPECIFIED, "setOutboundConnectionPoint(String " + iOutboundConnectionPoint + ")");
        this.mOutboundConnectionPoint = iOutboundConnectionPoint;
    }

    public void setMapFile(String iMapFile) {
        LOG.debug(Logger.EVENT_UNSPECIFIED, "setMapFile(" + iMapFile + ")");
        this.mMapFile = iMapFile;
    }

    public String getMapFile() {
        LOG.debug(Logger.EVENT_UNSPECIFIED, "getMapFile()");
        return this.mMapFile;
    }

    private void processMapFile() {
        if (LOG.isDebugEnabled()) {
            LOG.debug(Logger.EVENT_UNSPECIFIED, "processMapFile(), mapFile: " + (this.mMapFile == null ? "null" : this.mMapFile));
        }
        if (this.mMapFile != null && this.mMapFile.length() > 0) {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            URL url = loader.getResource(this.mMapFile);
            if (url == null) {
                LOG.info(Logger.EVENT_UNSPECIFIED, "mapFile not found: " + this.mMapFile);
                return;
            }
            this.mPrincipalMap = new PrincipalMap(url);
            if (!this.mPrincipalMap.init()) {
                LOG.error(Logger.EVENT_FAILURE, "Failed to generate principal map from file: " + this.mMapFile);
                this.mPrincipalMap = null;
            }
        }
    }

    public void setKeyStore(String iPath, String iPassword) {
        this.m_storeParameters.setKeyStore(iPath);
        this.m_storeParameters.setKeyStorePassword(iPassword);
    }

    public void setTrustStore(String iPath, String iPassword) {
        this.m_storeParameters.setTrustStore(iPath);
        this.m_storeParameters.setTrustStorePassword(iPassword);
    }

    void setReplyTimeout(int timeout) {
        this.m_replyTimeout = timeout;
    }

    int getReplyTimeout() {
        return this.m_replyTimeout;
    }

    public void authenticate(ConnectionRequestInfo iConnectionSpec) throws ResourceException {
        if (!(iConnectionSpec instanceof ConnectionSpecImpl)) {
            throw new ResourceException("iConnectionSpec not of type ConnectionSpecImpl");
        }
        ConnectionSpecImpl connectionRequestInfo = (ConnectionSpecImpl)iConnectionSpec;
        int connectionMethod = connectionRequestInfo.getConnectionMethod();
        PasswordCredential pc = this.getPasswordCredential(null, connectionRequestInfo);
        try (SessionLayer session = null;){
            ConnectionSpecImpl config = this.createConnectionConfig(connectionRequestInfo, pc);
            session = this.getSessionLayer(connectionMethod);
            session.validate(config);
        }
    }

    private SessionLayer getSessionLayer(int connectionMethod) {
        SessionLayer session;
        switch (connectionMethod) {
            case 3: 
            case 7: 
            case 9: {
                session = new SocketSessionLayer();
                break;
            }
            case 10: 
            case 11: {
                session = new HttpSessionLayer(this.m_storeParameters);
                break;
            }
            default: {
                session = new DsSessionLayer(this.m_storeParameters);
            }
        }
        return session;
    }
}

