/*
 * Decompiled with CFR 0.152.
 */
package com.infor.erpln.jca;

import com.infor.erpln.jca.BDEConsumer;
import com.infor.erpln.jca.BDEException;
import com.infor.erpln.jca.BDERequestRecord;
import com.infor.erpln.jca.BDEResponseRecord;
import com.infor.erpln.jca.BODResponse;
import com.infor.erpln.jca.InteractionImpl;
import com.infor.erpln.jca.InteractionSpecBde;
import com.infor.erpln.jca.ManagedConnectionImpl;
import com.infor.erpln.jca.MessageOption;
import com.infor.erpln.jca.RestResponse;
import com.infor.erpln.jca.TransactionCCI;
import com.infor.erpln.jca.TransactionImpl;
import com.infor.erpln.protocol.BaanConnectionException;
import com.infor.erpln.protocol.DispatchBdeResult;
import com.infor.erpln.protocol.JcaHandler;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.EnumSet;
import java.util.Set;
import java.util.Vector;
import javax.resource.ResourceException;
import javax.resource.cci.Connection;
import javax.resource.cci.ConnectionMetaData;
import javax.resource.cci.Interaction;
import javax.resource.cci.InteractionSpec;
import javax.resource.cci.LocalTransaction;
import javax.resource.cci.Record;
import javax.resource.cci.ResultSetInfo;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.Logger;

public class ConnectionImpl
implements Connection {
    private final ManagedConnectionImpl mManagedConnection;
    private JcaHandler mBdeManager;
    private TransactionImpl mTransImpl;
    private boolean mClosed = false;
    private final int mBdeManagerCompany;
    private static final Logger LOG = ESAPI.getLogger(ConnectionImpl.class);

    public ConnectionImpl(ManagedConnectionImpl iManagedConnection, JcaHandler iBdeManager, int iBdeManagerCompany) {
        LOG.debug(Logger.EVENT_UNSPECIFIED, "ConnectionImpl(ManagedConnectionImpl)");
        this.mManagedConnection = iManagedConnection;
        this.mBdeManager = iBdeManager;
        this.mBdeManagerCompany = iBdeManagerCompany;
    }

    public void close() throws ResourceException {
        if (this.mClosed) {
            LOG.debug(Logger.EVENT_UNSPECIFIED, "close(): already closed");
        } else {
            this.mClosed = true;
            LOG.debug(Logger.EVENT_UNSPECIFIED, "close()");
            this.mManagedConnection.sendEvent(1, null, this);
        }
    }

    public boolean isRunning() {
        return this.mBdeManager != null && this.mBdeManager.isRunning();
    }

    public boolean isTakenFromPool() {
        return this.mManagedConnection.isTakenFromPool();
    }

    public Interaction createInteraction() throws ResourceException {
        LOG.debug(Logger.EVENT_UNSPECIFIED, "createInteraction()");
        return new InteractionImpl(this);
    }

    public LocalTransaction getLocalTransaction() throws ResourceException {
        LOG.debug(Logger.EVENT_UNSPECIFIED, "getLocalTransaction()");
        if (this.mTransImpl == null) {
            this.mTransImpl = new TransactionImpl(this.mBdeManager);
        }
        return new TransactionCCI(this.mManagedConnection, this.mTransImpl);
    }

    public ConnectionMetaData getMetaData() throws ResourceException {
        LOG.debug(Logger.EVENT_UNSPECIFIED, "getMetaData()");
        if (this.mManagedConnection == null) {
            throw new ResourceException("Invalid connection");
        }
        return this.mManagedConnection.getMetaData();
    }

    public ResultSetInfo getResultSetInfo() throws ResourceException {
        LOG.debug(Logger.EVENT_UNSPECIFIED, "getResultSetInfo()");
        return null;
    }

    public String getStartupMessages() {
        return this.mManagedConnection.getStartupMessages();
    }

    public Record execute(InteractionSpec iInteractionSpec, Record iRecord) throws ResourceException {
        this.checkConnection();
        try {
            if (iInteractionSpec instanceof InteractionSpecBde) {
                InteractionSpecBde ispec = (InteractionSpecBde)iInteractionSpec;
                BDEResponseRecord output = null;
                if (!(iRecord instanceof BDERequestRecord)) {
                    throw new ResourceException("Input record no instance of BDERequestRecord");
                }
                BDERequestRecord input = (BDERequestRecord)iRecord;
                DispatchBdeResult result = this.mBdeManager.dispatchBDE(ispec.getBdeName(), ispec.getBdeMethod(), input.getData());
                if (result.getReturnValue() != 0) {
                    throw new BDEException("BDE execution returned an error", result.getResponse(), result.getReturnValue());
                }
                output = new BDEResponseRecord();
                output.setResponse(result.getResponse());
                output.setReturnValue(result.getReturnValue());
                return output;
            }
        }
        catch (BaanConnectionException e) {
            throw this.handleConnectionException(e);
        }
        return null;
    }

    public InputStream openForRead(String iServerFile, boolean iTextMode) throws IOException, ResourceException {
        return this.openForRead(iServerFile, iTextMode, false);
    }

    public InputStream openForRead(String iServerFile, boolean iTextMode, boolean iPolling) throws IOException, ResourceException {
        this.checkConnection();
        try {
            return this.mManagedConnection.openForRead(iServerFile, iTextMode, iPolling);
        }
        catch (BaanConnectionException e) {
            throw this.handleConnectionException(e);
        }
    }

    public OutputStream openForWrite(String iServerFile, boolean iTextMode) throws IOException, ResourceException {
        this.checkConnection();
        try {
            return this.mManagedConnection.openForWrite(iServerFile, iTextMode);
        }
        catch (BaanConnectionException e) {
            throw this.handleConnectionException(e);
        }
    }

    public BODResponse executeBODV2(byte[] jsonHeader, byte[] xmlBod) throws ResourceException {
        this.checkConnection();
        try {
            return this.mBdeManager.dispatchBOD(jsonHeader, xmlBod);
        }
        catch (BaanConnectionException e) {
            throw this.handleConnectionException(e);
        }
    }

    public RestResponse executeRestCall(byte[] httpRequest, byte[] body) throws ResourceException {
        this.checkConnection();
        try {
            return this.mBdeManager.dispatchRest(httpRequest, body);
        }
        catch (BaanConnectionException e) {
            throw this.handleConnectionException(e);
        }
    }

    public byte[] executeBaanDll(byte[] a_request, Vector<String> a_errors) throws ResourceException {
        return this.executeBaanDll(a_request, a_errors, null, EnumSet.noneOf(MessageOption.class));
    }

    public byte[] executeBaanDll(byte[] a_request, Vector<String> a_errors, OutputStream a_dsMessages) throws ResourceException {
        return this.executeBaanDll(a_request, a_errors, a_dsMessages, EnumSet.noneOf(MessageOption.class));
    }

    public byte[] executeBaanDll(byte[] a_request, Vector<String> a_errors, OutputStream a_dsMessages, Set<MessageOption> a_options) throws ResourceException {
        this.checkConnection();
        try {
            return this.mBdeManager.executeBaanDll(a_request, a_errors, a_dsMessages, a_options);
        }
        catch (BaanConnectionException e) {
            throw this.handleConnectionException(e);
        }
    }

    public byte[] executeSQLQuery(byte[] a_request, Vector<String> a_errors) throws ResourceException {
        this.checkConnection();
        try {
            return this.mBdeManager.executeSQLQuery(a_request, a_errors);
        }
        catch (BaanConnectionException e) {
            throw this.handleConnectionException(e);
        }
    }

    public void activateListener(BDEConsumer iConsumer) throws ResourceException {
        LOG.debug(Logger.EVENT_UNSPECIFIED, "activateListener(BDEConsumer)");
        this.mManagedConnection.activateListener(iConsumer);
    }

    public void invalidate() {
        LOG.debug(Logger.EVENT_UNSPECIFIED, "invalidate()");
        if (!this.mClosed) {
            try {
                this.close();
            }
            catch (ResourceException resourceException) {
                // empty catch block
            }
        }
        if (this.mBdeManager != null) {
            try {
                this.mBdeManager.close();
            }
            catch (BaanConnectionException baanConnectionException) {
                // empty catch block
            }
            this.mBdeManager = null;
        }
    }

    private void checkConnection() throws ResourceException {
        if (this.mClosed) {
            BaanConnectionException nested = new BaanConnectionException("Connection already closed", 5);
            throw new ResourceException("Invalid connection", (Throwable)nested);
        }
    }

    private ResourceException handleConnectionException(BaanConnectionException iException) {
        LOG.debug(Logger.EVENT_UNSPECIFIED, "handleConnectionException reason=" + iException.getReason());
        this.mManagedConnection.sendEvent(5, iException, this);
        return new ResourceException("Communication problem", (Throwable)iException);
    }

    public boolean isClosed() {
        return this.mClosed;
    }

    public void setOpened() {
        this.mClosed = false;
    }

    public int getBdeManagerCompany() {
        return this.mBdeManagerCompany;
    }
}

