/*
 * Decompiled with CFR 0.152.
 */
package com.infor.erpln.jca;

import com.infor.erpln.jca.ConnectionSpecImpl;
import com.infor.erpln.jca.ConnectionSupervisor;
import com.infor.erpln.jca.IExternalActivation;
import com.infor.erpln.jca.ManagedConnectionFactoryImpl;
import com.infor.erpln.jca.PoolStatistics;
import com.infor.erpln.jca.ResourceAdapterMetaDataImpl;
import com.infor.erpln.util.ConnectionPointsManager;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.resource.Referenceable;
import javax.resource.ResourceException;
import javax.resource.cci.Connection;
import javax.resource.cci.ConnectionFactory;
import javax.resource.cci.ConnectionSpec;
import javax.resource.cci.RecordFactory;
import javax.resource.cci.ResourceAdapterMetaData;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnectionFactory;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.Logger;

public class ConnectionFactoryImpl
implements ConnectionFactory,
Serializable,
Referenceable {
    private ManagedConnectionFactory mManagedConnectionFactory;
    private ConnectionManager mConnectionManager;
    private Reference mReference;
    private static final Logger LOG = ESAPI.getLogger(ConnectionFactoryImpl.class);
    private ConnectionPointsManager mConnPointsManager = new ConnectionPointsManager();

    public ConnectionFactoryImpl() {
        this(new ManagedConnectionFactoryImpl(), null);
    }

    public ConnectionFactoryImpl(ManagedConnectionFactory iManagedConnectionFactory, ConnectionManager iConnectionManager) {
        LOG.debug(Logger.EVENT_UNSPECIFIED, "ConnectionFactoryImpl(ManagedConnectionFactory, ConnectionManager)");
        this.mManagedConnectionFactory = iManagedConnectionFactory;
        this.mConnectionManager = iConnectionManager == null ? new ConnectionSupervisor() : iConnectionManager;
    }

    public ConnectionFactoryImpl(IExternalActivation activationImpl) {
        this(new ManagedConnectionFactoryImpl(activationImpl), null);
    }

    public void destroy() {
        LOG.debug(Logger.EVENT_UNSPECIFIED, "destroy");
        if (this.mConnectionManager instanceof ConnectionSupervisor) {
            ((ConnectionSupervisor)this.mConnectionManager).destroy();
            this.mConnPointsManager.cleanup();
        }
    }

    public void update(String name) {
        LOG.debug(Logger.EVENT_UNSPECIFIED, "update connection point " + name);
        this.mConnPointsManager.cleanup();
    }

    public Connection getConnection(ConnectionSpec iConnectionSpec) throws ResourceException {
        LOG.debug(Logger.EVENT_UNSPECIFIED, "getConnection(ConnectionSpec)");
        if (!(iConnectionSpec instanceof ConnectionRequestInfo)) {
            throw new ResourceException("Wrong type of iConnectionSpec");
        }
        if (iConnectionSpec instanceof ConnectionSpecImpl) {
            this.mConnPointsManager.load();
            ((ConnectionSpecImpl)iConnectionSpec).setConnectionPointsManager(this.mConnPointsManager);
        }
        return (Connection)this.mConnectionManager.allocateConnection(this.mManagedConnectionFactory, (ConnectionRequestInfo)iConnectionSpec);
    }

    public Connection getConnection() throws ResourceException {
        LOG.debug(Logger.EVENT_UNSPECIFIED, "getConnection()");
        return (Connection)this.mConnectionManager.allocateConnection(this.mManagedConnectionFactory, null);
    }

    public ResourceAdapterMetaData getMetaData() throws ResourceException {
        LOG.debug(Logger.EVENT_UNSPECIFIED, "getMetaData()");
        return new ResourceAdapterMetaDataImpl();
    }

    public RecordFactory getRecordFactory() throws ResourceException {
        LOG.debug(Logger.EVENT_UNSPECIFIED, "getRecordFactory()");
        throw new ResourceException("ConnectionFactoryImpl.getRecordFactory() not implemented");
    }

    public void setReference(Reference iReference) {
        LOG.debug(Logger.EVENT_UNSPECIFIED, "setReference((Reference) " + iReference.toString() + ")");
        this.mReference = iReference;
    }

    public Reference getReference() throws NamingException {
        LOG.debug(Logger.EVENT_UNSPECIFIED, "getReference()");
        return this.mReference;
    }

    public void authenticate(ConnectionSpec iConnectionSpec) throws ResourceException {
        LOG.debug(Logger.EVENT_UNSPECIFIED, "authenticate(ConnectionSpec)");
        if (!(iConnectionSpec instanceof ConnectionRequestInfo)) {
            throw new ResourceException("Wrong type of iConnectionSpec");
        }
        ((ManagedConnectionFactoryImpl)this.mManagedConnectionFactory).authenticate((ConnectionRequestInfo)iConnectionSpec);
    }

    public void setLocation(String iFilename) {
        this.mConnPointsManager.setConnectionPointsLocation(iFilename);
    }

    public ConnectionPointsManager getConnectionPointsManager() {
        return this.mConnPointsManager;
    }

    public List<PoolStatistics> getPoolStatistics() {
        if (this.mConnectionManager instanceof ConnectionSupervisor) {
            LOG.info(Logger.EVENT_UNSPECIFIED, "getPoolStatistics()");
            return ((ConnectionSupervisor)this.mConnectionManager).getPoolStatistics();
        }
        return new ArrayList<PoolStatistics>();
    }

    public void setKeyStore(String iPath, String iPassword) {
        if (this.mManagedConnectionFactory instanceof ManagedConnectionFactoryImpl) {
            ((ManagedConnectionFactoryImpl)this.mManagedConnectionFactory).setKeyStore(iPath, iPassword);
        }
    }

    public void setTrustStore(String iPath, String iPassword) {
        if (this.mManagedConnectionFactory instanceof ManagedConnectionFactoryImpl) {
            ((ManagedConnectionFactoryImpl)this.mManagedConnectionFactory).setTrustStore(iPath, iPassword);
        }
    }

    public void setReplyTimeout(int timeout) {
        if (this.mManagedConnectionFactory instanceof ManagedConnectionFactoryImpl) {
            ((ManagedConnectionFactoryImpl)this.mManagedConnectionFactory).setReplyTimeout(timeout);
        }
    }
}

