/*
 * Decompiled with CFR 0.152.
 */
package com.infor.erpln.jca;

import java.io.UnsupportedEncodingException;
import javax.resource.cci.Record;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.Logger;

public class BDEResponseRecord
implements Record {
    private static final long serialVersionUID = 2444764471795551334L;
    private static final Logger LOG = ESAPI.getLogger(BDEResponseRecord.class);
    private int mReturnValue;
    private byte[] mResponse;
    private String mRecordName;
    private String mRecordShortDescription;

    public String getRecordName() {
        return this.mRecordName;
    }

    public String getRecordShortDescription() {
        return this.mRecordShortDescription;
    }

    public void setRecordName(String iRecordName) {
        this.mRecordName = iRecordName;
    }

    public void setRecordShortDescription(String iRecordShortDescription) {
        this.mRecordShortDescription = iRecordShortDescription;
    }

    public byte[] getResponse() {
        return this.mResponse;
    }

    public String getResponseString() {
        String responseString = null;
        try {
            responseString = new String(this.mResponse, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            LOG.error(Logger.EVENT_FAILURE, "getResponseString() exception", (Throwable)e);
        }
        return responseString;
    }

    public void setResponse(byte[] response) {
        this.mResponse = response;
    }

    public int getReturnValue() {
        return this.mReturnValue;
    }

    public void setReturnValue(int returnValue) {
        this.mReturnValue = returnValue;
    }

    public Object clone() {
        BDEResponseRecord retObj = new BDEResponseRecord();
        retObj.mReturnValue = this.mReturnValue;
        if (this.mResponse != null) {
            retObj.mResponse = (byte[])this.mResponse.clone();
        }
        retObj.mRecordName = this.mRecordName;
        retObj.mRecordShortDescription = this.mRecordShortDescription;
        return retObj;
    }
}

