/*
 * Decompiled with CFR 0.152.
 */
package com.infor.erpln.jca;

import com.infor.erpln.jca.BDEConsumer;
import com.infor.erpln.jca.ConnectionSpecImpl;
import com.infor.erpln.jca.MessageReceiver;
import javax.resource.ResourceException;
import javax.resource.spi.UnavailableException;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.Logger;

public class BDEReceiver
extends MessageReceiver
implements BDEConsumer {
    private static final Logger LOG = ESAPI.getLogger(BDEReceiver.class);

    BDEReceiver(ConnectionSpecImpl iConnSpec) {
        super(iConnSpec);
    }

    @Override
    protected void init() throws ResourceException {
        super.init();
        this.mConnection.activateListener(this);
    }

    @Override
    public int onBDEMessage(byte[] bdeMessage) {
        int retVal = -1;
        LOG.info(Logger.EVENT_UNSPECIFIED, "onBDEMessage()");
        for (MessageEndpointFactory factory : this.mEndpointFactories) {
            try {
                BDEConsumer endpoint = (BDEConsumer)factory.createEndpoint(null);
                retVal = endpoint.onBDEMessage(bdeMessage);
            }
            catch (UnavailableException e) {
                retVal = -1;
                LOG.error(Logger.EVENT_FAILURE, "Failed creating endpoint: " + e.toString(), (Throwable)e);
            }
        }
        return retVal;
    }
}

