/*
 * Decompiled with CFR 0.152.
 */
package com.infor.ln.workbench.shared.web;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class AuthState
implements Serializable {
    private ID m_state = ID.IDLE;
    private String m_error = "";
    private String m_description = "";
    private String m_endpoint = "";
    private Map<String, String> m_parameters = new HashMap<String, String>();

    public String toString() {
        return this.m_state.toString();
    }

    public boolean isIdle() {
        return this.m_state == ID.IDLE;
    }

    public boolean isLoginBusy() {
        return this.m_state == ID.LOGIN_BUSY;
    }

    public boolean isAuthenticated() {
        return this.m_state == ID.AUTHENTICATED;
    }

    public boolean isError() {
        return this.m_state == ID.ERROR;
    }

    public String getError() {
        return this.m_error;
    }

    public String getErrorDescription() {
        return this.m_description;
    }

    public String getEndpoint() {
        return this.m_endpoint;
    }

    public void setEndpoint(String uri) {
        this.m_endpoint = uri;
    }

    public Map<String, String> getParameters() {
        return this.m_parameters;
    }

    public void setParameters(Map<String, String> parameters) {
        this.m_parameters = parameters;
    }

    public static AuthState getInstance(ID stateID) {
        return new AuthState(stateID);
    }

    public static AuthState getErrorInstance(String errorCode, String errorDescription) {
        AuthState errorState = AuthState.getInstance(ID.ERROR);
        errorState.m_error = errorCode == null ? "" : errorCode;
        errorState.m_description = errorDescription == null ? "" : errorDescription;
        return errorState;
    }

    private AuthState(ID state) {
        this.m_state = state;
    }

    protected AuthState() {
    }

    public static enum ID {
        IDLE,
        LOGIN_BUSY,
        AUTHENTICATED,
        ERROR;

    }
}

