/*
 * Decompiled with CFR 0.152.
 */
package com.infor.ln.workbench.shared;

import com.infor.ln.workbench.shared.Atr;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SpodsElement
implements Serializable {
    private String m_name;
    private HashMap<String, String> m_atrs = new HashMap();
    private List<SpodsElement> m_children = new ArrayList<SpodsElement>();
    private SpodsElement m_parent = null;
    private String m_value = null;

    public SpodsElement() {
    }

    public SpodsElement(String name) {
        this.m_name = name;
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public String getValue() {
        return this.m_value;
    }

    public void setValue(String value) {
        this.m_value = value;
    }

    public HashMap<String, String> getAtrs() {
        return this.m_atrs;
    }

    public void setAtrs(HashMap<String, String> atrs) {
        this.m_atrs = atrs;
    }

    public String getAtr(String name) {
        return this.m_atrs.get(name);
    }

    public void setAtr(String name, String value) {
        this.m_atrs.put(name, value);
    }

    public void setAtr(Atr atr) {
        this.setAtr(atr.getName(), atr.getValue());
    }

    public Integer getIntAtr(String name) {
        String str = this.getAtr(name);
        if (str != null && str.length() > 0) {
            return Integer.valueOf(str);
        }
        return null;
    }

    public void setAtr(String name, int value) {
        String str = String.valueOf(value);
        this.setAtr(name, str);
    }

    public boolean getBoolAtr(String name) {
        String str = this.getAtr(name);
        return "1".equals(str);
    }

    public void setAtr(String name, boolean set) {
        this.setAtr(name, set ? "1" : "0");
    }

    public boolean getYesNoAtr(String name) {
        String str = this.getAtr(name);
        return "1".equals(str);
    }

    public void setYesNoAtr(String name, boolean set) {
        this.setAtr(name, set ? "1" : "2");
    }

    public void removeAtr(String name) {
        this.m_atrs.remove(name);
    }

    public List<SpodsElement> getChildren() {
        return this.m_children;
    }

    public void setChildren(List<SpodsElement> children) {
        this.m_children = children;
        for (SpodsElement child : children) {
            child.m_parent = this;
        }
    }

    public void addChild(SpodsElement child) {
        this.m_children.add(child);
        child.m_parent = this;
    }

    public void addChild(int index, SpodsElement child) {
        this.m_children.add(index, child);
        child.m_parent = this;
    }

    public void insertChild(SpodsElement child) {
        this.m_children.add(0, child);
        child.m_parent = this;
    }

    public int indexOf(SpodsElement child) {
        return this.m_children.indexOf(child);
    }

    public void removeChild(SpodsElement child) {
        child.m_parent = null;
        this.m_children.remove(child);
    }

    public void clearChildren() {
        for (SpodsElement child : this.m_children) {
            child.m_parent = null;
        }
        this.m_children.clear();
    }

    public SpodsElement getParent() {
        return this.m_parent;
    }

    public SpodsElement getChild(String name) {
        for (SpodsElement element : this.m_children) {
            if (!element.getName().equals(name)) continue;
            return element;
        }
        return null;
    }

    public SpodsElement findChild(String name) {
        SpodsElement foundElement = null;
        if (this.getName().equals(name)) {
            foundElement = this;
        } else {
            SpodsElement element;
            Iterator<SpodsElement> iterator = this.m_children.iterator();
            while (iterator.hasNext() && (foundElement = (element = iterator.next()).findChild(name)) == null) {
            }
        }
        return foundElement;
    }

    public SpodsElement getShallowCopy() {
        SpodsElement copy = new SpodsElement(this.getName());
        HashMap atrs = (HashMap)this.m_atrs.clone();
        copy.setAtrs(atrs);
        copy.setValue(this.getValue());
        return copy;
    }

    public SpodsElement getDeepCopy() {
        SpodsElement copy = this.getShallowCopy();
        for (SpodsElement child : this.getChildren()) {
            SpodsElement childCopy = child.getDeepCopy();
            copy.addChild(childCopy);
        }
        return copy;
    }

    public boolean deepEquals(SpodsElement other) {
        if (this.m_name == null ? other.m_name != null : !this.m_name.equals(other.m_name)) {
            return false;
        }
        if (!this.m_atrs.equals(other.m_atrs)) {
            return false;
        }
        if (this.m_children.size() != other.m_children.size()) {
            return false;
        }
        for (int i = 0; i < this.m_children.size(); ++i) {
            if (this.m_children.get(i).deepEquals(other.m_children.get(i))) continue;
            return false;
        }
        return !(this.m_value == null ? other.m_value != null : !this.m_value.equals(other.m_value));
    }

    public void mergeAtrs(SpodsElement from) {
        Set<Map.Entry<String, String>> fromSet = from.getAtrs().entrySet();
        for (Map.Entry<String, String> entry : fromSet) {
            this.setAtr(entry.getKey(), entry.getValue());
        }
    }
}

