/*
 * Decompiled with CFR 0.152.
 */
package com.infor.ln.workbench.server.web;

import com.infor.erpln.jca.ConnectionFactoryImpl;
import com.infor.erpln.jca.ConnectionImpl;
import com.infor.erpln.jca.ConnectionSpecImpl;
import com.infor.erpln.jca.bdeclient.BdeException;
import com.infor.erpln.jca.bdeclient.JcaBdeManager;
import com.infor.erpln.jca.dllclient.BaanDLLCall;
import com.infor.erpln.jca.dllclient.BaanDLLCallException;
import com.infor.ln.workbench.server.auth.Context;
import com.infor.ln.workbench.server.dll.DLLTools;
import com.infor.ln.workbench.server.dll.WorkbenchLayout;
import com.infor.ln.workbench.server.dll.WorkbenchSettings;
import com.infor.ln.workbench.server.web.ClientLogger;
import com.infor.ln.workbench.server.web.EventLog;
import com.infor.ln.workbench.server.web.LogEntry;
import com.infor.ln.workbench.server.web.SessionState;
import com.infor.ln.workbench.server.web.WorkbenchStartParameters;
import com.infor.ln.workbench.shared.AbstractSettings;
import com.infor.ln.workbench.shared.Layout;
import com.infor.ln.workbench.shared.resources.AbstractLNEnums;
import com.infor.ln.workbench.shared.resources.AbstractLNLabels;
import com.infor.ln.workbench.shared.resources.AbstractLNMessages;
import com.infor.ln.workbench.shared.resources.LNResources;
import com.infor.ln.workbench.shared.web.AuthState;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.resource.ResourceException;
import javax.resource.cci.Connection;
import javax.resource.cci.ConnectionSpec;
import javax.servlet.http.HttpServletRequest;
import org.apache.logging.log4j.core.LogEvent;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.Logger;

public class WorkbenchState {
    private static final Logger LOG = ESAPI.getLogger(WorkbenchState.class);
    private final String m_conId;
    private final String m_workbenchPid;
    private final String m_moduleName;
    private final String m_sessionCode;
    private final SessionState m_sessionState;
    private final ConnectionImpl m_jcaConnection;
    private final List<ConnectionImpl> m_sharedConnections = new ArrayList<ConnectionImpl>();
    private final String m_lnUser;
    private final Map<String, Object> m_attributes = new HashMap<String, Object>();
    private Future<?> m_resourcesFuture;
    private final boolean m_developmentMode;
    private final ConnectionFactoryImpl m_factory;
    private final ConnectionSpecImpl m_spec;
    private final String m_ticket;
    private static final ThreadLocal<WorkbenchState> s_perThreadApplication = new ThreadLocal();
    private EventLog m_eventLog;
    private final boolean m_cloudEnabled;
    private boolean m_sessionTimeout;
    private final String m_azureAppID;
    private Context m_authContext;

    public WorkbenchState(WorkbenchStartParameters startParameters, SessionState a_sessionState) throws IOException, ResourceException {
        ClientLogger sync;
        this.m_conId = startParameters.getConId();
        this.m_workbenchPid = startParameters.getWorkbenchPid();
        this.m_moduleName = startParameters.getConfig().getModuleName();
        this.m_sessionCode = startParameters.getConfig().getSessionCode();
        this.m_sessionState = a_sessionState;
        this.m_developmentMode = startParameters.isDevelopmentMode();
        this.m_cloudEnabled = startParameters.isCloudEnabled();
        this.m_spec = startParameters.getSpec();
        this.m_ticket = startParameters.getTicket();
        this.m_factory = startParameters.getFactory();
        this.m_jcaConnection = (ConnectionImpl)this.m_factory.getConnection((ConnectionSpec)this.m_spec);
        this.m_azureAppID = startParameters.getConfig().getAzureAppID();
        if (startParameters.isStartLogging()) {
            this.enableLogging();
        }
        LOG.info(Logger.EVENT_SUCCESS, "WorkbenchState created, conId: " + this.m_conId);
        String errorText = "Creation of BdeManager failed";
        try {
            this.m_lnUser = this.m_jcaConnection.getMetaData().getUserName();
        }
        catch (ResourceException e) {
            LOG.error(Logger.EVENT_FAILURE, errorText, (Throwable)e);
            throw new IOException(errorText, e);
        }
        if (this.m_sessionState != null && (sync = ClientLogger.getClientLogger(this.m_sessionState.getSession().getServletContext(), true)) != null) {
            sync.createLogQueue(this.getUniqueId(), this);
        }
    }

    public ConnectionImpl createSharedConnection() throws ResourceException {
        ConnectionImpl connection = (ConnectionImpl)this.m_factory.getConnection((ConnectionSpec)this.m_spec);
        this.m_sharedConnections.add(connection);
        return connection;
    }

    public String getConId() {
        return this.m_conId;
    }

    public String getWorkbenchPid() {
        return this.m_workbenchPid;
    }

    protected String getAzureAppID() {
        return this.m_azureAppID;
    }

    public SessionState getSessionState() {
        return this.m_sessionState;
    }

    public JcaBdeManager createBdeManager() throws BdeException {
        return WorkbenchState.createBdeManager(this.m_jcaConnection);
    }

    public static JcaBdeManager createBdeManager(ConnectionImpl jcaConnection) throws BdeException {
        return new JcaBdeManager((Connection)jcaConnection, true);
    }

    public String getLnUser() {
        return this.m_lnUser;
    }

    public void destroy() {
        ClientLogger sync;
        LOG.info(Logger.EVENT_UNSPECIFIED, "Destroying WorkbenchState, conId: " + this.m_conId);
        this.stopLogging();
        if (this.m_sessionState != null && (sync = ClientLogger.getClientLogger(this.m_sessionState.getSession().getServletContext(), false)) != null) {
            sync.removeLogQueue(this.getUniqueId());
        }
        try {
            for (ConnectionImpl connection : this.m_sharedConnections) {
                connection.close();
            }
            this.m_jcaConnection.close();
        }
        catch (ResourceException resourceException) {
            // empty catch block
        }
    }

    public static void setThreadLocalApplicationState(WorkbenchState state) {
        if (state == null) {
            s_perThreadApplication.remove();
        } else {
            s_perThreadApplication.set(state);
        }
    }

    public static WorkbenchState getThreadLocalApplicationState() {
        return s_perThreadApplication.get();
    }

    public synchronized void enableLogging() {
        if (this.m_eventLog == null) {
            try {
                this.m_eventLog = new EventLog();
                this.m_sessionState.getConfigManager().elevateLogLevel();
                LOG.info(Logger.EVENT_SUCCESS, "Logging enabled, conId: " + this.getConId());
            }
            catch (IOException e) {
                LOG.error(Logger.EVENT_FAILURE, "Exception instantiating EventLog, conId: " + this.getConId(), (Throwable)e);
            }
        }
    }

    public synchronized void stopLogging() {
        if (this.m_eventLog != null) {
            this.m_sessionState.getConfigManager().revertLogLevel();
            this.m_eventLog.destroy();
            this.m_eventLog = null;
            LOG.info(Logger.EVENT_SUCCESS, "Stopped logging, conId: " + this.getConId());
        }
    }

    public boolean isLogging() {
        return this.m_eventLog != null;
    }

    public void appendLog(LogEvent event) {
        if (this.m_eventLog != null) {
            this.m_eventLog.append(event);
        }
    }

    public List<LogEntry> getLogEntries() {
        return this.m_eventLog != null ? this.m_eventLog.getEntries() : new ArrayList();
    }

    public void clearLog() {
        this.m_eventLog.clear();
    }

    public BaanDLLCall createBaanDllCall() {
        return WorkbenchState.createBaanDllCall(this.m_jcaConnection);
    }

    public static BaanDLLCall createBaanDllCall(ConnectionImpl jcaConnection) {
        BaanDLLCall call = new BaanDLLCall();
        call.attachConnection((Connection)jcaConnection);
        return call;
    }

    public void saveWorkbenchLayout(Layout layout) throws BaanDLLCallException {
        LOG.info(Logger.EVENT_UNSPECIFIED, "saveWorkbenchLayout, conId: " + this.m_conId);
        WorkbenchLayout wbLayout = new WorkbenchLayout();
        wbLayout.setLayout(layout);
        wbLayout.setSession(this.m_sessionCode);
        DLLTools dllTools = new DLLTools(this);
        dllTools.executeXmlMethod1("ottstpxdesk", "save.workbench.layout", wbLayout, new Class[0]);
    }

    public Layout loadWorkbenchLayout() throws BaanDLLCallException {
        LOG.info(Logger.EVENT_UNSPECIFIED, "loadWorkbenchLayout, conId: " + this.m_conId);
        WorkbenchLayout wbLayout = new WorkbenchLayout();
        wbLayout.setSession(this.m_sessionCode);
        DLLTools dllTools = new DLLTools(this);
        wbLayout = dllTools.executeXmlMethod1("ottstpxdesk", "load.workbench.layout", wbLayout, new Class[0]);
        return wbLayout.getLayout();
    }

    public void clearWorkbenchLayout() throws BaanDLLCallException {
        LOG.info(Logger.EVENT_UNSPECIFIED, "clearWorkbenchLayout, conId: " + this.m_conId);
        WorkbenchLayout wbLayout = new WorkbenchLayout();
        wbLayout.setSession(this.m_sessionCode);
        DLLTools dllTools = new DLLTools(this);
        dllTools.executeXmlMethod1("ottstpxdesk", "clear.workbench.layout", wbLayout, new Class[0]);
    }

    public <T extends AbstractSettings> void saveWorkbenchSettings(T settings) throws BaanDLLCallException {
        LOG.info(Logger.EVENT_UNSPECIFIED, "saveWorkbenchSettings, conId: " + this.m_conId);
        WorkbenchSettings<T> wbSettings = new WorkbenchSettings<T>();
        wbSettings.setSettings(settings);
        wbSettings.setSession(this.m_sessionCode);
        Class<?> settingsType = settings.getClass();
        DLLTools dllTools = new DLLTools(this);
        dllTools.executeXmlMethod1("ottstpxdesk", "save.workbench.settings", wbSettings, settingsType);
    }

    public <T extends AbstractSettings> T loadWorkbenchSettings(T settings) throws BaanDLLCallException {
        LOG.info(Logger.EVENT_UNSPECIFIED, "loadWorkbenchSettings, conId: " + this.m_conId);
        WorkbenchSettings wbSettings = new WorkbenchSettings();
        wbSettings.setSession(this.m_sessionCode);
        Class<?> settingsType = settings.getClass();
        DLLTools dllTools = new DLLTools(this);
        wbSettings = dllTools.executeXmlMethod1("ottstpxdesk", "load.workbench.settings", wbSettings, settingsType);
        return wbSettings.getSettings();
    }

    public void clearWorkbenchSettings() throws BaanDLLCallException {
        LOG.info(Logger.EVENT_UNSPECIFIED, "clearWorkbenchSettings, conId: " + this.m_conId);
        WorkbenchSettings wbSettings = new WorkbenchSettings();
        wbSettings.setSession(this.m_sessionCode);
        DLLTools dllTools = new DLLTools(this);
        dllTools.executeXmlMethod1("ottstpxdesk", "clear.workbench.settings", wbSettings, AbstractSettings.class);
    }

    public <L extends AbstractLNLabels, E extends AbstractLNEnums, M extends AbstractLNMessages> void getResourcesAsync(final LNResources<L, E, M> resources) {
        LOG.info(Logger.EVENT_UNSPECIFIED, "getResourcesAsync, conId: " + this.m_conId);
        if (this.m_resourcesFuture == null) {
            ExecutorService service = Executors.newSingleThreadExecutor();
            this.m_resourcesFuture = service.submit(new Callable<LNResources<L, E, M>>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public LNResources<L, E, M> call() throws Exception {
                    try {
                        WorkbenchState.setThreadLocalApplicationState(WorkbenchState.this);
                        DLLTools dllTools = new DLLTools(WorkbenchState.this);
                        Object labels = resources.getLabels();
                        Class<?> labelsType = labels.getClass();
                        Object enums = resources.getEnums();
                        Class<?> enumsType = enums.getClass();
                        Object messages = resources.getMessages();
                        Class<?> messagesType = messages.getClass();
                        LNResources lNResources = dllTools.executeXmlMethod1("ottdllwb.label", "get.labels", resources, labelsType, enumsType, messagesType);
                        return lNResources;
                    }
                    finally {
                        WorkbenchState.setThreadLocalApplicationState(null);
                    }
                }
            });
            service.shutdown();
        }
    }

    public <L extends AbstractLNLabels, E extends AbstractLNEnums, M extends AbstractLNMessages> LNResources<L, E, M> getResources() throws ExecutionException, InterruptedException {
        LOG.info(Logger.EVENT_UNSPECIFIED, "getResources, conId: " + this.m_conId);
        if (this.m_resourcesFuture != null) {
            return (LNResources)this.m_resourcesFuture.get();
        }
        return null;
    }

    public InputStream openForRead(String path, boolean mode) throws IOException {
        try {
            return this.m_jcaConnection.openForRead(path, mode);
        }
        catch (ResourceException e) {
            throw new IOException("Resource error", e);
        }
    }

    public OutputStream openForWrite(String path, boolean mode) throws IOException, ResourceException {
        return this.m_jcaConnection.openForWrite(path, mode);
    }

    public void setAttribute(String a_name, Object a_value) {
        this.m_attributes.put(a_name, a_value);
    }

    public Object getAttribute(String a_name) {
        return this.m_attributes.get(a_name);
    }

    public Object removeAttribute(String a_name) {
        return this.m_attributes.remove(a_name);
    }

    public String getModuleName() {
        return this.m_moduleName;
    }

    public boolean isDevelopmentMode() {
        return this.m_developmentMode;
    }

    public final String getUniqueId() {
        return this.m_sessionState.getId() + ":" + this.m_conId;
    }

    public boolean isCloudEnabled() {
        return this.m_cloudEnabled;
    }

    public boolean ping(boolean recentAccess) throws BaanDLLCallException {
        boolean running;
        boolean bl = running = this.m_jcaConnection != null && this.m_jcaConnection.isRunning();
        if (running && recentAccess && this.hasSessionTimeout()) {
            this.pingBshell();
        }
        return running;
    }

    private void pingBshell() throws BaanDLLCallException {
        BaanDLLCall call = this.createBaanDllCall();
        call.setDLL("ottstpxdesk");
        call.setFunction("ping");
        call.setReturnType("void");
        call.execute();
    }

    public boolean hasSessionTimeout() {
        return this.m_sessionTimeout;
    }

    public void setSessionTimeout(boolean sessionTimeout) {
        this.m_sessionTimeout = sessionTimeout;
    }

    public String getTicket() {
        return this.m_ticket;
    }

    public AuthState requestLogin(String clientURI) {
        if (this.m_authContext == null) {
            this.m_authContext = Context.getInstance(this.getConId(), this.getSessionState().getConfigManager().getAuthMetadata());
        }
        return this.m_authContext.doLoginRequest(this.getAzureAppID(), clientURI);
    }

    public AuthState requestLogout() {
        if (this.m_authContext == null) {
            this.m_authContext = Context.getInstance(this.getConId(), this.getSessionState().getConfigManager().getAuthMetadata());
        }
        return this.m_authContext.doLogoutRequest();
    }

    public void handleLoginResponse(HttpServletRequest request) {
        if (this.m_authContext != null) {
            this.m_authContext.handleLoginResponse(request.getParameter("id_token"), request.getParameter("error"), request.getParameter("error_description"));
        }
    }

    public void handleLogoutResponse() {
        if (this.m_authContext != null) {
            this.m_authContext.handleLogoutResponse();
            this.m_authContext = null;
        }
    }

    public AuthState getAuthState() {
        AuthState status = this.m_authContext == null ? AuthState.getInstance(AuthState.ID.IDLE) : this.m_authContext.getState();
        return status;
    }

    public boolean isAuthorizedFor(String role) {
        boolean authorized = this.m_authContext == null ? false : this.m_authContext.isAuthorizedFor(role);
        return authorized;
    }

    public String getToken() {
        return this.m_sessionState.getToken();
    }
}

