/*
 * Decompiled with CFR 0.152.
 */
package com.infor.ln.workbench.server.web;

import com.infor.ln.workbench.server.config.ConfigManager;
import com.infor.ln.workbench.server.web.WorkbenchStartParameters;
import com.infor.ln.workbench.server.web.WorkbenchState;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.resource.ResourceException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import org.owasp.esapi.codecs.Hex;

public class SessionState
implements HttpSessionBindingListener {
    private static final String SESSION_STATE = "sessionState";
    private final HttpSession m_session;
    private final ConfigManager m_configManager;
    private final String m_token;
    private final Map<String, WorkbenchState> m_workbenches = new HashMap<String, WorkbenchState>();

    private SessionState(HttpSession a_session, ConfigManager configManager) {
        this.m_session = a_session;
        this.m_configManager = configManager;
        this.m_token = this.createToken(a_session.getId());
    }

    public final String getId() {
        return this.m_session.getId();
    }

    public final HttpSession getSession() {
        return this.m_session;
    }

    public static synchronized SessionState getSessionState(HttpSession a_session) {
        SessionState state = (SessionState)a_session.getAttribute(SESSION_STATE);
        if (state == null) {
            ConfigManager configManager = ConfigManager.getConfigManager(a_session.getServletContext());
            state = new SessionState(a_session, configManager);
            a_session.setAttribute(SESSION_STATE, (Object)state);
        }
        return state;
    }

    public ConfigManager getConfigManager() {
        return this.m_configManager;
    }

    public synchronized WorkbenchState createWorkbenchState(WorkbenchStartParameters startParameters) throws IOException, ResourceException {
        WorkbenchState workbenchState = null;
        String ticket = startParameters.getTicket();
        if (ticket != null) {
            for (WorkbenchState state : this.m_workbenches.values()) {
                if (!ticket.equals(state.getTicket())) continue;
                workbenchState = state;
                break;
            }
        }
        if (workbenchState == null) {
            workbenchState = new WorkbenchState(startParameters, this);
            this.m_workbenches.put(workbenchState.getConId(), workbenchState);
        }
        WorkbenchState.setThreadLocalApplicationState(workbenchState);
        return workbenchState;
    }

    public WorkbenchState getWorkbenchState(String a_conId) {
        WorkbenchState state = this.m_workbenches.get(a_conId);
        WorkbenchState.setThreadLocalApplicationState(state);
        return state;
    }

    public synchronized void removeWorkbenchState(String a_conId) {
        this.m_workbenches.remove(a_conId);
        if (this.m_workbenches.isEmpty()) {
            this.m_session.invalidate();
        }
    }

    public void valueBound(HttpSessionBindingEvent a_arg0) {
    }

    public void valueUnbound(HttpSessionBindingEvent a_arg0) {
        Collection<WorkbenchState> workbenches = this.m_workbenches.values();
        for (WorkbenchState workbench : workbenches) {
            workbench.destroy();
        }
    }

    public static String getToken(HttpServletRequest request) {
        String token = "";
        HttpSession httpSession = request.getSession(false);
        if (httpSession != null && SessionState.hasSessionState(httpSession)) {
            token = SessionState.getSessionState(httpSession).getToken();
        }
        return token;
    }

    public String getToken() {
        return this.m_token;
    }

    private String createToken(String raw) {
        String token = "";
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            md.update(raw.getBytes(StandardCharsets.UTF_8));
            token = Hex.toHex((byte[])md.digest(), (boolean)false);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        return token;
    }

    private static boolean hasSessionState(HttpSession httpSession) {
        return httpSession.getAttribute(SESSION_STATE) != null;
    }
}

