/*
 * Decompiled with CFR 0.152.
 */
package com.infor.ln.workbench.server.web;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.Logger;
import org.owasp.esapi.Validator;
import org.owasp.esapi.errors.IntrusionException;
import org.owasp.esapi.errors.ValidationException;

public class RequestValidator {
    private static final Logger LOG = ESAPI.getLogger(RequestValidator.class);
    private static final String VALIDATOR_PARAMETER_STRING = "WorkbenchParameter";
    private final Validator m_validator = ESAPI.validator();
    private static final String ERROR_HTML = "<!DOCTYPE HTML>\n<HTML>\n\t<HEAD><TITLE>Bad Request</TITLE></HEAD>\n\t<BODY>Validation failed for request parameter</BODY>\n</HTML>";

    public boolean isValid(HttpServletRequest request, HttpServletResponse response) throws IOException {
        boolean valid = false;
        try {
            this.m_validator.getValidInput("backend", request.getParameter("backend"), VALIDATOR_PARAMETER_STRING, 100, true);
            this.m_validator.getValidInput("ticket", request.getParameter("ticket"), VALIDATOR_PARAMETER_STRING, 60, true);
            this.m_validator.getValidInteger("company", request.getParameter("company"), 0, 10000, true);
            this.m_validator.getValidInput("conId", request.getParameter("conId"), VALIDATOR_PARAMETER_STRING, 50, true);
            valid = true;
        }
        catch (IntrusionException | ValidationException e) {
            response.getWriter().append(ERROR_HTML);
            response.setStatus(400);
            LOG.error(Logger.EVENT_FAILURE, "Validation failed for request parameter", e);
        }
        return valid;
    }
}

