/*
 * Decompiled with CFR 0.152.
 */
package com.infor.ln.workbench.server.web;

import com.infor.ln.workbench.server.dll.InitOutput;
import com.infor.ln.workbench.server.web.StartupParameters;
import com.infor.ln.workbench.server.web.Utils;
import com.infor.ln.workbench.shared.IBackendParameters;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.EnumSet;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.owasp.esapi.Encoder;
import org.owasp.esapi.reference.DefaultEncoder;

public class GwtHtmlWriter {
    public static void writeStartupHtmlDocument(String a_module, InitOutput a_backendParameters, StartupParameters a_startupParameters, String a_includeScript, EnumSet<IBackendParameters.MapType> a_maptypes, String a_parentUrls, boolean a_startedByMingle, HttpServletResponse a_response) throws IOException {
        GwtHtmlWriter.setResponseHeaders(a_response, a_parentUrls, a_startedByMingle);
        try (PrintWriter out = a_response.getWriter();){
            GwtHtmlWriter.doWriteDocument(out, a_module, "Workbench", a_backendParameters, a_startupParameters, a_includeScript, a_maptypes);
        }
    }

    public static void writeLogHtmlDocument(HttpServletResponse a_response, String a_language, String a_moduleName, boolean a_cloudEnabled, String a_parentURLs, String a_token) throws IOException {
        GwtHtmlWriter.setResponseHeaders(a_response, a_parentURLs, false);
        try (PrintWriter out = a_response.getWriter();){
            Encoder enc = DefaultEncoder.getInstance();
            ((Writer)out).write("<!doctype html>");
            ((Writer)out).write("<html>");
            ((Writer)out).write("<head>");
            ((Writer)out).write("<meta http-equiv='content-type' content='text/html; charset=UTF-8'>");
            ((Writer)out).write("<meta http-equiv='X-UA-Compatible' content='IE=edge'>");
            ((Writer)out).write("<meta name='gwt:property' content='" + enc.encodeForHTMLAttribute("locale=" + a_language) + "'>");
            ((Writer)out).write("<meta name='ROBOTS' content='NOINDEX, NOFOLLOW'>");
            ((Writer)out).write("<title>" + a_moduleName + " Log</title>");
            ((Writer)out).write("<script type='text/javascript' language='javascript' src='logview/logview.nocache.js'></script>");
            ((Writer)out).write("<script type='text/javascript' >");
            ((Writer)out).write("var cloudEnabled = " + Boolean.toString(a_cloudEnabled) + ";");
            ((Writer)out).write("var token = '" + a_token + "';");
            ((Writer)out).write("</script>");
            ((Writer)out).write("</head>");
            ((Writer)out).write("<body role='document' style='background: #ffffff'>");
            ((Writer)out).write("<noscript aria-hidden='true'>");
            ((Writer)out).write("<div style='width: 22em; position: absolute; left: 50%; margin-left: -11em; color: red; background-color: white; border: 1px solid red; padding: 4px; font-family: sans-serif'>");
            ((Writer)out).write("Your web browser must have JavaScript enabled in order for this application to display correctly.");
            ((Writer)out).write("</div>");
            ((Writer)out).write("</noscript>");
            ((Writer)out).write("</body>");
            ((Writer)out).write("</html>");
        }
    }

    private static void setResponseHeaders(HttpServletResponse a_response, String a_parentURLs, boolean a_startedByMingle) {
        a_response.setContentType("text/html; charset=utf-8");
        Utils.setCacheHeaders(a_response);
        a_response.setHeader("Referrer-Policy", "strict-origin-when-cross-origin");
        if (StringUtils.isNotBlank((String)a_parentURLs)) {
            a_response.setHeader("Content-Security-Policy", "frame-ancestors " + a_parentURLs);
            String[] urls = StringUtils.split((String)a_parentURLs, (char)' ');
            String url = !a_startedByMingle && urls.length > 1 ? urls[1] : urls[0];
            a_response.setHeader("X-Frame-Options", "ALLOW-FROM " + url);
            a_response.setHeader("P3P", "CP=\"Infor doesn't have any p3p policies\"");
        }
    }

    private static void doWriteDocument(Writer a_out, String a_module, String title, InitOutput backendParameters, StartupParameters startupParameters, String a_includeScript, EnumSet<IBackendParameters.MapType> a_maptypes) throws IOException {
        Encoder enc = DefaultEncoder.getInstance();
        a_out.write("<!doctype html>");
        a_out.write("<html>");
        a_out.write("<head>");
        a_out.write("<meta http-equiv='content-type' content='text/html; charset=UTF-8'>");
        a_out.write("<meta http-equiv='X-UA-Compatible' content='IE=Edge'>");
        a_out.write("<meta name='gwt:property' content='locale=" + enc.encodeForHTMLAttribute(startupParameters.getLanguage()) + "'>");
        a_out.write("<meta name='ROBOTS' content='NOINDEX, NOFOLLOW'>");
        a_out.write("<title>" + title + "</title>");
        if (StringUtils.isNotEmpty((String)a_includeScript)) {
            a_out.write(a_includeScript);
        }
        a_out.write("<script type='text/javascript' >");
        String backendParams = GwtHtmlWriter.toJsonString(backendParameters, enc);
        String startupParams = GwtHtmlWriter.toJsonString(startupParameters, enc);
        StringBuilder startupCode = new StringBuilder();
        startupCode.append("var backendParams = '").append(backendParams).append("';\n").append("var startupParams = '").append(startupParams).append("';\n");
        a_out.write(startupCode.toString());
        a_out.write("</script>");
        a_out.write("<script type='text/javascript' language='javascript' src='" + a_module + "/" + a_module + ".nocache.js'></script>");
        if (!a_maptypes.isEmpty()) {
            a_out.write("<script type='text/javascript' language='javascript' src='" + a_module + "/openlayers/OpenLayers.js'></script>");
        }
        if (a_maptypes.contains((Object)IBackendParameters.MapType.GOOGLEMAPS)) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("<script type='text/javascript' src='https://maps.googleapis.com/maps/api/js?");
            if (StringUtils.isNotEmpty((String)backendParameters.getGoogleKey())) {
                buffer.append("client=").append(backendParameters.getGoogleKey()).append("&");
            }
            buffer.append("sensor=false'></script>");
            a_out.write(buffer.toString());
        }
        if (a_maptypes.contains((Object)IBackendParameters.MapType.OPENSTREETMAP)) {
            a_out.write("<script type='text/javascript' src='https://www.openstreetmap.org/openlayers/OpenStreetMap.js'></script>");
        }
        a_out.write("</head>");
        a_out.write("<body style='background: #ffffff' role='application'>");
        a_out.write("<noscript aria-hidden='true'>");
        a_out.write("<div style='width: 22em; position: absolute; left: 50%; margin-left: -11em; color: red; background-color: white; border: 1px solid red; padding: 4px; font-family: sans-serif'>");
        a_out.write("Your web browser must have JavaScript enabled in order for this application to display correctly.");
        a_out.write("</div>");
        a_out.write("</noscript>");
        a_out.write("</body>");
        a_out.write("</html>");
    }

    private static String toJsonString(InitOutput backendParameters, Encoder encoder) {
        StringBuilder buffer = new StringBuilder();
        buffer.append('{');
        GwtHtmlWriter.appendStringParam(buffer, encoder, "bingKey", backendParameters.getBingKey());
        buffer.append(',');
        GwtHtmlWriter.appendStringParam(buffer, encoder, "googleKey", backendParameters.getGoogleKey());
        buffer.append(',');
        GwtHtmlWriter.appendStringParam(buffer, encoder, "defaultMap", backendParameters.getDefaultMap().name());
        buffer.append(',');
        GwtHtmlWriter.appendStringParam(buffer, encoder, "permission", backendParameters.getPermission() != null ? backendParameters.getPermission().name() : "");
        buffer.append(',');
        GwtHtmlWriter.appendIntParam(buffer, "firstDayOfWeek", backendParameters.getFirstDayOfWeek());
        buffer.append(',');
        GwtHtmlWriter.appendStringParam(buffer, encoder, "graphUrl", backendParameters.getGraphUrl());
        buffer.append(',');
        GwtHtmlWriter.appendStringParam(buffer, encoder, "graphRepository", backendParameters.getGraphRepository());
        buffer.append(',');
        GwtHtmlWriter.appendStringParam(buffer, encoder, "graphProject", backendParameters.getGraphProject());
        buffer.append(',');
        GwtHtmlWriter.appendStringParam(buffer, encoder, "graphCatalog", backendParameters.getGraphCatalog());
        buffer.append("}");
        return buffer.toString();
    }

    private static String toJsonString(StartupParameters startupParameters, Encoder encoder) {
        StringBuilder buffer = new StringBuilder();
        buffer.append('{');
        GwtHtmlWriter.appendIntParam(buffer, "sessionTimeout", startupParameters.getSessionTimeout());
        buffer.append(',');
        GwtHtmlWriter.appendStringParam(buffer, encoder, "language", startupParameters.getLanguage());
        buffer.append(',');
        GwtHtmlWriter.appendStringParam(buffer, encoder, "dateFormat", startupParameters.getDateFormat());
        buffer.append(',');
        GwtHtmlWriter.appendStringParam(buffer, encoder, "timeMediumFormat", startupParameters.getTimeMediumFormat());
        buffer.append(',');
        GwtHtmlWriter.appendStringParam(buffer, encoder, "timeShortFormat", startupParameters.getTimeShortFormat());
        buffer.append(',');
        GwtHtmlWriter.appendStringParam(buffer, encoder, "decimalSeparator", startupParameters.getDecimalSeparator());
        buffer.append(',');
        GwtHtmlWriter.appendStringParam(buffer, encoder, "groupingSeparator", startupParameters.getGroupingSeparator());
        buffer.append(',');
        GwtHtmlWriter.appendStringParam(buffer, encoder, "sessionCode", startupParameters.getSessionCode());
        buffer.append(',');
        GwtHtmlWriter.appendStringParam(buffer, encoder, "connectionId", startupParameters.getConnectionId());
        buffer.append(',');
        GwtHtmlWriter.appendStringParam(buffer, encoder, "token", startupParameters.getToken());
        buffer.append('}');
        return buffer.toString();
    }

    private static void appendStringParam(StringBuilder buffer, Encoder encoder, String key, String value) {
        buffer.append('\"').append(key).append("\":\"").append(encoder.encodeForJavaScript(value)).append('\"');
    }

    private static void appendIntParam(StringBuilder buffer, String key, Integer value) {
        buffer.append('\"').append(key).append("\":").append(value);
    }

    private GwtHtmlWriter() {
    }
}

