/*
 * Decompiled with CFR 0.152.
 */
package com.infor.ln.workbench.server.web;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.io.FileUtils;

public class FileUtil {
    public static File createTempFile(String extension) throws IOException {
        return FileUtil.createTempFile("", extension);
    }

    public static File createTempFile(String prefix, String extension) throws IOException {
        return Files.createTempFile(prefix, "." + extension, new FileAttribute[0]).toFile();
    }

    public static File createUniqueFile(String prefix, String extension, File parentDir) throws IOException {
        return Files.createTempFile(parentDir.toPath(), prefix, "." + extension, new FileAttribute[0]).toFile();
    }

    public static String createBackup(File fileToBackup) throws IOException {
        if (!fileToBackup.exists()) {
            throw new FileNotFoundException(fileToBackup.getAbsolutePath());
        }
        File backup = new File(fileToBackup.getAbsoluteFile() + ".backup_" + new SimpleDateFormat("yyyyMMdd'T'HHmmss").format(new Date()));
        FileUtils.copyFile((File)fileToBackup, (File)backup);
        return backup.getAbsolutePath();
    }

    public static File getFile(File parent, String subpath) throws IOException {
        File target = new File(parent, subpath).getCanonicalFile();
        boolean child = target.getPath().startsWith(parent.getCanonicalPath());
        if (!child) {
            throw new IOException("Unexpected path traversal");
        }
        return target;
    }

    private FileUtil() {
    }
}

