/*
 * Decompiled with CFR 0.152.
 */
package com.infor.ln.workbench.server.rpc;

import com.google.gwt.core.server.StackTraceDeobfuscator;
import com.infor.ln.workbench.server.rpc.BaseService;
import com.infor.ln.workbench.server.web.ClientLogger;
import com.infor.ln.workbench.server.web.FileUtil;
import com.infor.ln.workbench.server.web.WorkbenchState;
import com.infor.ln.workbench.shared.AbstractSettings;
import com.infor.ln.workbench.shared.Layout;
import com.infor.ln.workbench.shared.resources.AbstractLNEnums;
import com.infor.ln.workbench.shared.resources.AbstractLNLabels;
import com.infor.ln.workbench.shared.resources.AbstractLNMessages;
import com.infor.ln.workbench.shared.resources.LNResources;
import com.infor.ln.workbench.shared.rpc.ICommonService;
import com.infor.ln.workbench.shared.rpc.ServerRPCException;
import com.infor.ln.workbench.shared.web.AuthState;
import java.io.File;
import java.io.IOException;
import java.util.logging.LogRecord;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;

public class CommonService
extends BaseService
implements ICommonService {
    private ServletContext m_servletContext;

    public void init(ServletConfig configuration) throws ServletException {
        super.init(configuration);
        this.m_servletContext = configuration.getServletContext();
    }

    public void destroy() {
        super.destroy();
    }

    @Override
    public final void logOnServer(String a_connectionId, int sequenceId, LogRecord lr) throws ServerRPCException {
        try {
            WorkbenchState state = this.getWorkbenchState(a_connectionId);
            String moduleName = state.getModuleName();
            LogRecord record = this.getDeobfuscatedStack(lr, moduleName);
            record.setMessage(sequenceId + "/" + record.getMessage());
            ClientLogger logger = ClientLogger.getClientLogger(this.m_servletContext, true);
            logger.log(state.getUniqueId(), sequenceId, record);
        }
        catch (Exception e) {
            throw this.convertToServerRPCException(e);
        }
    }

    @Override
    public boolean ping(String a_connectionId, boolean recentAccess) throws ServerRPCException {
        try {
            WorkbenchState state = this.getWorkbenchState(a_connectionId);
            return state.ping(recentAccess);
        }
        catch (Exception e) {
            throw this.convertToServerRPCException(e);
        }
    }

    @Override
    public void saveWorkbenchLayout(String a_connectionId, Layout layout) throws ServerRPCException {
        try {
            WorkbenchState state = this.getWorkbenchState(a_connectionId);
            state.saveWorkbenchLayout(layout);
        }
        catch (Exception e) {
            throw this.convertToServerRPCException(e);
        }
    }

    @Override
    public Layout loadWorkbenchLayout(String a_connectionId) throws ServerRPCException {
        try {
            WorkbenchState state = this.getWorkbenchState(a_connectionId);
            return state.loadWorkbenchLayout();
        }
        catch (Exception e) {
            throw this.convertToServerRPCException(e);
        }
    }

    @Override
    public void clearWorkbenchLayout(String a_connectionId) throws ServerRPCException {
        try {
            WorkbenchState state = this.getWorkbenchState(a_connectionId);
            state.clearWorkbenchLayout();
        }
        catch (Exception e) {
            throw this.convertToServerRPCException(e);
        }
    }

    @Override
    public <T extends AbstractSettings> void saveWorkbenchSettings(String a_connectionId, T a_settings) throws ServerRPCException {
        try {
            WorkbenchState state = this.getWorkbenchState(a_connectionId);
            state.saveWorkbenchSettings(a_settings);
        }
        catch (Exception e) {
            throw this.convertToServerRPCException(e);
        }
    }

    @Override
    public <T extends AbstractSettings> T loadWorkbenchSettings(String a_connectionId, T a_settings) throws ServerRPCException {
        try {
            WorkbenchState state = this.getWorkbenchState(a_connectionId);
            return state.loadWorkbenchSettings(a_settings);
        }
        catch (Exception e) {
            throw this.convertToServerRPCException(e);
        }
    }

    @Override
    public void clearWorkbenchSettings(String a_connectionId) throws ServerRPCException {
        try {
            WorkbenchState state = this.getWorkbenchState(a_connectionId);
            state.clearWorkbenchSettings();
        }
        catch (Exception e) {
            throw this.convertToServerRPCException(e);
        }
    }

    @Override
    public <L extends AbstractLNLabels, E extends AbstractLNEnums, M extends AbstractLNMessages> LNResources<L, E, M> getResources(String a_connectionId) throws ServerRPCException {
        try {
            WorkbenchState state = this.getWorkbenchState(a_connectionId);
            return state.getResources();
        }
        catch (Exception e) {
            throw this.convertToServerRPCException(e);
        }
    }

    @Override
    public AuthState authRequestLogin(String connectionId, String clientURI) throws ServerRPCException {
        WorkbenchState application = this.getWorkbenchState(connectionId);
        try {
            AuthState authState = application.requestLogin(clientURI);
            return authState;
        }
        catch (Exception e) {
            throw this.convertToServerRPCException(e);
        }
        finally {
            WorkbenchState.setThreadLocalApplicationState(null);
        }
    }

    @Override
    public AuthState authRequestLogout(String connectionId) throws ServerRPCException {
        WorkbenchState application = this.getWorkbenchState(connectionId);
        try {
            AuthState authState = application.requestLogout();
            return authState;
        }
        catch (Exception e) {
            throw this.convertToServerRPCException(e);
        }
        finally {
            WorkbenchState.setThreadLocalApplicationState(null);
        }
    }

    @Override
    public AuthState authGetState(String connectionId) throws ServerRPCException {
        WorkbenchState application = this.getWorkbenchState(connectionId);
        try {
            AuthState authState = application.getAuthState();
            return authState;
        }
        catch (Exception e) {
            throw this.convertToServerRPCException(e);
        }
        finally {
            WorkbenchState.setThreadLocalApplicationState(null);
        }
    }

    @Override
    public void clearLog(String a_connectionId) throws ServerRPCException {
        try {
            WorkbenchState state = this.getWorkbenchState(a_connectionId);
            state.clearLog();
        }
        catch (Exception e) {
            throw this.convertToServerRPCException(e);
        }
    }

    private LogRecord getDeobfuscatedStack(LogRecord a_input, String moduleName) throws IOException {
        File symbolDir;
        String strongName = this.getPermutationStrongName();
        if (a_input.getThrown() != null && strongName != null && (symbolDir = FileUtil.getFile(new File(this.m_servletContext.getRealPath("/WEB-INF/deploy/")), moduleName + "/symbolMaps")).exists() && symbolDir.canRead() && symbolDir.isDirectory()) {
            StackTraceDeobfuscator deObfuscator = StackTraceDeobfuscator.fromFileSystem((String)symbolDir.getPath());
            deObfuscator.deobfuscateStackTrace(a_input.getThrown(), strongName);
        }
        return a_input;
    }
}

