/*
 * Decompiled with CFR 0.152.
 */
package com.infor.ln.workbench.server.config;

import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public interface HasTokenHandler {
    public boolean isValid();

    public TokenResult handle(String var1) throws IOException;

    public static class TokenResult {
        private final String m_hostname;
        private final int m_port;
        private final String m_error;

        public String getHostname() {
            return this.m_hostname;
        }

        public int getPort() {
            return this.m_port;
        }

        public String getError() {
            return this.m_error;
        }

        public static TokenResult createUri(String hostname, int port) {
            return new TokenResult(hostname, port, "");
        }

        public static TokenResult createError(String message) {
            return new TokenResult("", -1, message);
        }

        public boolean isOk() {
            return this.m_error.isEmpty();
        }

        public String toString() {
            ToStringBuilder builder = new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE);
            if (this.isOk()) {
                builder.append("host", (Object)this.getHostname()).append("port", this.getPort());
            } else {
                builder.append("message", (Object)this.getError());
            }
            return builder.toString();
        }

        private TokenResult(String hostname, int i, String message) {
            this.m_hostname = hostname;
            this.m_port = i;
            this.m_error = StringUtils.isBlank((String)message) ? "" : message;
        }
    }
}

