/*
 * Decompiled with CFR 0.152.
 */
package com.infor.ln.workbench.server.config;

import com.infor.ln.workbench.server.auth.Config;
import com.infor.ln.workbench.server.auth.ConfigBuilder;
import com.infor.ln.workbench.server.config.HasTokenHandler;
import com.infor.ln.workbench.server.config.HttpTokenService;
import com.infor.ln.workbench.server.web.ClientLogger;
import com.infor.ln.workbench.server.web.FileUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import javax.servlet.ServletContext;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.logging.log4j.spi.LoggerContext;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.Logger;

public final class ConfigManager {
    private static final String CONFIG_MANAGER = "configManager";
    private static final String INIT_PARENT_LIST = "ParentList";
    private static final String INIT_TOKEN_SERVICE = "TokenService";
    private static final Logger LOG = ESAPI.getLogger(ConfigManager.class);
    private static final String CONNECTIONPOINTS = "connectionpoints.xml";
    private static final String LOG4J2_CONFIG_DEFAULT_XML = "log4j2-config-default.xml";
    private final ServletContext m_context;
    private final File m_configDir;
    private final String m_parentList;
    private final HasTokenHandler m_tokenService;
    private final boolean m_tomcat;
    private final File m_logDirectory;
    private Config m_authMetadata;
    private int m_LogElevateCount = 0;
    private URI m_logConfigFile;
    private LoggerContext m_loggerContext;

    public static ConfigManager getConfigManager(ServletContext context) {
        return ConfigManager.getConfigManager(context, System.getProperties());
    }

    static ConfigManager getConfigManager(ServletContext context, Properties properties) {
        Object configManager = context.getAttribute(CONFIG_MANAGER);
        if (!(configManager instanceof ConfigManager)) {
            configManager = new ConfigManager(context, properties);
            context.setAttribute(CONFIG_MANAGER, configManager);
        }
        return (ConfigManager)configManager;
    }

    public static void destroy(ServletContext context) {
        Object configManager = context.getAttribute(CONFIG_MANAGER);
        if (configManager instanceof ConfigManager) {
            ((ConfigManager)configManager).shutdown();
            context.removeAttribute(CONFIG_MANAGER);
        }
    }

    public File initConnectionPoints() {
        return this.createFile(this.m_configDir, CONNECTIONPOINTS);
    }

    private ConfigManager(ServletContext context, Properties sysProperties) {
        this.m_context = context;
        this.m_configDir = this.findConfigDir(sysProperties);
        this.m_tomcat = StringUtils.isNotBlank((String)sysProperties.getProperty("catalina.base"));
        this.m_logDirectory = this.m_tomcat ? new File(sysProperties.getProperty("catalina.base"), "logs") : new File(sysProperties.getProperty("java.io.tmpdir"));
        String workbench = this.getWorkbenchName(context);
        try {
            this.m_logConfigFile = this.initLogConfigFile(workbench);
            this.m_loggerContext = Configurator.initialize((String)workbench, null, (URI)this.m_logConfigFile);
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        this.m_parentList = this.m_context.getInitParameter(INIT_PARENT_LIST);
        this.m_tokenService = this.createTokenService(this.m_context.getInitParameter(INIT_TOKEN_SERVICE));
    }

    public File getConfigDir() {
        return this.m_configDir;
    }

    File getLogConfigFile() {
        return new File(this.m_logConfigFile);
    }

    void shutdown() {
        ClientLogger clientLogger = ClientLogger.getClientLogger(this.m_context, false);
        if (clientLogger != null) {
            clientLogger.destroy();
        }
        if (this.m_loggerContext != null) {
            LogManager.shutdown((LoggerContext)this.m_loggerContext);
        }
    }

    public File getLogDirectory() {
        return this.m_logDirectory;
    }

    private URI initLogConfigFile(String name) throws URISyntaxException {
        URI result;
        File logConfigFile = new File(this.m_configDir, "log4j2-config.xml");
        if (logConfigFile.exists() && logConfigFile.isFile()) {
            result = logConfigFile.toURI();
        } else {
            try {
                String contents = this.getLogConfig(name);
                try {
                    FileUtils.write((File)logConfigFile, (CharSequence)contents, (Charset)StandardCharsets.UTF_8);
                    result = logConfigFile.toURI();
                }
                catch (IOException | IllegalArgumentException e) {
                    logConfigFile = FileUtil.createTempFile("log4j2-config-", "xml");
                    FileUtils.write((File)logConfigFile, (CharSequence)contents, (Charset)StandardCharsets.UTF_8);
                    result = logConfigFile.toURI();
                }
            }
            catch (IOException e) {
                result = this.getClass().getResource(LOG4J2_CONFIG_DEFAULT_XML).toURI();
            }
        }
        return result;
    }

    private String getLogConfig(String name) throws IOException {
        String contents = IOUtils.toString((InputStream)this.getClass().getResourceAsStream(LOG4J2_CONFIG_DEFAULT_XML), (Charset)StandardCharsets.UTF_8);
        contents = this.m_tomcat ? contents.replace("${sys:java.io.tmpdir}/workbench", "${sys:catalina.base}/logs/" + name) : contents.replace("${sys:java.io.tmpdir}/workbench", "${sys:java.io.tmpdir}/" + name);
        return contents;
    }

    public String getParentList() {
        return this.m_parentList;
    }

    public HasTokenHandler getTokenService() {
        return this.m_tokenService;
    }

    private File findConfigDir(Properties sysProperties) {
        boolean success;
        File configPath = null;
        String path = this.m_context.getInitParameter("ConfigPath");
        if (StringUtils.isNotEmpty((String)path)) {
            configPath = new File(path);
        }
        if (configPath == null && StringUtils.isNotBlank((String)(path = sysProperties.getProperty("workbench.configuration")))) {
            configPath = new File(path);
        }
        if (configPath == null) {
            configPath = this.readConfigProperties(this.getWebAppDir());
        }
        if (configPath == null) {
            configPath = new File(this.getWebAppDir(), "config");
        }
        if (!configPath.exists() && !(success = configPath.mkdirs())) {
            LOG.error(Logger.EVENT_UNSPECIFIED, "Failure to create directories: " + configPath);
        }
        return configPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File readConfigProperties(File webappDir) {
        File configPath = null;
        FileInputStream stream = null;
        try {
            File propertiesFile = new File(webappDir, "configuration.properties");
            if (propertiesFile.exists()) {
                stream = new FileInputStream(propertiesFile);
                Properties props = new Properties();
                props.load(stream);
                String path = props.getProperty("ConfigPath");
                if (StringUtils.isNotEmpty((String)path)) {
                    configPath = new File(path);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return configPath;
    }

    private File getWebAppDir() {
        String webappDir = this.m_context.getRealPath("/");
        return new File(webappDir);
    }

    private File createFile(File destinationDirectory, String resourceName) {
        File file = new File(destinationDirectory, resourceName);
        if (!file.exists()) {
            try {
                FileUtils.copyInputStreamToFile((InputStream)this.getClass().getResourceAsStream(resourceName), (File)file);
            }
            catch (IOException e) {
                LOG.error(Logger.EVENT_FAILURE, "Exception creating file " + file, (Throwable)e);
            }
        }
        return file;
    }

    public synchronized void elevateLogLevel() {
        ++this.m_LogElevateCount;
        if (this.m_LogElevateCount == 1) {
            ESAPI.getLogger((String)"").setLevel(400);
        }
    }

    public synchronized void revertLogLevel() {
        if (this.m_LogElevateCount > 0) {
            --this.m_LogElevateCount;
            if (this.m_LogElevateCount == 0) {
                LOG.info(Logger.EVENT_UNSPECIFIED, "Reverting log level to ERROR");
                ESAPI.getLogger((String)"").setLevel(800);
            }
        }
    }

    private HasTokenHandler createTokenService(String a_tokenService) {
        HasTokenHandler service;
        if (StringUtils.isNotEmpty((String)a_tokenService)) {
            service = new HttpTokenService(a_tokenService);
        } else {
            LOG.info(Logger.EVENT_UNSPECIFIED, "ES Token Service configuration not found");
            service = new HasTokenHandler(){

                @Override
                public boolean isValid() {
                    return false;
                }

                @Override
                public HasTokenHandler.TokenResult handle(String token) {
                    return HasTokenHandler.TokenResult.createError("ES Token Service configuration missing");
                }
            };
        }
        return service;
    }

    public synchronized Config getAuthMetadata() {
        if (this.m_authMetadata == null) {
            this.m_authMetadata = new ConfigBuilder(this.getConfigDir()).build().getConfiguration();
        }
        return this.m_authMetadata;
    }

    private String getWorkbenchName(ServletContext context) {
        String name = context.getContextPath();
        if (StringUtils.isNotBlank((String)name)) {
            while (name.startsWith("/")) {
                name = name.substring(1);
            }
        } else {
            name = "workbench";
        }
        return name;
    }
}

