/*
 * Decompiled with CFR 0.152.
 */
package com.infor.ln.workbench.server.bde;

import com.infor.erpln.jca.ConnectionImpl;
import com.infor.erpln.jca.bdeclient.BdeElementIterator;
import com.infor.erpln.jca.bdeclient.BdeException;
import com.infor.erpln.jca.bdeclient.BdeFilter;
import com.infor.erpln.jca.bdeclient.BdeMessage;
import com.infor.erpln.jca.bdeclient.BdeMessageDetails;
import com.infor.erpln.jca.bdeclient.BdeMessageIterator;
import com.infor.erpln.jca.bdeclient.BdeReply;
import com.infor.erpln.jca.bdeclient.BdeRequest;
import com.infor.erpln.jca.bdeclient.BdeSelection;
import com.infor.erpln.jca.bdeclient.JcaBdeManager;
import com.infor.erpln.jca.bdeclient.JcaBdeResultException;
import com.infor.ln.workbench.server.JAXBUtils;
import com.infor.ln.workbench.server.bde.BDEData;
import com.infor.ln.workbench.server.bde.ComparisonOperator;
import com.infor.ln.workbench.server.bde.LogicalOperator;
import com.infor.ln.workbench.server.web.WorkbenchState;
import com.infor.ln.workbench.shared.bde.AbstractBDEModel;
import com.infor.ln.workbench.shared.bde.KeyValuePair;
import com.infor.ln.workbench.shared.bde.Message;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.JAXBException;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.Logger;
import org.w3c.dom.Element;

public class BDETools {
    private static final Logger LOG = ESAPI.getLogger(BDETools.class);
    private static final String logFormat = "%s, Bde:'%s',  Method: '%s'";
    private BdeFilter m_expressionFactory;
    private static Pattern s_keyValuePattern = Pattern.compile("(\\w+)=(.*?)((?=, \\w+=)|$)");
    private final JcaBdeManager m_jcaBdeManager;
    private boolean m_useLocalTime = true;

    public BDETools(WorkbenchState a_workbenchState) throws BdeException {
        this.m_jcaBdeManager = a_workbenchState.createBdeManager();
    }

    public BDETools(ConnectionImpl jcaConnection) throws BdeException {
        this.m_jcaBdeManager = WorkbenchState.createBdeManager(jcaConnection);
    }

    public boolean isUseLocalTime() {
        return this.m_useLocalTime;
    }

    public void setUseLocalTime(boolean a_useLocalTime) {
        this.m_useLocalTime = a_useLocalTime;
    }

    public BdeFilter createFilter(BdeFilter.Expression a_expression) {
        BdeFilter filter = this.m_jcaBdeManager.createBdeFilter();
        filter.setExpression(a_expression);
        return filter;
    }

    public BdeFilter.Expression createAttributeComparisonExpression(String a_attribute1, String a_attribute2, ComparisonOperator a_operator) {
        switch (a_operator) {
            case EQUAL: {
                return this.getExpressionfactory().createAttributeComparisonEqual(a_attribute1, a_attribute2);
            }
            case NOT_EQUAL: {
                return this.getExpressionfactory().createAttributeComparisonNotEqual(a_attribute1, a_attribute2);
            }
            case LESS: {
                return this.getExpressionfactory().createAttributeComparisonLess(a_attribute1, a_attribute2);
            }
            case LESS_OR_EQUAL: {
                return this.getExpressionfactory().createAttributeComparisonLessOrEqual(a_attribute1, a_attribute2);
            }
            case GREATER: {
                return this.getExpressionfactory().createAttributeComparisonGreater(a_attribute1, a_attribute2);
            }
            case GREATER_OR_EQUAL: {
                return this.getExpressionfactory().createAttributeComparisonGreaterOrEqual(a_attribute1, a_attribute2);
            }
            case LIKE: {
                return this.getExpressionfactory().createAttributeComparisonLike(a_attribute1, a_attribute2);
            }
        }
        return null;
    }

    public BdeFilter.Expression createValueComparisonExpression(String a_attribute, String a_value, ComparisonOperator a_operator) {
        switch (a_operator) {
            case EQUAL: {
                return this.getExpressionfactory().createComparisonEqual(a_attribute, a_value);
            }
            case NOT_EQUAL: {
                return this.getExpressionfactory().createComparisonNotEqual(a_attribute, a_value);
            }
            case LESS: {
                return this.getExpressionfactory().createComparisonLess(a_attribute, a_value);
            }
            case LESS_OR_EQUAL: {
                return this.getExpressionfactory().createComparisonLessOrEqual(a_attribute, a_value);
            }
            case GREATER: {
                return this.getExpressionfactory().createComparisonGreater(a_attribute, a_value);
            }
            case GREATER_OR_EQUAL: {
                return this.getExpressionfactory().createComparisonGreaterOrEqual(a_attribute, a_value);
            }
            case LIKE: {
                return this.getExpressionfactory().createComparisonLike(a_attribute, a_value);
            }
        }
        return null;
    }

    public BdeFilter.Expression createEmptyComparisonExpression(String a_attribute) {
        return this.getExpressionfactory().createComparisonEqual(a_attribute, null);
    }

    public BdeFilter.Expression createNotEmptyComparisonExpression(String a_attribute) {
        return this.getExpressionfactory().createComparisonNotEqual(a_attribute, null);
    }

    public BdeFilter.Expression createLogicalExpression(BdeFilter.Expression a_expression1, BdeFilter.Expression a_expression2, LogicalOperator a_operator) {
        switch (a_operator) {
            case AND: {
                return this.getExpressionfactory().createLogicalAnd(a_expression1, a_expression2);
            }
            case OR: {
                return this.getExpressionfactory().createLogicalOr(a_expression1, a_expression2);
            }
        }
        return null;
    }

    public <T extends AbstractBDEModel> T executeShow(BDEData<T> a_bdeData) throws JcaBdeResultException, BdeException {
        return (T)((AbstractBDEModel)this.executeMethod(a_bdeData, "Show"));
    }

    public <T extends AbstractBDEModel> T executeCreate(BDEData<T> a_bdeData) throws JcaBdeResultException, BdeException {
        return (T)((AbstractBDEModel)this.executeMethod(a_bdeData, "Create"));
    }

    public <T extends AbstractBDEModel> T executeChange(BDEData<T> a_bdeData) throws JcaBdeResultException, BdeException {
        return (T)((AbstractBDEModel)this.executeMethod(a_bdeData, "Change"));
    }

    public <T extends AbstractBDEModel> T executeDelete(BDEData<T> a_bdeData) throws JcaBdeResultException, BdeException {
        return (T)((AbstractBDEModel)this.executeMethod(a_bdeData, "Delete"));
    }

    public <T> T executeMethod(BDEData<T> a_bdeData, String a_method) throws JcaBdeResultException, BdeException {
        Element bde;
        BdeFilter filter;
        List<String> selectionAttributes;
        LOG.info(Logger.EVENT_UNSPECIFIED, String.format(logFormat, "Start BDE", a_bdeData.getBDEName(), a_method));
        Element bdeElement = null;
        Element selectionElement = null;
        Element filterElement = null;
        String bdeName = a_bdeData.getBDEName();
        T bdeModel = a_bdeData.getBDEModel();
        if (bdeModel != null) {
            bdeElement = JAXBUtils.createNodeFromObject(bdeModel, new Class[0]);
        }
        if (!(selectionAttributes = a_bdeData.getSelectionAttributes()).isEmpty()) {
            BdeSelection selection = new BdeSelection();
            for (String attribute : selectionAttributes) {
                selection.addSelection(attribute);
            }
            selectionElement = selection.asElement();
        }
        if ((filter = a_bdeData.getFilter()) != null) {
            filterElement = filter.asElement();
        }
        BdeRequest requestWrapper = new BdeRequest(a_method);
        requestWrapper.setBdeElement(bdeElement);
        requestWrapper.setSelection(selectionElement);
        requestWrapper.setFilter(filterElement);
        List<KeyValuePair> controlAttributes = a_bdeData.getControlAttributes();
        for (KeyValuePair pair : controlAttributes) {
            requestWrapper.setControlAreaTag(pair.getKey(), pair.getValue());
        }
        requestWrapper.setLocalTime(this.m_useLocalTime);
        Element request = requestWrapper.createRequestElement();
        Element reply = this.m_jcaBdeManager.doBdeCall(bdeName, a_method, request);
        BdeReply replyWrapper = new BdeReply(reply);
        Element informationArea = replyWrapper.getInformationArea();
        if (informationArea != null && informationArea.hasChildNodes()) {
            BdeMessageIterator informationIterator = new BdeMessageIterator(informationArea);
            while (informationIterator.hasMoreElements()) {
                BdeMessage bdeMessage = informationIterator.nextElement();
                this.attachMessagesToBDEData(a_bdeData, bdeMessage);
            }
        }
        if ((bde = replyWrapper.getBde()) != null) {
            if (bdeModel == null) {
                LOG.info(Logger.EVENT_SUCCESS, String.format(logFormat, "BDE completed with data but no model specified", a_bdeData.getBDEName(), a_method));
                return null;
            }
            Object result = JAXBUtils.createObjectFromNode(bde, bdeModel.getClass(), new Class[0]);
            LOG.info(Logger.EVENT_SUCCESS, String.format(logFormat, "BDE completed", a_bdeData.getBDEName(), a_method));
            return (T)result;
        }
        LOG.info(Logger.EVENT_SUCCESS, String.format(logFormat, "BDE completed with no data", a_bdeData.getBDEName(), a_method));
        return null;
    }

    private <T> Iterator<T> executeList(BDEData<T> a_bdeData, String a_bdeMethod, int a_iteratorFetchSize) throws JcaBdeResultException, BdeException {
        BdeFilter filter;
        String bdeName = a_bdeData.getBDEName();
        int maxObjects = a_bdeData.getMaxObjects();
        if (maxObjects > 0) {
            this.m_jcaBdeManager.setIteratorFetchSize(0);
        } else {
            int fetchSize = a_bdeData.getIteratorFetchSize();
            if (fetchSize > -1) {
                this.m_jcaBdeManager.setIteratorFetchSize(fetchSize);
            } else {
                this.m_jcaBdeManager.setIteratorFetchSize(a_iteratorFetchSize);
            }
        }
        Element selectionElement = null;
        Element filterElement = null;
        List<String> selectionAttributes = a_bdeData.getSelectionAttributes();
        if (!selectionAttributes.isEmpty()) {
            BdeSelection selection = new BdeSelection();
            for (String attribute : selectionAttributes) {
                selection.addSelection(attribute);
            }
            selectionElement = selection.asElement();
        }
        if ((filter = a_bdeData.getFilter()) != null) {
            filterElement = filter.asElement();
        }
        this.m_jcaBdeManager.setLocalTime(this.m_useLocalTime);
        BdeElementIterator iterator = this.m_jcaBdeManager.executeList(bdeName, a_bdeMethod, selectionElement, filterElement, maxObjects);
        return new BDEIterator<T>(iterator, a_bdeData.getModelType());
    }

    public <T> Iterator<T> executeList(BDEData<T> a_bdeData) throws JcaBdeResultException, BdeException {
        LOG.info(Logger.EVENT_UNSPECIFIED, String.format(logFormat, "Start BDE", a_bdeData.getBDEName(), "executeList"));
        Iterator<T> result = this.executeList(a_bdeData, "List", 250);
        LOG.info(Logger.EVENT_UNSPECIFIED, String.format(logFormat, "BDE result: unknown", a_bdeData.getBDEName(), "executeList"));
        return result;
    }

    public <T extends AbstractBDEModel> ArrayList<T> executeFullList(BDEData<T> a_bdeData) throws JcaBdeResultException, BdeException {
        LOG.info(Logger.EVENT_UNSPECIFIED, String.format(logFormat, "Start BDE", a_bdeData.getBDEName(), "executeFullList"));
        ArrayList<T> result = new ArrayList<T>();
        Iterator<T> iterator = this.executeList(a_bdeData, "List", 0);
        while (iterator.hasNext()) {
            result.add(iterator.next());
        }
        String text = "BDE result: " + result.size() + " rows";
        LOG.info(Logger.EVENT_UNSPECIFIED, String.format(logFormat, text, a_bdeData.getBDEName(), "executeFullList"));
        return result;
    }

    private <T> void attachMessagesToBDEData(BDEData<T> a_bdeData, BdeMessage a_bdeMessage) {
        List<Message> messages = BDETools.convertMessages(a_bdeMessage);
        for (Message message : messages) {
            a_bdeData.addMessage(message);
        }
    }

    public static List<Message> convertMessages(BdeMessage a_bdeMessage) {
        ArrayList<Message> result = new ArrayList<Message>();
        BDETools.addMessagesToList(a_bdeMessage, result);
        BDETools.processGeneratedMessages(result);
        return result;
    }

    private static void addMessagesToList(BdeMessage a_bdeMessage, List<Message> a_result) {
        if (a_bdeMessage != null) {
            try {
                String code = a_bdeMessage.getMessageCode();
                Message.MessageType type = Message.MessageType.fromName(a_bdeMessage.getMessageType());
                String text = a_bdeMessage.getMessageText();
                String source = a_bdeMessage.getMessageSource();
                Message message = new Message(code, type, text, source);
                a_result.add(message);
                if (a_bdeMessage.hasMessageDetails()) {
                    BdeMessageDetails details = a_bdeMessage.getMessageDetails();
                    BdeMessageIterator messageIterator = details.getMessages();
                    while (messageIterator.hasMoreElements()) {
                        BDETools.addMessagesToList(messageIterator.nextElement(), a_result);
                    }
                }
            }
            catch (BdeException e) {
                LOG.error(Logger.EVENT_FAILURE, "Error when processing BDE messages.", (Throwable)e);
            }
        }
    }

    private static void processGeneratedMessages(List<Message> a_messages) {
        String code;
        String text;
        List<KeyValuePair> identifiers = null;
        for (Message message : a_messages) {
            text = message.getText();
            code = message.getCode();
            if (!code.equals("-12") || !text.startsWith("Identifiers: ")) continue;
            identifiers = BDETools.parseIdentifiers(text);
            break;
        }
        Iterator<Message> iterator = a_messages.iterator();
        while (iterator.hasNext()) {
            Message message;
            message = iterator.next();
            text = message.getText();
            code = message.getCode();
            if (code.equals("-12") && text.startsWith("Identifiers: ")) {
                iterator.remove();
                continue;
            }
            if (code.equals("tlbctstgen") && message.getType().equals((Object)Message.MessageType.INFO) && message.getSource().equals("Protected Layer")) {
                iterator.remove();
                continue;
            }
            if (identifiers == null) continue;
            for (KeyValuePair keyValue : identifiers) {
                message.addIdentifier(keyValue);
            }
        }
    }

    private static List<KeyValuePair> parseIdentifiers(String a_line) {
        ArrayList<KeyValuePair> result = new ArrayList<KeyValuePair>();
        Matcher matcher = s_keyValuePattern.matcher(a_line);
        while (matcher.find()) {
            String key = matcher.group(1);
            String value = matcher.group(2);
            result.add(new KeyValuePair(key, value));
        }
        return result;
    }

    private BdeFilter getExpressionfactory() {
        if (this.m_expressionFactory == null) {
            this.m_expressionFactory = this.m_jcaBdeManager.createBdeFilter();
        }
        return this.m_expressionFactory;
    }

    public static class EmptyIterator<T>
    implements Iterator<T> {
        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public T next() {
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("EmptyIterator does not support 'remove'");
        }
    }

    public static class BDEIterator<T>
    implements Iterator<T> {
        private final BdeElementIterator m_iterator;
        private final JAXBUtils.Context<T> m_jaxbContext;

        public BDEIterator(BdeElementIterator a_iterator, Class<T> a_bdeType) {
            this.m_iterator = a_iterator;
            try {
                this.m_jaxbContext = JAXBUtils.createContext(a_bdeType);
            }
            catch (JAXBException e) {
                LOG.error(Logger.EVENT_FAILURE, "Exception creating JAXB context", (Throwable)e);
                throw new NoSuchElementException();
            }
        }

        @Override
        public boolean hasNext() {
            return this.m_iterator.hasNext();
        }

        @Override
        public T next() {
            try {
                Element bdeElement = this.m_iterator.nextElement();
                if (bdeElement == null) {
                    throw new NoSuchElementException();
                }
                return this.m_jaxbContext.createObjectFromNode(bdeElement);
            }
            catch (BdeException e) {
                LOG.error(Logger.EVENT_FAILURE, "Exception retrieving next element", (Throwable)e);
                throw new NoSuchElementException();
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("BDEIterator does not support 'remove'");
        }
    }
}

