/*
 * Decompiled with CFR 0.152.
 */
package com.infor.ln.workbench.server.auth;

import com.infor.ln.workbench.server.auth.Config;
import com.infor.ln.workbench.shared.web.AuthState;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.MalformedClaimException;
import org.jose4j.jwt.NumericDate;
import org.jose4j.jwt.consumer.InvalidJwtException;
import org.jose4j.jwt.consumer.JwtConsumerBuilder;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.EncoderConstants;
import org.owasp.esapi.Logger;

public class Context {
    private static final String RESPONSE_ERROR = "response_error";
    private static final String RESPONSE_ERROR_DESC = "An error occurred while handling the response from the Azure authorization server";
    private static final String CONFIG_ERROR = "configuration_error";
    private static final String CONFIG_ERROR_DESC = "OpenID Connect metadata document not found";
    private static final Logger LOG = ESAPI.getLogger(Context.class);
    private final String m_conId;
    private final Config m_metadata;
    private final long m_secondsFromEpoch;
    private final NonceBuilder m_nonceBuilder;
    private String m_clientID;
    private String m_redirectURI = "";
    private String m_nonce;
    private AuthState m_currentState = AuthState.getInstance(AuthState.ID.IDLE);
    private List<String> m_authorizations;

    public static Context getInstance(String conId, Config metadata) {
        return new Context(conId, metadata);
    }

    public AuthState doLoginRequest(String clientID, String clientURI) {
        if (StringUtils.isEmpty((String)clientID)) {
            throw new IllegalStateException("Application (client) ID not set");
        }
        if (this.m_currentState.isIdle()) {
            if (this.m_metadata == null) {
                this.m_currentState = AuthState.getErrorInstance(CONFIG_ERROR, CONFIG_ERROR_DESC);
                return this.m_currentState;
            }
            this.m_currentState = AuthState.getInstance(AuthState.ID.LOGIN_BUSY);
            this.m_clientID = clientID;
            int queryStart = clientURI.indexOf(63);
            this.m_redirectURI = queryStart > 0 ? clientURI.substring(0, queryStart) : clientURI;
            this.m_nonce = this.m_nonceBuilder.getNonce();
            this.m_currentState.setEndpoint(this.m_metadata.getAuthorizationURI());
            Map<String, String> parameters = this.m_currentState.getParameters();
            parameters.put("client_id", this.m_clientID);
            parameters.put("response_type", "id_token");
            parameters.put("redirect_uri", this.m_redirectURI);
            parameters.put("scope", "openid");
            parameters.put("nonce", this.m_nonce);
            parameters.put("response_mode", "form_post");
            parameters.put("state", this.m_conId);
        } else if (!this.m_currentState.isLoginBusy()) {
            this.m_currentState.setEndpoint("");
        }
        LOG.info(Logger.EVENT_SUCCESS, "doLoginRequest: state=" + this.m_currentState);
        return this.m_currentState;
    }

    public void handleLoginResponse(String idToken, String error, String errorDescription) {
        if (this.m_currentState.isLoginBusy()) {
            if (StringUtils.isNotEmpty((String)error)) {
                this.handleError(error, errorDescription);
            } else {
                this.processToken(idToken);
            }
        }
        LOG.info(Logger.EVENT_SUCCESS, "handleLoginResponse: state=" + this.m_currentState);
    }

    public boolean isAuthorizedFor(String role) {
        if (StringUtils.isEmpty((String)role) || !this.m_currentState.isAuthenticated()) {
            return false;
        }
        return "*".equals(role) || this.m_authorizations != null && this.m_authorizations.contains(role);
    }

    public AuthState doLogoutRequest() {
        if (!this.m_currentState.isAuthenticated()) {
            this.setIdleState();
        }
        if (this.m_metadata != null) {
            this.m_currentState.setEndpoint(this.m_metadata.getEndSessionURI());
            try {
                Map<String, String> parameters = this.m_currentState.getParameters();
                if (!this.m_redirectURI.isEmpty()) {
                    parameters.put("post_logout_redirect_uri", URLEncoder.encode(this.m_redirectURI + "?" + "conId" + "=" + this.m_conId + "&doSignout=true", "UTF-8"));
                } else {
                    parameters.clear();
                }
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalStateException(e);
            }
        }
        LOG.info(Logger.EVENT_SUCCESS, "doLogoutRequest: state=" + this.m_currentState);
        return this.m_currentState;
    }

    public void handleLogoutResponse() {
        this.setIdleState();
        LOG.info(Logger.EVENT_SUCCESS, "handleLogoutResponse: state=" + this.m_currentState);
    }

    public AuthState getState() {
        return this.m_currentState;
    }

    private void handleError(String error, String errorDescription) {
        LOG.info(Logger.EVENT_FAILURE, "Authentication failed with Azure error: " + error + " / " + errorDescription);
        this.setErrorState(error, errorDescription);
    }

    private void processToken(String idToken) {
        try {
            JwtConsumerBuilder builder = new JwtConsumerBuilder().setRequireExpirationTime().setAllowedClockSkewInSeconds(30).setExpectedIssuer(this.m_metadata.getIssuer()).setExpectedAudience(new String[]{this.m_clientID});
            if (this.m_secondsFromEpoch > 0L) {
                builder.setEvaluationTime(NumericDate.fromSeconds((long)this.m_secondsFromEpoch)).setSkipSignatureVerification();
            } else {
                builder.setVerificationKeyResolver(this.m_metadata.getVerificationKeyResolver());
            }
            JwtClaims idTokenClaims = builder.build().processToClaims(idToken);
            if (this.validateClaims(idTokenClaims)) {
                this.m_authorizations = (List)idTokenClaims.getClaimValue("roles", List.class);
                if (LOG.isDebugEnabled()) {
                    for (String claimName : idTokenClaims.getClaimNames()) {
                        LOG.debug(Logger.EVENT_SUCCESS, "Claim \"" + claimName + "\": " + idTokenClaims.getClaimValue(claimName));
                    }
                }
                this.m_currentState = AuthState.getInstance(AuthState.ID.AUTHENTICATED);
            } else {
                this.setErrorState(RESPONSE_ERROR, RESPONSE_ERROR_DESC);
            }
        }
        catch (MalformedClaimException | InvalidJwtException e) {
            this.setErrorState(RESPONSE_ERROR, RESPONSE_ERROR_DESC);
            LOG.error(Logger.EVENT_FAILURE, "Exception processing JWT", e);
        }
    }

    private boolean validateClaims(JwtClaims claims) throws MalformedClaimException {
        if (!this.m_nonce.equals(claims.getClaimValue("nonce", String.class))) {
            LOG.error(Logger.EVENT_FAILURE, "Unexpected value of claim 'nonce'");
            return false;
        }
        return true;
    }

    private Context(String conId, Config metadata) {
        this(conId, metadata, 0L, new NonceBuilder(){

            @Override
            public String getNonce() {
                return ESAPI.randomizer().getRandomString(20, EncoderConstants.CHAR_ALPHANUMERICS);
            }
        });
    }

    Context(String conId, Config metadata, long secondsFromEpoch, NonceBuilder nonceBuilder) {
        this.m_conId = conId;
        this.m_metadata = metadata;
        this.m_secondsFromEpoch = secondsFromEpoch;
        this.m_nonceBuilder = nonceBuilder;
        this.setIdleState();
    }

    private void setIdleState() {
        if (!this.m_currentState.isIdle()) {
            this.m_currentState = AuthState.getInstance(AuthState.ID.IDLE);
        }
        this.m_authorizations = null;
    }

    private void setErrorState(String error, String description) {
        this.m_currentState = AuthState.getErrorInstance(error, description);
    }

    static interface NonceBuilder {
        public String getNonce();
    }
}

