/*
 * Decompiled with CFR 0.152.
 */
package com.infor.ln.workbench.server.auth;

import com.infor.ln.workbench.server.auth.Config;
import com.infor.ln.workbench.server.auth.ConfigProvider;
import com.infor.ln.workbench.server.auth.FileConfigProvider;
import com.infor.ln.workbench.server.auth.HttpConfigProvider;
import java.io.File;
import java.io.IOException;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.Logger;

public class ConfigBuilder {
    private static final Logger LOG = ESAPI.getLogger(ConfigBuilder.class);
    private static final String MS_ONLINE_BASE = "https://login.microsoftonline.com/";
    private static final String INFOR_TENANT = "457d5685-0467-4d05-b23b-8f817adda47c";
    private Config m_config;
    private final File m_configDir;

    public ConfigBuilder(File configDir) {
        this.m_configDir = configDir;
    }

    public ConfigBuilder build() {
        this.m_config = null;
        ConfigProvider provider = new HttpConfigProvider("https://login.microsoftonline.com/457d5685-0467-4d05-b23b-8f817adda47c/v2.0/.well-known/openid-configuration");
        try {
            this.m_config = provider.buildConfiguration();
        }
        catch (IOException e) {
            LOG.error(Logger.EVENT_FAILURE, "Exception getting OpenID config and/or JSON Web Key Set from https://login.microsoftonline.com/", (Throwable)e);
        }
        try {
            if (this.m_config == null) {
                provider = new FileConfigProvider(this.m_configDir);
                this.m_config = provider.buildConfiguration();
            }
        }
        catch (IOException e) {
            LOG.error(Logger.EVENT_FAILURE, "Exception getting OpenID config and/or JSON Web Key Set from " + this.m_configDir, (Throwable)e);
        }
        return this;
    }

    public Config getConfiguration() {
        return this.m_config;
    }
}

