/*
 * Decompiled with CFR 0.152.
 */
package com.infor.ln.workbench.server.auth;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.jose4j.jwk.JsonWebKeySet;
import org.jose4j.keys.resolvers.JwksVerificationKeyResolver;
import org.jose4j.keys.resolvers.VerificationKeyResolver;
import org.jose4j.lang.JoseException;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class Config {
    private JSONObject m_metadata = new JSONObject();
    private VerificationKeyResolver m_resolver;

    public void updateFromOpenIDConfig(InputStream jsonOpenIDConfig) throws IOException {
        try {
            JSONParser parser = new JSONParser();
            this.m_metadata = (JSONObject)parser.parse(IOUtils.toString((InputStream)jsonOpenIDConfig, (Charset)StandardCharsets.UTF_8));
        }
        catch (ParseException e) {
            throw new IOException("Cannot parse OpenID Connect metadata", e);
        }
    }

    public void updateFromJwks(InputStream jwks) throws IOException {
        String config = IOUtils.toString((InputStream)jwks, (Charset)StandardCharsets.UTF_8);
        try {
            JsonWebKeySet jsonWebKeySet = new JsonWebKeySet(config);
            this.m_resolver = new JwksVerificationKeyResolver(jsonWebKeySet.getJsonWebKeys());
        }
        catch (JoseException e) {
            throw new IOException("Cannot parse JWKS", e);
        }
    }

    public String getAuthorizationURI() {
        return this.getMetadataValue("authorization_endpoint");
    }

    public String getEndSessionURI() {
        return this.getMetadataValue("end_session_endpoint");
    }

    public String getIssuer() {
        return this.getMetadataValue("issuer");
    }

    public String getJwksURI() {
        return this.getMetadataValue("jwks_uri");
    }

    public VerificationKeyResolver getVerificationKeyResolver() {
        return this.m_resolver;
    }

    private String getMetadataValue(String key) {
        return this.m_metadata.get(key).toString();
    }
}

