/*
 * Decompiled with CFR 0.152.
 */
package com.infor.ln.workbench.server;

import com.infor.erpln.util.XmlUtil;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.ParserConfigurationException;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class JAXBUtils {
    private static final Logger LOG = ESAPI.getLogger(JAXBUtils.class);

    public static <T> Element createNodeFromObject(T a_modelObject, Class ... optionalClasses) {
        try {
            Document doc = XmlUtil.newDocumentBuilder((boolean)true).newDocument();
            JAXBContext context = JAXBUtils.getJaxbContext(a_modelObject.getClass(), optionalClasses);
            Marshaller marshaller = context.createMarshaller();
            marshaller.marshal(a_modelObject, (Node)doc);
            return doc.getDocumentElement();
        }
        catch (JAXBException | ParserConfigurationException e) {
            LOG.error(Logger.EVENT_FAILURE, "Error converting model object to XML", e);
            return null;
        }
    }

    public static <T> T createObjectFromNode(Node xmlNode, Class<T> returnType, Class ... optionalClasses) {
        try {
            JAXBContext context = JAXBUtils.getJaxbContext(returnType, optionalClasses);
            Unmarshaller unmarshaller = context.createUnmarshaller();
            Object object = unmarshaller.unmarshal(xmlNode);
            return returnType.cast(object);
        }
        catch (JAXBException e) {
            LOG.error(Logger.EVENT_FAILURE, "Exception converting XML to model object", (Throwable)e);
            return null;
        }
    }

    public static <T> Context<T> createContext(Class<T> returnType) throws JAXBException {
        return new Context(returnType, JAXBUtils.getJaxbContext(returnType, new Class[0]));
    }

    private static <T> JAXBContext getJaxbContext(Class<T> returnType, Class ... optionalClasses) throws JAXBException {
        if (optionalClasses.length > 0) {
            Class[] classesToBeBound = new Class[optionalClasses.length + 1];
            classesToBeBound[0] = returnType;
            int i = 1;
            Class[] classArray = optionalClasses;
            int n = classArray.length;
            for (int j = 0; j < n; ++j) {
                Class cls;
                classesToBeBound[i] = cls = classArray[j];
                ++i;
            }
            return JAXBContext.newInstance((Class[])classesToBeBound);
        }
        return JAXBContext.newInstance((Class[])new Class[]{returnType});
    }

    public static class Context<T> {
        private final Class<T> m_modelType;
        private final JAXBContext m_jaxbContext;

        public T createObjectFromNode(Node xmlNode) {
            try {
                Unmarshaller unmarshaller = this.m_jaxbContext.createUnmarshaller();
                Object object = unmarshaller.unmarshal(xmlNode);
                return this.m_modelType.cast(object);
            }
            catch (JAXBException e) {
                LOG.error(Logger.EVENT_FAILURE, "Exception converting XML to model object", (Throwable)e);
                return null;
            }
        }

        private Context(Class<T> returnType, JAXBContext jaxbContext) {
            this.m_modelType = returnType;
            this.m_jaxbContext = jaxbContext;
        }
    }
}

