/*
 * Decompiled with CFR 0.152.
 */
package com.infor.component.shared;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

public class Schedule
implements Serializable {
    private static DateProvider s_dateProvider;
    private static String s_dateFormat;
    private boolean m_showGantt;
    private boolean m_showSchedule;
    private boolean m_startSchedule;
    private boolean m_deleteAllowed;
    private boolean m_expandAll;
    private boolean m_showCompletion;
    private Legend[] m_legends;
    private Activity m_rootActivity;
    private Resource m_rootResource;
    private Constraint[] m_constraints;
    private Reservation[] m_reservations;
    private List<ColSize> m_ganttSizes;
    private List<ColSize> m_scheduleSizes;
    private BackgroundItems m_backgroundItems;
    private String m_sortBy;
    private int m_version = 1;

    public static void setDateProvider(DateProvider provider) {
        s_dateProvider = provider;
    }

    public static void setDateFormat(String a_format) {
        s_dateFormat = a_format;
    }

    public boolean getShowGantt() {
        return this.m_showGantt;
    }

    public boolean getShowSchedule() {
        return this.m_showSchedule;
    }

    public boolean getStartSchedule() {
        return this.m_startSchedule;
    }

    public boolean getDeleteAllowed() {
        return this.m_deleteAllowed;
    }

    public boolean getExpandAll() {
        return this.m_expandAll;
    }

    public boolean getShowCompletion() {
        return this.m_showCompletion;
    }

    public Legend[] getLegends() {
        return this.m_legends;
    }

    public Activity getRootActivity() {
        return this.m_rootActivity;
    }

    public Resource getRootResource() {
        return this.m_rootResource;
    }

    public Constraint[] getConstraints() {
        return this.m_constraints;
    }

    public Reservation[] getReservations() {
        return this.m_reservations;
    }

    protected Schedule() {
    }

    public void addGanttSize(String name, int size) {
        if (this.m_ganttSizes == null) {
            this.m_ganttSizes = new ArrayList<ColSize>();
        }
        ColSize colSize = new ColSize(name, size);
        this.m_ganttSizes.add(colSize);
    }

    public void addScheduleSize(String name, int size) {
        if (this.m_scheduleSizes == null) {
            this.m_scheduleSizes = new ArrayList<ColSize>();
        }
        ColSize colSize = new ColSize(name, size);
        this.m_scheduleSizes.add(colSize);
    }

    public List<ColSize> getGanttSizes() {
        return this.m_ganttSizes;
    }

    public List<ColSize> getScheduleSizes() {
        return this.m_scheduleSizes;
    }

    public void setBackgroundItems(BackgroundItems items) {
        this.m_backgroundItems = items;
    }

    public BackgroundItems getBackgroundItems() {
        return this.m_backgroundItems;
    }

    public void setSortBy(String name) {
        this.m_sortBy = name;
    }

    public String getSortBy() {
        return this.m_sortBy;
    }

    public void setVersion(int version) {
        this.m_version = version;
    }

    public int getVersion() {
        return this.m_version;
    }

    public Schedule(Legend[] legends, Activity rootActivity, Resource rootResource, Constraint[] constraints, Reservation[] reservations, boolean showGantt, boolean showSchedule, boolean startSchedule, boolean deleteAllowed, boolean expandAll, boolean showCompletion) {
        this.m_legends = legends;
        this.m_rootActivity = rootActivity;
        this.m_rootResource = rootResource;
        this.m_constraints = constraints;
        this.m_reservations = reservations;
        this.m_showGantt = showGantt;
        this.m_showSchedule = showSchedule;
        this.m_startSchedule = startSchedule;
        this.m_deleteAllowed = deleteAllowed;
        this.m_expandAll = expandAll;
        this.m_showCompletion = showCompletion;
    }

    static {
        s_dateFormat = "d-M-yyyy H:m:s";
    }

    public static class Update
    implements Serializable {
        private Activity[] m_activities;
        private Resource[] m_resources;
        private Constraint[] m_constraints;
        private Reservation[] m_reservations;
        private BackgroundItems m_backgroundItems;

        public Activity[] getActivities() {
            return this.m_activities;
        }

        public Resource[] getResources() {
            return this.m_resources;
        }

        public Constraint[] getConstraints() {
            return this.m_constraints;
        }

        public Reservation[] getReservations() {
            return this.m_reservations;
        }

        public void setBackgroundItems(BackgroundItems items) {
            this.m_backgroundItems = items;
        }

        public BackgroundItems getBackgroundItems() {
            return this.m_backgroundItems;
        }

        public void merge(Update update) {
            if (update.m_activities != null) {
                this.m_activities = update.m_activities;
            }
            if (update.m_resources != null) {
                this.m_resources = update.m_resources;
            }
            if (update.m_constraints != null) {
                this.m_constraints = update.m_constraints;
            }
            if (update.m_reservations != null) {
                this.m_reservations = update.m_reservations;
            }
            if (update.m_backgroundItems != null) {
                this.m_backgroundItems = update.m_backgroundItems;
            }
        }

        public Update() {
        }

        public Update(Activity[] activities) {
            this.m_activities = activities;
        }

        public Update(Resource[] resources) {
            this.m_resources = resources;
        }

        public Update(Constraint[] constraints) {
            this.m_constraints = constraints;
        }

        public Update(Reservation[] reservations) {
            this.m_reservations = reservations;
        }
    }

    public static class Reservation
    implements Serializable {
        private String m_oldResource;
        private String m_newResource;
        private String m_activity;
        private boolean m_delete;

        public String getNewResource() {
            return this.m_newResource;
        }

        public String getOldResource() {
            return this.m_oldResource;
        }

        public String getActivity() {
            return this.m_activity;
        }

        public boolean getDelete() {
            return this.m_delete;
        }

        protected Reservation() {
        }

        public Reservation(String resource, String activity, boolean delete) {
            this.m_newResource = resource;
            this.m_activity = activity;
            this.m_delete = delete;
        }

        public Reservation(String currentResource, String moveToResource, String activity, boolean delete) {
            this.m_oldResource = currentResource;
            this.m_newResource = moveToResource;
            this.m_activity = activity;
            this.m_delete = delete;
        }

        public void updateWith(Reservation update) {
            if (update.m_newResource != null) {
                this.m_newResource = update.m_newResource;
            }
            if (update.m_oldResource != null) {
                this.m_oldResource = update.m_oldResource;
            }
            if (update.m_activity != null) {
                this.m_activity = update.m_activity;
            }
        }
    }

    public static class Constraint
    implements Serializable {
        private String m_id;
        private String[] m_activities;
        private Type m_type;
        private boolean m_delete;

        public Type getType() {
            return this.m_type;
        }

        public boolean getDelete() {
            return this.m_delete;
        }

        public String getId() {
            return this.m_id;
        }

        public String[] getActivities() {
            return this.m_activities;
        }

        protected Constraint() {
        }

        public Constraint(String id, String[] activities, Type type, boolean delete) {
            this.m_id = id;
            this.m_activities = activities;
            this.m_type = type;
            this.m_delete = delete;
        }

        public Constraint(String from, String to, Type type, boolean delete) {
            this(from + "-" + to, new String[]{from, to}, type, delete);
        }

        public static enum Type {
            start_start,
            start_end,
            end_start,
            end_end,
            same_activity;

        }
    }

    public static class Resource
    extends Item {
        private Integer m_quantity;
        private List<Resource> m_resources;

        public int getQuantity() {
            if (this.m_quantity == null) {
                return 0;
            }
            return this.m_quantity;
        }

        public List<Resource> getResources() {
            return this.m_resources;
        }

        @Override
        public int getNumChildItems() {
            if (this.m_resources == null) {
                return 0;
            }
            return this.m_resources.size();
        }

        @Override
        public Item getChildItem(int index) {
            return this.m_resources.get(index);
        }

        @Override
        protected void removeChild(Item item) {
            assert (item instanceof Resource);
            this.m_resources.remove(item);
        }

        protected Resource() {
        }

        public void updateWith(Resource update) {
            super.updateWith(update);
            if (update.m_quantity != null) {
                this.m_quantity = update.m_quantity;
            }
        }

        public Resource(String id, String name, boolean delete, Integer quantity, List<Resource> resources, List<Property> properties) {
            super(id, name, delete, properties);
            this.m_resources = resources;
            this.m_quantity = quantity;
            if (resources != null) {
                for (Resource resource : resources) {
                    resource.setParent(this);
                }
            }
        }
    }

    public static class ExpandableActivity
    extends Activity {
        private boolean m_expanded = false;
        private boolean m_showIcon = true;

        public ExpandableActivity(String id, String name, Date start, Date end, boolean delete, String legend, Integer completion, List<Activity> activities, List<Activity.Division> divisions, List<Property> properties, boolean enabled) {
            super(id, name, start, end, delete, legend, completion, activities, divisions, properties, enabled);
        }

        public void setExpanded(boolean expanded) {
            this.m_expanded = expanded;
        }

        public boolean isExpanded() {
            return this.m_expanded;
        }

        public void setShowIcon(boolean showIcon) {
            this.m_showIcon = showIcon;
        }

        public boolean isShowIcon() {
            return this.m_showIcon;
        }
    }

    public static class SlackedActivity
    extends Activity {
        private String m_startSlack;
        private String m_endSlack;
        private transient Date m_startSlackDate;
        private transient Date m_endSlackDate;
        private String m_slackLegend;
        private String m_startSlack2;
        private String m_endSlack2;
        private transient Date m_startSlackDate2;
        private transient Date m_endSlackDate2;
        private String m_slack2Legend;

        public SlackedActivity() {
        }

        public SlackedActivity(String id, String name, String dateFormat, String start, String end, boolean delete, String legend, Integer completion, List<Activity.Division> divisions, List<Property> properties, boolean enabled, String startSlack, String endSlack, String slackLegend) {
            super(id, name, dateFormat, start, end, delete, legend, completion, null, divisions, properties, enabled);
            this.m_startSlack = startSlack;
            this.m_endSlack = endSlack;
            this.m_slackLegend = slackLegend;
        }

        public SlackedActivity(String id, String name, String dateFormat, String start, String end, boolean delete, String legend, Integer completion, List<Activity.Division> divisions, List<Property> properties, boolean enabled, String startSlack, String endSlack, String slackLegend, String startSlack2, String endSlack2, String slack2Legend) {
            super(id, name, dateFormat, start, end, delete, legend, completion, null, divisions, properties, enabled);
            this.m_startSlack = startSlack;
            this.m_endSlack = endSlack;
            this.m_slackLegend = slackLegend;
            this.m_startSlack2 = startSlack2;
            this.m_endSlack2 = endSlack2;
            this.m_slack2Legend = slack2Legend;
        }

        public SlackedActivity(String id, String name, Date start, Date end, boolean delete, String legend, Integer completion, List<Activity.Division> divisions, List<Property> properties, boolean enabled, Date startSlack, Date endSlack, String slackLegend) {
            super(id, name, start, end, delete, legend, completion, null, divisions, properties, enabled);
            this.m_startSlackDate = startSlack;
            this.m_endSlackDate = endSlack;
            this.m_slackLegend = slackLegend;
        }

        public SlackedActivity(String id, String name, Date start, Date end, boolean delete, String legend, Integer completion, List<Activity.Division> divisions, List<Property> properties, boolean enabled, Date startSlack, Date endSlack, String slackLegend, Date startSlack2, Date endSlack2, String slack2Legend) {
            super(id, name, start, end, delete, legend, completion, null, divisions, properties, enabled);
            this.m_startSlackDate = startSlack;
            this.m_endSlackDate = endSlack;
            this.m_slackLegend = slackLegend;
            this.m_startSlackDate2 = startSlack2;
            this.m_endSlackDate2 = endSlack2;
            this.m_slack2Legend = slack2Legend;
        }

        public Date getStartSlack() {
            if (this.m_startSlackDate == null) {
                this.initDates();
            }
            return this.m_startSlackDate;
        }

        public Date getEndSlack() {
            if (this.m_endSlackDate == null) {
                this.initDates();
            }
            return this.m_endSlackDate;
        }

        public String getSlackLegend() {
            return this.m_slackLegend;
        }

        public Date getStartSlack2() {
            if (this.m_startSlackDate2 == null) {
                this.initDates();
            }
            return this.m_startSlackDate2;
        }

        public Date getEndSlack2() {
            if (this.m_endSlackDate2 == null) {
                this.initDates();
            }
            return this.m_endSlackDate2;
        }

        public String getSlack2Legend() {
            return this.m_slack2Legend;
        }

        @Override
        protected void initDates() {
            super.initDates();
            if (this.m_startSlack != null) {
                this.m_startSlackDate = this.initDate(this.m_startSlack);
            }
            if (this.m_endSlack != null) {
                this.m_endSlackDate = this.initDate(this.m_endSlack);
            }
            if (this.m_startSlack2 != null) {
                this.m_startSlackDate2 = this.initDate(this.m_startSlack2);
            }
            if (this.m_endSlack2 != null) {
                this.m_endSlackDate2 = this.initDate(this.m_endSlack2);
            }
        }

        @Override
        public void updateWith(Activity update) {
            super.updateWith(update);
            if (update instanceof SlackedActivity) {
                SlackedActivity updat = (SlackedActivity)update;
                if (updat.m_startSlack != null) {
                    this.m_startSlack = updat.m_startSlack;
                    this.m_startSlackDate = null;
                }
                if (updat.m_endSlack != null) {
                    this.m_endSlack = updat.m_endSlack;
                    this.m_endSlackDate = null;
                }
                if (updat.m_startSlackDate != null) {
                    this.m_startSlackDate = updat.m_startSlackDate;
                }
                if (updat.m_endSlackDate != null) {
                    this.m_endSlackDate = updat.m_endSlackDate;
                }
                if (updat.m_slackLegend != null) {
                    this.m_slackLegend = updat.m_slackLegend;
                }
                if (updat.m_startSlack2 != null) {
                    this.m_startSlack2 = updat.m_startSlack2;
                    this.m_startSlackDate2 = null;
                }
                if (updat.m_endSlack2 != null) {
                    this.m_endSlack2 = updat.m_endSlack2;
                    this.m_endSlackDate2 = null;
                }
                if (updat.m_startSlackDate2 != null) {
                    this.m_startSlackDate2 = updat.m_startSlackDate2;
                }
                if (updat.m_endSlackDate2 != null) {
                    this.m_endSlackDate2 = updat.m_endSlackDate2;
                }
                if (updat.m_slack2Legend != null) {
                    this.m_slack2Legend = updat.m_slack2Legend;
                }
            }
        }
    }

    public static class Deadline
    extends Activity {
        private boolean m_done = false;

        public Deadline() {
        }

        public Deadline(String id, String name, Date time, boolean delete, String legend, boolean done, List<Property> properties) {
            super(id, name, time, time, delete, legend, null, null, null, properties, false);
            this.m_done = done;
        }

        public boolean isDone() {
            return this.m_done;
        }

        @Override
        public void updateWith(Activity update) {
            super.updateWith(update);
            if (update instanceof Deadline) {
                this.m_done = ((Deadline)update).m_done;
            }
        }
    }

    public static class Activity
    extends Item {
        private String m_start;
        private String m_end;
        private transient Date m_startDate;
        private transient Date m_endDate;
        private String m_legend;
        private Integer m_completion;
        private List<Activity> m_activities;
        private List<Division> m_divisions;
        private List<Marker> m_markers;
        private boolean m_enabled = true;
        private boolean m_selectable = true;
        private boolean m_visible = true;

        @Override
        public int getNumChildItems() {
            if (this.m_activities == null) {
                return 0;
            }
            return this.m_activities.size();
        }

        @Override
        public Item getChildItem(int index) {
            return this.m_activities.get(index);
        }

        @Override
        protected void removeChild(Item item) {
            assert (item instanceof Activity);
            this.m_activities.remove(item);
        }

        public String getDateFormat() {
            return s_dateFormat;
        }

        private boolean isNotEmpty(String s) {
            return s != null && !s.trim().equals("");
        }

        protected Date initDate(String date) {
            if (s_dateProvider == null) {
                throw new RuntimeException("DateProvider not set");
            }
            if (this.isNotEmpty(date)) {
                try {
                    return s_dateProvider.parse(this.getDateFormat(), date);
                }
                catch (IllegalArgumentException e) {
                    return null;
                }
            }
            return null;
        }

        protected void initDates() {
            if (this.getNumChildItems() == 0) {
                if (this.isNotEmpty(this.m_start)) {
                    this.m_startDate = this.initDate(this.m_start);
                }
                if (this.isNotEmpty(this.m_end)) {
                    this.m_endDate = this.initDate(this.m_end);
                }
                return;
            }
            long min = Long.MAX_VALUE;
            long max = Long.MIN_VALUE;
            if (this.isNotEmpty(this.m_start)) {
                min = this.initDate(this.m_start).getTime();
            }
            if (this.isNotEmpty(this.m_end)) {
                max = this.initDate(this.m_end).getTime();
            }
            for (int i = 0; i < this.m_activities.size(); ++i) {
                Activity act = this.m_activities.get(i);
                if (!act.isVisible()) continue;
                Date start = act.getStart();
                Date end = act.getEnd();
                if (start != null && start.getTime() < min) {
                    min = start.getTime();
                }
                if (end == null || end.getTime() <= max) continue;
                max = end.getTime();
            }
            if (min != Long.MAX_VALUE && max != Long.MIN_VALUE) {
                this.m_startDate = new Date(min);
                this.m_endDate = new Date(max);
            }
        }

        public boolean isValid() {
            if (this.m_startDate == null || this.m_endDate == null) {
                this.initDates();
            }
            return this.m_startDate != null && this.m_endDate != null && this.m_endDate.getTime() >= this.m_startDate.getTime();
        }

        public Date getStart() {
            if (this.m_startDate == null) {
                this.initDates();
            }
            return this.m_startDate;
        }

        public Date getEnd() {
            if (this.m_endDate == null) {
                this.initDates();
            }
            return this.m_endDate;
        }

        public String getLegend() {
            return this.m_legend;
        }

        public Integer getCompletion() {
            return this.m_completion;
        }

        public List<Activity> getActivities() {
            return this.m_activities;
        }

        public List<Division> getDivisions() {
            return this.m_divisions;
        }

        public Activity() {
        }

        public boolean isEnabled() {
            return this.m_enabled;
        }

        public void setSelectable(boolean a_selectable) {
            this.m_selectable = a_selectable;
        }

        public boolean isSelectable() {
            return this.m_selectable;
        }

        public void setVisible(boolean a_visible) {
            this.m_visible = a_visible;
        }

        public boolean isVisible() {
            return this.m_visible;
        }

        public void updateWith(Activity update) {
            super.updateWith(update);
            if (update.m_start != null && !update.m_start.equals("")) {
                this.m_start = update.m_start;
                this.m_startDate = null;
            }
            if (update.m_end != null && !update.m_end.equals("")) {
                this.m_end = update.m_end;
                this.m_endDate = null;
            }
            if (update.m_startDate != null) {
                this.m_startDate = update.m_startDate;
            }
            if (update.m_endDate != null) {
                this.m_endDate = update.m_endDate;
            }
            if (update.m_legend != null) {
                this.m_legend = update.m_legend;
            }
            if (update.m_completion != null) {
                this.m_completion = update.m_completion;
            }
            if (update.m_divisions != null) {
                this.m_divisions = update.m_divisions;
            }
            if (update.m_markers != null) {
                this.m_markers = update.m_markers;
            }
            this.m_enabled = update.m_enabled;
        }

        public void updateDates() {
            if (this.getNumChildItems() > 0) {
                this.initDates();
            }
        }

        public void setMarkers(List<Marker> markers) {
            this.m_markers = markers;
        }

        public List<Marker> getMarkers() {
            return this.m_markers;
        }

        public Activity(String id, String name, Date start, Date end, boolean delete, String legend, Integer completion, List<Activity> activities, List<Division> divisions, List<Property> properties, boolean enabled) {
            super(id, name, delete, properties);
            this.m_startDate = start;
            this.m_endDate = end;
            this.m_legend = legend;
            this.m_completion = completion;
            this.m_activities = activities;
            this.m_divisions = divisions;
            this.m_enabled = enabled;
            if (activities != null) {
                for (Activity activity : activities) {
                    activity.setParent(this);
                }
            }
        }

        public Activity(String id, String name, String dateFormat, String start, String end, boolean delete, String legend, Integer completion, List<Activity> activities, List<Division> divisions, List<Property> properties, boolean enabled) {
            super(id, name, delete, properties);
            Schedule.setDateFormat(dateFormat);
            this.m_start = start;
            this.m_end = end;
            this.m_legend = legend;
            this.m_completion = completion;
            this.m_activities = activities;
            this.m_divisions = divisions;
            this.m_enabled = enabled;
            if (activities != null) {
                for (Activity activity : activities) {
                    activity.setParent(this);
                }
            }
        }

        public static class Division
        implements Serializable {
            private double m_start;
            private double m_end;
            private String m_legend;

            public double getStart() {
                return this.m_start;
            }

            public double getEnd() {
                return this.m_end;
            }

            public String getLegend() {
                return this.m_legend;
            }

            protected Division() {
            }

            public Division(double start, double end, String legend) {
                this.m_start = start;
                this.m_end = end;
                this.m_legend = legend;
            }
        }
    }

    public static abstract class Item
    implements Serializable {
        private String m_id;
        private String m_name;
        private Item m_parent;
        private List<Property> m_properties;
        private boolean m_delete;
        private transient Object m_object;

        public boolean getDelete() {
            return this.m_delete;
        }

        public String getId() {
            return this.m_id;
        }

        public String getName() {
            return this.m_name;
        }

        public List<Property> getProperties() {
            return this.m_properties;
        }

        public Item getParent() {
            return this.m_parent;
        }

        protected void setParent(Item item) {
            this.m_parent = item;
        }

        public Object getObject() {
            return this.m_object;
        }

        public void setObject(Object object) {
            this.m_object = object;
        }

        public void removeFromParent() {
            if (this.m_parent != null) {
                this.m_parent.removeChild(this);
            }
        }

        public String toString() {
            return this.m_name + " (" + this.m_id + ")";
        }

        protected abstract void removeChild(Item var1);

        public void updateWith(Item update) {
            if (update.m_id != null) {
                this.m_id = update.m_id;
            }
            if (update.m_parent != null) {
                this.m_parent = update.m_parent;
            }
            if (update.m_object != null) {
                this.m_object = update.m_object;
            }
            if (update.m_name != null) {
                this.m_name = update.m_name;
            }
            if (update.m_properties != null) {
                for (Property propertyUpdate : update.m_properties) {
                    if (this.m_properties == null) {
                        this.m_properties = new ArrayList<Property>();
                    }
                    boolean found = false;
                    for (Property property : this.m_properties) {
                        if (!property.getId().equals(propertyUpdate.getId())) continue;
                        found = true;
                        property.updateWith(propertyUpdate);
                    }
                    if (found) continue;
                    this.m_properties.add(propertyUpdate);
                }
            }
        }

        public abstract int getNumChildItems();

        public abstract Item getChildItem(int var1);

        protected Item() {
        }

        public Item(String id, String name, boolean delete, List<Property> properties) {
            this.m_id = id;
            this.m_name = name;
            this.m_parent = null;
            this.m_properties = properties;
            this.m_delete = delete;
        }
    }

    public static class ColSize
    implements Serializable {
        private String m_name;
        private int m_size;

        public String getName() {
            return this.m_name;
        }

        public int getSize() {
            return this.m_size;
        }

        protected ColSize() {
        }

        public ColSize(String name, int size) {
            this.m_name = name;
            this.m_size = size;
        }
    }

    public static class BackgroundItem
    implements Serializable {
        private String m_id;
        private String m_label;
        private String m_start;
        private String m_end;
        private String m_legend;
        private BackgroundItems m_parent;

        protected BackgroundItem() {
        }

        public BackgroundItem(BackgroundItems parent, String id, String label, String start, String end, String legend) {
            this.m_parent = parent;
            this.m_id = id;
            this.m_label = label;
            this.m_start = start;
            this.m_end = end;
            this.m_legend = legend;
        }

        public String getId() {
            return this.m_id;
        }

        public String getLabel() {
            return this.m_label;
        }

        public String getStart() {
            return this.m_start;
        }

        public String getEnd() {
            return this.m_end;
        }

        private Date parseDate(String date) {
            if (s_dateProvider == null) {
                throw new RuntimeException("DateProvider not set");
            }
            if (date != null && !date.equals("")) {
                try {
                    return s_dateProvider.parse(this.m_parent.getDateFormat(), date);
                }
                catch (IllegalArgumentException e) {
                    return null;
                }
            }
            return null;
        }

        public Date getStartDate() {
            return this.parseDate(this.m_start);
        }

        public Date getEndDate() {
            return this.parseDate(this.m_end);
        }

        public String getLegend() {
            return this.m_legend;
        }
    }

    public static class BackgroundItems
    implements Serializable {
        private ArrayList<BackgroundItem> m_backgroundItems = new ArrayList();

        public BackgroundItems() {
        }

        public BackgroundItems(String dateFormat) {
            Schedule.setDateFormat(dateFormat);
        }

        public String getDateFormat() {
            return s_dateFormat;
        }

        public Iterator<BackgroundItem> getBackgroundItems() {
            return this.m_backgroundItems.iterator();
        }

        public void addItem(String id, String label, String start, String end, String legend) {
            BackgroundItem item = new BackgroundItem(this, id, label, start, end, legend);
            this.m_backgroundItems.add(item);
        }
    }

    public static class Property
    implements Serializable {
        private String m_id;
        private String m_label;
        private String m_value;
        private boolean m_date = false;

        public String getId() {
            return this.m_id;
        }

        public String getLabel() {
            return this.m_label;
        }

        public String getValue() {
            return this.m_value;
        }

        public Date getDate() {
            if (this.m_date) {
                if (s_dateProvider == null) {
                    throw new RuntimeException("DateProvider not set");
                }
                if (this.m_value != null && !this.m_value.isEmpty()) {
                    try {
                        return s_dateProvider.parse(s_dateFormat, this.m_value);
                    }
                    catch (IllegalArgumentException e) {
                        return null;
                    }
                }
            }
            return null;
        }

        public void updateWith(Property update) {
            assert (this.m_id.equals(update.m_id));
            this.m_value = update.m_value;
        }

        protected Property() {
        }

        public void setDate(boolean date) {
            this.m_date = date;
        }

        public boolean isDate() {
            return this.m_date;
        }

        public Property(String id, String label, String value) {
            this.m_id = id;
            this.m_label = label;
            this.m_value = value;
        }
    }

    public static class Marker
    implements Serializable {
        private String m_iconId;
        private String m_time;
        private transient Date m_timeDate;
        private String m_tooltip;
        private String m_legend;
        private Activity m_activity;

        protected Marker() {
        }

        public Marker(Activity act, String iconId, Date time, String tooltip, String legend) {
            this.m_activity = act;
            this.m_iconId = iconId;
            this.m_timeDate = time;
            this.m_tooltip = tooltip;
            this.m_legend = legend;
        }

        public Marker(Activity act, String iconId, String time, String tooltip, String legend) {
            this.m_activity = act;
            this.m_iconId = iconId;
            this.m_time = time;
            this.m_tooltip = tooltip;
            this.m_legend = legend;
        }

        public String getIconId() {
            return this.m_iconId;
        }

        public Date getTime() {
            if (this.m_timeDate == null) {
                this.m_timeDate = this.m_activity.initDate(this.m_time);
            }
            return this.m_timeDate;
        }

        public String getTooltip() {
            return this.m_tooltip;
        }

        public String getLegend() {
            return this.m_legend;
        }
    }

    public static class Legend
    implements Serializable {
        private String m_id;
        private String m_description;
        private String m_color;

        public String getId() {
            return this.m_id;
        }

        public String getDescription() {
            return this.m_description;
        }

        public String getColor() {
            return this.m_color;
        }

        protected Legend() {
        }

        public Legend(String id, String description, String color) {
            this.m_id = id;
            this.m_description = description;
            this.m_color = color;
        }
    }

    public static interface DateProvider {
        public Date parse(String var1, String var2);
    }
}

