/*
 * Decompiled with CFR 0.152.
 */
package com.infor.component.shared;

import com.infor.component.shared.PaletteColors;

public enum MenuSkinTheme {
    LIGHT("#ffffff"),
    DARK(PaletteColors.GRAPHITE[8]),
    AMBER(PaletteColors.AMBER[5]),
    AMETHYST(PaletteColors.AMETHYST[5]),
    AZURE(PaletteColors.AZURE[5]),
    EMERALD(PaletteColors.EMERALD[5]),
    RUBY(PaletteColors.RUBY[5]),
    SLATE(PaletteColors.SLATE[5]),
    TURQUOISE(PaletteColors.TURQUOISE[5]),
    CUSTOM(null);

    private String m_color;

    public static MenuSkinTheme strToEnum(String value) {
        try {
            return MenuSkinTheme.valueOf(value.toUpperCase());
        }
        catch (Exception ex) {
            return MenuSkinTheme.getDefaultSkinTheme();
        }
    }

    private MenuSkinTheme(String color) {
        this.m_color = color;
    }

    public static MenuSkinTheme getDefaultSkinTheme() {
        return DARK;
    }

    public String getColor() {
        return this.m_color;
    }

    public String getLabel(String labelPrefix) {
        return labelPrefix + this.toString().toLowerCase();
    }
}

