/*
 * Decompiled with CFR 0.152.
 */
package com.infor.component.shared;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;

public class Assembly
implements Serializable {
    private ArrayList<Line> m_lines = new ArrayList();

    public void add(Line line) {
        this.m_lines.add(line);
    }

    public void replace(Line line) {
        int index = -1;
        for (Line l : this.m_lines) {
            ++index;
            if (!l.getId().equals(line.getId())) continue;
            break;
        }
        if (index != -1) {
            this.m_lines.set(index, line);
        }
    }

    public Iterator<Line> getLines() {
        return this.m_lines.iterator();
    }

    public boolean isLayouted() {
        if (this.m_lines.size() == 0) {
            return true;
        }
        return this.m_lines.get(0).getX() != -1;
    }

    public static class Station
    extends Item
    implements Serializable {
        private boolean m_buffer = false;

        public Station(String id, boolean buffer) {
            super(id);
            this.m_buffer = buffer;
        }

        public boolean isBuffer() {
            return this.m_buffer;
        }
    }

    public static class Segment
    extends Item
    implements Serializable {
        private ArrayList<Station> m_stations = new ArrayList();

        public Segment(String id) {
            super(id);
        }

        public void add(Station station) {
            this.m_stations.add(station);
        }

        public void replace(Station station) {
            int index = -1;
            for (Station s : this.m_stations) {
                ++index;
                if (!s.getId().equals(station.getId())) continue;
                break;
            }
            if (index != -1) {
                this.m_stations.set(index, station);
            }
        }

        public Iterator<Station> getStations() {
            return this.m_stations.iterator();
        }
    }

    public static class Line
    extends Item
    implements Serializable {
        private ArrayList<Segment> m_segments = new ArrayList();
        private Station m_endingStation;
        private boolean m_pointingDown = false;

        public Line(String id) {
            super(id);
        }

        public void add(Segment segment) {
            this.m_segments.add(segment);
        }

        public void setEndingStation(Station station) {
            this.m_endingStation = station;
        }

        public Station getEndingStation() {
            return this.m_endingStation;
        }

        public void replace(Segment segment) {
            int index = -1;
            for (Segment s : this.m_segments) {
                ++index;
                if (!s.getId().equals(segment.getId())) continue;
                break;
            }
            if (index != -1) {
                this.m_segments.set(index, segment);
            }
        }

        public Iterator<Segment> getSegments() {
            return this.m_segments.iterator();
        }

        public void setPointingDown(boolean down) {
            this.m_pointingDown = down;
        }

        public boolean isPointingDown() {
            return this.m_pointingDown;
        }
    }

    public static class Item
    implements Serializable {
        private String m_id;
        private String m_text;
        private int m_x = -1;
        private int m_y = -1;
        private int m_width = -1;
        private int m_height = -1;

        public Item(String id) {
            this.m_id = id;
            this.m_text = id;
        }

        public String getId() {
            return this.m_id;
        }

        public void setText(String text) {
            this.m_text = text;
        }

        public String getText() {
            return this.m_text;
        }

        public void setPosition(int x, int y) {
            this.m_x = x;
            this.m_y = y;
        }

        public void setDimension(int w, int h) {
            this.m_width = w;
            this.m_height = h;
        }

        public int getX() {
            return this.m_x;
        }

        public int getY() {
            return this.m_y;
        }

        public int getWidth() {
            return this.m_width;
        }

        public int getHeight() {
            return this.m_height;
        }
    }
}

