/**
 * Begin Copyright Notice
 *
 * NOTICE
 *
 * THIS SOFTWARE IS THE PROPERTY OF AND CONTAINS CONFIDENTIAL INFORMATION OF
 * INFOR AND/OR ITS AFFILIATES OR SUBSIDIARIES AND SHALL NOT BE DISCLOSED
 * WITHOUT PRIOR WRITTEN PERMISSION. LICENSED CUSTOMERS MAY COPY AND ADAPT
 * THIS SOFTWARE FOR THEIR OWN USE IN ACCORDANCE WITH THE TERMS OF THEIR
 * SOFTWARE LICENSE AGREEMENT. ALL OTHER RIGHTS RESERVED.
 *
 * (c) COPYRIGHT 2018 INFOR. ALL RIGHTS RESERVED. THE WORD AND DESIGN MARKS
 * SET FORTH HEREIN ARE TRADEMARKS AND/OR REGISTERED TRADEMARKS OF INFOR
 * AND/OR ITS AFFILIATES AND SUBSIDIARIES. ALL RIGHTS RESERVED. ALL OTHER
 * TRADEMARKS LISTED HEREIN ARE THE PROPERTY OF THEIR RESPECTIVE OWNERS.
 *
 * End Copyright Notice
 */
package com.infor.ln.wb.common.shared.rpc;

import com.google.gwt.user.client.rpc.AsyncCallback;
import com.infor.ln.wb.common.shared.model.LNTable;
import com.infor.ln.wb.common.shared.model.LNTable.LNTableList;
import com.infor.ln.wb.common.shared.resources.CommonLNEnums;
import com.infor.ln.wb.common.shared.resources.CommonLNLabels;
import com.infor.ln.wb.common.shared.resources.CommonLNMessages;
import com.infor.ln.workbench.shared.resources.LNResources;

/**
 * An RPC service for common items.
 */
public interface IWbCommonServiceAsync {
    /**
     * Retrieve common LN resources (labels, enums, messages) from the backend.
     * @param conId the ID of the connection with the LN backend.
     * @param cback the callback accepting an {@link LNResources} with {@link CommonLNLabels}, {@link CommonLNEnums} and
     * {@link CommonLNMessages}.
     */
    void getResources(String conId, AsyncCallback<LNResources<CommonLNLabels,CommonLNEnums,CommonLNMessages>> cback);

    /**
     * Retrieve table references from the backend.
     * @param connectionId the ID of the connection with the LN backend.
     * @param tableName the name of the LN table.
     * @param direction indicates whether "from", "to", or "both" references should be retrieved.
     * @param callback the {@link AsyncCallback} accepting an {@link LNTableList} containing the requested table
     * and referenced tables (if any).
     */
    void getTableReferences(String connectionId, String tableName, String direction,
            AsyncCallback<LNTableList> callback);

    /**
     * Retrieve table fields from the backend.
     * @param connectionId the ID of the connection with the LN backend.
     * @param tableName the name of the LN table.
     * @param callback the {@link AsyncCallback} accepting an {@link LNTable}, or null if the table was not found.
     */
    void getTableFields(String connectionId, String tableName, AsyncCallback<LNTable> callback);
}
