/**
 * Begin Copyright Notice
 *
 * NOTICE
 *
 * THIS SOFTWARE IS THE PROPERTY OF AND CONTAINS CONFIDENTIAL INFORMATION OF
 * INFOR AND/OR ITS AFFILIATES OR SUBSIDIARIES AND SHALL NOT BE DISCLOSED
 * WITHOUT PRIOR WRITTEN PERMISSION. LICENSED CUSTOMERS MAY COPY AND ADAPT
 * THIS SOFTWARE FOR THEIR OWN USE IN ACCORDANCE WITH THE TERMS OF THEIR
 * SOFTWARE LICENSE AGREEMENT. ALL OTHER RIGHTS RESERVED.
 *
 * (c) COPYRIGHT 2018 INFOR. ALL RIGHTS RESERVED. THE WORD AND DESIGN MARKS
 * SET FORTH HEREIN ARE TRADEMARKS AND/OR REGISTERED TRADEMARKS OF INFOR
 * AND/OR ITS AFFILIATES AND SUBSIDIARIES. ALL RIGHTS RESERVED. ALL OTHER
 * TRADEMARKS LISTED HEREIN ARE THE PROPERTY OF THEIR RESPECTIVE OWNERS.
 *
 * End Copyright Notice
 */
package com.infor.ln.wb.common.shared.rpc;

import com.google.gwt.user.client.rpc.RemoteServiceRelativePath;
import com.google.gwt.user.client.rpc.XsrfProtectedService;
import com.infor.ln.wb.common.shared.model.LNTable;
import com.infor.ln.wb.common.shared.model.LNTable.LNTableList;
import com.infor.ln.wb.common.shared.resources.CommonLNEnums;
import com.infor.ln.wb.common.shared.resources.CommonLNLabels;
import com.infor.ln.wb.common.shared.resources.CommonLNMessages;
import com.infor.ln.workbench.shared.resources.LNResources;
import com.infor.ln.workbench.shared.rpc.ServerRPCException;

/**
 * An RPC service for common items.
 */
@RemoteServiceRelativePath("wbcommonservice")
public interface IWbCommonService extends XsrfProtectedService {
    /**
     * Retrieve common LN resources (labels, enums, messages) from the backend.
     * @param connectionId the ID of the connection with the LN backend.
     * @return an {@link LNResources} with {@link CommonLNLabels}, {@link CommonLNEnums} and {@link CommonLNMessages}.
     * @throws ServerRPCException when the call on the backend fails.
     */
    LNResources<CommonLNLabels,CommonLNEnums,CommonLNMessages> getResources(String connectionId)
            throws ServerRPCException;

    /**
     * Retrieve table references from the backend.
     * @param connectionId the ID of the connection with the LN backend.
     * @param tableName the name of the LN table.
     * @param direction indicates whether "from", "to", or "both" references should be retrieved.
     * @return an {@link LNTableList} containing the requested table and referenced tables (if any).
     * @throws ServerRPCException when the function call on the backend fails.
     */
    LNTableList getTableReferences(String connectionId, String tableName, String direction)
            throws ServerRPCException;

    /**
     * Retrieve table fields from the backend.
     * @param connectionId the ID of the connection with the LN backend.
     * @param tableName the name of the LN table.
     * @return an {@link LNTable}, or null if the table was not found.
     * @throws ServerRPCException when the function call on the backend fails.
     */
    LNTable getTableFields(String connectionId, String tableName) throws ServerRPCException;


}
