/**
 * Begin Copyright Notice
 *
 * NOTICE
 *
 * THIS SOFTWARE IS THE PROPERTY OF AND CONTAINS CONFIDENTIAL INFORMATION OF
 * INFOR AND/OR ITS AFFILIATES OR SUBSIDIARIES AND SHALL NOT BE DISCLOSED
 * WITHOUT PRIOR WRITTEN PERMISSION. LICENSED CUSTOMERS MAY COPY AND ADAPT
 * THIS SOFTWARE FOR THEIR OWN USE IN ACCORDANCE WITH THE TERMS OF THEIR
 * SOFTWARE LICENSE AGREEMENT. ALL OTHER RIGHTS RESERVED.
 *
 * (c) COPYRIGHT 2017 INFOR. ALL RIGHTS RESERVED. THE WORD AND DESIGN MARKS
 * SET FORTH HEREIN ARE TRADEMARKS AND/OR REGISTERED TRADEMARKS OF INFOR
 * AND/OR ITS AFFILIATES AND SUBSIDIARIES. ALL RIGHTS RESERVED. ALL OTHER
 * TRADEMARKS LISTED HEREIN ARE THE PROPERTY OF THEIR RESPECTIVE OWNERS.
 *
 * End Copyright Notice
 */
package com.infor.ln.wb.common.shared;



/**
 * This {@link Exception} class is used to report consistency or conformity errors when parsing a BML.
 * It is also used as a wrapper for server-side exceptions that are not emulated by GWT (such as OOME,
 * and XMLStreamException).
 */
public class BMLException extends Exception {
    /**
     * Indicates whether the {@link BMLException} is a wrapper for {@link OutOfMemoryError}.
     */
    public boolean isOOME = false;

    /**
     * Instantiate a new {@link BMLException} using the contents of the other exception.
     * @param other the exception whose message, cause and stack-trace to reuse.
     */
    public BMLException(Exception other) {
        super(other.getMessage(), other.getCause());
        this.setStackTrace(other.getStackTrace());
    }

    /**
     * Instantiate a new {@link BMLException} using the contents of the other error.
     * @param other the exception whose message, cause and stack-trace to reuse.
     * @param isOOME indicates whether the Error is an {@link OutOfMemoryError}.
     */
    public BMLException(Error other, boolean isOOME) {
        super(other.getMessage(), other.getCause());
        this.setStackTrace(other.getStackTrace());
        this.isOOME = isOOME;
    }

    /**
     * Instantiate a new empty {@link BMLException}.
     */
    public BMLException() {
        super();
    }

    /**
     * Instantiate a new {@link BMLException} with the given message.
     * @param message the detail message of this exception.
     */
    public BMLException(String message) {
        super(message);
    }

    /**
     * Instantiate a new {@link BMLException} with the given cause and message.
     * @param message the detail message of this exception.
     * @param cause the {@link Throwable} that in turn caused this exception to be thrown.
     */
    public BMLException(String message, Throwable cause) {
        super(message, cause);
    }
}
