/**
 * Begin Copyright Notice
 *
 * NOTICE
 *
 * THIS SOFTWARE IS THE PROPERTY OF AND CONTAINS CONFIDENTIAL INFORMATION OF
 * INFOR AND/OR ITS AFFILIATES OR SUBSIDIARIES AND SHALL NOT BE DISCLOSED
 * WITHOUT PRIOR WRITTEN PERMISSION. LICENSED CUSTOMERS MAY COPY AND ADAPT
 * THIS SOFTWARE FOR THEIR OWN USE IN ACCORDANCE WITH THE TERMS OF THEIR
 * SOFTWARE LICENSE AGREEMENT. ALL OTHER RIGHTS RESERVED.
 *
 * (c) COPYRIGHT 2017 INFOR. ALL RIGHTS RESERVED. THE WORD AND DESIGN MARKS
 * SET FORTH HEREIN ARE TRADEMARKS AND/OR REGISTERED TRADEMARKS OF INFOR
 * AND/OR ITS AFFILIATES AND SUBSIDIARIES. ALL RIGHTS RESERVED. ALL OTHER
 * TRADEMARKS LISTED HEREIN ARE THE PROPERTY OF THEIR RESPECTIVE OWNERS.
 *
 * End Copyright Notice
 */
package com.infor.ln.wb.common.client.view;

import com.google.gwt.dom.client.Document;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.i18n.client.BidiUtils;
import com.google.gwt.i18n.client.HasDirection.Direction;
import com.google.gwt.i18n.client.LocaleInfo;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.web.bindery.event.shared.EventBus;
import com.google.web.bindery.event.shared.HandlerRegistration;
import com.google.web.bindery.event.shared.SimpleEventBus;
import com.infor.ln.wb.common.client.events.TableSelectionChangeEvent;
import com.infor.ln.wb.common.client.presenter.ITablePathView;
import com.infor.ln.wb.common.client.utils.WBRtlUtils;
import com.infor.ln.wb.common.shared.model.LNReference;
import com.infor.ln.wb.common.shared.model.LNReference.ReferencePath;
import com.infor.ln.wb.common.shared.model.LNTable;


/**
 * {@link TablePathView} shows the path to the selected table.
 */
public class TablePathView extends Composite implements ITablePathView {
    private final EventBus mEventBus = new SimpleEventBus();
    private FlowPanel mPanel;
    private LNTable mMainTable;

    /**
     * Instantiate a new {@link TablePathView}.
     */
    public TablePathView() {
        mPanel = new FlowPanel();
        initWidget(mPanel);
    }

    @Override
    public void selectTable(LNTable selectedTable, ReferencePath tablePath) {
        mPanel.clear();

        mPanel.add(new TableLink(mMainTable));

        ReferencePath subPath = new ReferencePath();

        for (LNReference ref : tablePath) {
            subPath.inject(ref);

            LNTable table = ref.isFromReference() ? ref.getFromTable() : ref.getToTable();

            int arrowIndex = LocaleInfo.getCurrentLocale().isRTL() ? 0 : mPanel.getWidgetCount();
            mPanel.insert(new DirectionArrow(ref.isFromReference()), arrowIndex);

            int tableIndex = LocaleInfo.getCurrentLocale().isRTL() ? arrowIndex : arrowIndex + 1;
            mPanel.insert(new TableLink(table, new ReferencePath(subPath)), tableIndex);
        }
    }

    @Override
    public void setMainTable(LNTable table) {
        mMainTable = table;
        mPanel.clear();
    }

    @Override
    public HandlerRegistration addSelectionChangeHandler(TableSelectionChangeEvent.Handler handler) {
        return mEventBus.addHandler(TableSelectionChangeEvent.TYPE, handler);
    }

    private class TableLink extends Composite {
        TableLink(LNTable table) {
            this(table, new ReferencePath());
        }

        TableLink(final LNTable table, final ReferencePath path) {
            Anchor button = new Anchor();
            button.setText(table.getDescription() + WBRtlUtils.forceLeftToRight(" (" + table.getCode() + ")"));
            initWidget(button);
            setStylePrimaryName("TableLink");

            button.addClickHandler(new ClickHandler() {
                @Override
                public void onClick(ClickEvent event) {
                    selectTable(table, path);
                    mEventBus.fireEvent(new TableSelectionChangeEvent(table, path));
                }
            });
        }
    }

    private static class DirectionArrow extends Widget {
        DirectionArrow(boolean isFromReference) {
            setElement(Document.get().createLabelElement());
            setStylePrimaryName("DirectionArrow");

            BidiUtils.setDirectionOnElement(getElement(), Direction.LTR);
            boolean pointLeft = LocaleInfo.getCurrentLocale().isRTL() != isFromReference;
            getElement().setInnerHTML(" " + (pointLeft ? "<" : ">") + " ");
        }
    }
}
