/**
 * Begin Copyright Notice
 *
 * NOTICE
 *
 * THIS SOFTWARE IS THE PROPERTY OF AND CONTAINS CONFIDENTIAL INFORMATION OF
 * INFOR AND/OR ITS AFFILIATES OR SUBSIDIARIES AND SHALL NOT BE DISCLOSED
 * WITHOUT PRIOR WRITTEN PERMISSION. LICENSED CUSTOMERS MAY COPY AND ADAPT
 * THIS SOFTWARE FOR THEIR OWN USE IN ACCORDANCE WITH THE TERMS OF THEIR
 * SOFTWARE LICENSE AGREEMENT. ALL OTHER RIGHTS RESERVED.
 *
 * (c) COPYRIGHT 2017 INFOR. ALL RIGHTS RESERVED. THE WORD AND DESIGN MARKS
 * SET FORTH HEREIN ARE TRADEMARKS AND/OR REGISTERED TRADEMARKS OF INFOR
 * AND/OR ITS AFFILIATES AND SUBSIDIARIES. ALL RIGHTS RESERVED. ALL OTHER
 * TRADEMARKS LISTED HEREIN ARE THE PROPERTY OF THEIR RESPECTIVE OWNERS.
 *
 * End Copyright Notice
 */
package com.infor.ln.wb.common.client.presenter;

import com.infor.ln.wb.common.shared.model.LNReference.ReferencePath;
import com.infor.ln.wb.common.shared.model.LNTable;


/**
 * Interface of which an implementation is required for {@link ITableTreeView}.
 */
public interface ITableTreePresenter {
    /**
     * Add to-references to the view.
     * @param table the {@link LNTable} whose references to add.
     * @param tablePath the {@link ReferencePath} from the main table to the given table.
     */
    void addToReferences(LNTable table, ReferencePath tablePath);

    /**
     * Add from-references to the view.
     * @param table the {@link LNTable} whose references to add.
     * @param tablePath the {@link ReferencePath} from the main table to the given table.
     */
    void addFromReferences(LNTable table, ReferencePath tablePath);

    /**
     * Apply (or remove) a filter to the table tree.
     * @param value the value to match tree items against.
     */
    void applyFilter(String value);

    /**
     * Stop a filter that is in process, or remove the current filter.
     */
    void stopFilter();
}
