/**
 * Begin Copyright Notice
 *
 * NOTICE
 *
 * THIS SOFTWARE IS THE PROPERTY OF AND CONTAINS CONFIDENTIAL INFORMATION OF
 * INFOR AND/OR ITS AFFILIATES OR SUBSIDIARIES AND SHALL NOT BE DISCLOSED
 * WITHOUT PRIOR WRITTEN PERMISSION. LICENSED CUSTOMERS MAY COPY AND ADAPT
 * THIS SOFTWARE FOR THEIR OWN USE IN ACCORDANCE WITH THE TERMS OF THEIR
 * SOFTWARE LICENSE AGREEMENT. ALL OTHER RIGHTS RESERVED.
 *
 * (c) COPYRIGHT 2018 INFOR. ALL RIGHTS RESERVED. THE WORD AND DESIGN MARKS
 * SET FORTH HEREIN ARE TRADEMARKS AND/OR REGISTERED TRADEMARKS OF INFOR
 * AND/OR ITS AFFILIATES AND SUBSIDIARIES. ALL RIGHTS RESERVED. ALL OTHER
 * TRADEMARKS LISTED HEREIN ARE THE PROPERTY OF THEIR RESPECTIVE OWNERS.
 *
 * End Copyright Notice
 */
package com.infor.ln.wb.common.client.presenter;

import com.google.web.bindery.event.shared.HandlerRegistration;
import com.infor.ln.wb.common.client.events.TableSelectionChangeEvent;
import com.infor.ln.wb.common.shared.model.LNReference;
import com.infor.ln.wb.common.shared.model.LNReference.ReferencePath;
import com.infor.ln.wb.common.shared.model.LNTable;

/**
 * This is the interface required for views that support display of the currently selected table.
 * <br><br>
 * The view can be initialized using {@link #setMainTable(LNTable)}; this clears the view. To show a selection, call
 * {@link #selectTable(LNTable, ReferencePath)}. The view can then show the entire path, starting at the main table.
 * When the user clicks on a table to select it, the view fires a {@link TableSelectionChangeEvent}.
 */
public interface ITablePathView {
    /**
     * Set or reset the main table.
     * @param table the new {@link LNTable} that is at the start of all paths.
     */
    void setMainTable(LNTable table);

    /**
     * Show the path to the given table in the view, starting at the main table.
     * @param table the {@link LNTable} that was selected.
     * @param tablePath a list of {@link LNReference}s indicating the path from the main table
     * to the selected table.
     */
    void selectTable(LNTable table, ReferencePath tablePath);

    /**
     * Add an event handler for table selection events. The view should fire this event when the user clicks on a table
     * in the path.
     * @param handler the {@link TableSelectionChangeEvent} handler that should be called.
     * @return a {@link HandlerRegistration} using which the handler can be removed.
     */
    HandlerRegistration addSelectionChangeHandler(TableSelectionChangeEvent.Handler handler);
}
