/**
 * Begin Copyright Notice
 *
 * NOTICE
 *
 * THIS SOFTWARE IS THE PROPERTY OF AND CONTAINS CONFIDENTIAL INFORMATION OF
 * INFOR AND/OR ITS AFFILIATES OR SUBSIDIARIES AND SHALL NOT BE DISCLOSED
 * WITHOUT PRIOR WRITTEN PERMISSION. LICENSED CUSTOMERS MAY COPY AND ADAPT
 * THIS SOFTWARE FOR THEIR OWN USE IN ACCORDANCE WITH THE TERMS OF THEIR
 * SOFTWARE LICENSE AGREEMENT. ALL OTHER RIGHTS RESERVED.
 *
 * (c) COPYRIGHT 2018 INFOR. ALL RIGHTS RESERVED. THE WORD AND DESIGN MARKS
 * SET FORTH HEREIN ARE TRADEMARKS AND/OR REGISTERED TRADEMARKS OF INFOR
 * AND/OR ITS AFFILIATES AND SUBSIDIARIES. ALL RIGHTS RESERVED. ALL OTHER
 * TRADEMARKS LISTED HEREIN ARE THE PROPERTY OF THEIR RESPECTIVE OWNERS.
 *
 * End Copyright Notice
 */
package com.infor.ln.wb.common.client.presenter;

import java.util.List;
import java.util.Set;

import com.google.web.bindery.event.shared.HandlerRegistration;
import com.infor.ln.wb.common.client.events.TableFieldSelectionChangeEvent;
import com.infor.ln.wb.common.shared.model.LNTable;
import com.infor.ln.wb.common.shared.model.LNTable.Field;

/**
 * This is the interface required for views that support selection of {@link Field}s of an {@link LNTable}.
 * <br><br>
 * The view can be filled using {@link #setData} and modified using {@link #setFieldSelected}. When the user selects or
 * de-selects a field, the view fires a {@link TableFieldSelectionChangeEvent}.
 * <br>
 * <b>Note:</b> A presenter built for a view using this interface should not rely on the view updating itself after a
 * change in the selection. It should explicitly update the view using {@link #setFieldSelected(Field, boolean)}.
 */
public interface ITableFieldView {
    /**
     * Make the view read-only or editable.
     * @param readonly indicates whether the selection column must be read-only.
     */
    void setReadonly(boolean readonly);

    /**
     * Show the fields of the given table.
     * @param fields the {@link List} of {@link Field}s to show.
     * @param selectedFields the current set of selected fields.
     */
    void setData(List<Field> fields, Set<Field> selectedFields);

    /**
     * Select the record of the given field in the grid and scroll it into view.
     * @param field the {@link Field} to show.
     */
    void selectField(Field field);

    /**
     * Add or remove the given field from the field selection.
     * @param field the field that was (de-)selected.
     * @param selected indicates whether the field is currently selected.
     */
    void setFieldSelected(Field field, boolean selected);

    /**
     * Add an event handler for field selection events. The view should fire this event when the user adds a field
     * to, or removes a field from, the selection.
     * @param handler the {@link TableFieldSelectionChangeEvent} handler that should be called.
     * @return a {@link HandlerRegistration} using which the handler can be removed.
     */
    HandlerRegistration addFieldSelectionChangeHandler(TableFieldSelectionChangeEvent.Handler handler);
}
