/**
 * Begin Copyright Notice
 *
 * NOTICE
 *
 * THIS SOFTWARE IS THE PROPERTY OF AND CONTAINS CONFIDENTIAL INFORMATION OF
 * INFOR AND/OR ITS AFFILIATES OR SUBSIDIARIES AND SHALL NOT BE DISCLOSED
 * WITHOUT PRIOR WRITTEN PERMISSION. LICENSED CUSTOMERS MAY COPY AND ADAPT
 * THIS SOFTWARE FOR THEIR OWN USE IN ACCORDANCE WITH THE TERMS OF THEIR
 * SOFTWARE LICENSE AGREEMENT. ALL OTHER RIGHTS RESERVED.
 *
 * (c) COPYRIGHT 2018 INFOR. ALL RIGHTS RESERVED. THE WORD AND DESIGN MARKS
 * SET FORTH HEREIN ARE TRADEMARKS AND/OR REGISTERED TRADEMARKS OF INFOR
 * AND/OR ITS AFFILIATES AND SUBSIDIARIES. ALL RIGHTS RESERVED. ALL OTHER
 * TRADEMARKS LISTED HEREIN ARE THE PROPERTY OF THEIR RESPECTIVE OWNERS.
 *
 * End Copyright Notice
 */
package com.infor.ln.wb.common.client.events;

import com.google.gwt.event.shared.EventHandler;
import com.google.web.bindery.event.shared.Event;
import com.infor.ln.wb.common.shared.model.LNReference.ReferencePath;
import com.infor.ln.wb.common.shared.model.LNTable;

/**
 * Event that is fired when a different table is selected.
 */
public class TableSelectionChangeEvent extends Event<TableSelectionChangeEvent.Handler> {
    /**
     * Handler interface for {@link TableSelectionChangeEvent}.
     */
    public interface Handler extends EventHandler {
        /**
         * Called when a different table is selected.
         * @param table the {@link LNTable} that was selected.
         * @param tablePath the {@link ReferencePath} from the main table to the selected table.
         */
        void onTableSelectionChanged(LNTable table, ReferencePath tablePath);
    }

    /**
     * Event type for {@link TableSelectionChangeEvent}.
     */
    public static final Type<Handler> TYPE = new Type<>();

    private final LNTable mTable;
    private final ReferencePath mTablePath;

    /**
     * Instantiate a new {@link TableSelectionChangeEvent}.
     * @param table the {@link LNTable} that was selected.
     * @param tablePath the {@link ReferencePath} from the main table to the selected table.
     */
    public TableSelectionChangeEvent(LNTable table, ReferencePath tablePath) {
        mTable = table;
        mTablePath = tablePath;
    }

    @Override
    public com.google.web.bindery.event.shared.Event.Type<Handler> getAssociatedType() {
        return TYPE;
    }

    @Override
    protected void dispatch(Handler handler) {
        handler.onTableSelectionChanged(mTable, mTablePath);
    }
}
