/**
 * Begin Copyright Notice
 *
 * NOTICE
 *
 * THIS SOFTWARE IS THE PROPERTY OF AND CONTAINS CONFIDENTIAL INFORMATION OF
 * INFOR AND/OR ITS AFFILIATES OR SUBSIDIARIES AND SHALL NOT BE DISCLOSED
 * WITHOUT PRIOR WRITTEN PERMISSION. LICENSED CUSTOMERS MAY COPY AND ADAPT
 * THIS SOFTWARE FOR THEIR OWN USE IN ACCORDANCE WITH THE TERMS OF THEIR
 * SOFTWARE LICENSE AGREEMENT. ALL OTHER RIGHTS RESERVED.
 *
 * (c) COPYRIGHT 2018 INFOR. ALL RIGHTS RESERVED. THE WORD AND DESIGN MARKS
 * SET FORTH HEREIN ARE TRADEMARKS AND/OR REGISTERED TRADEMARKS OF INFOR
 * AND/OR ITS AFFILIATES AND SUBSIDIARIES. ALL RIGHTS RESERVED. ALL OTHER
 * TRADEMARKS LISTED HEREIN ARE THE PROPERTY OF THEIR RESPECTIVE OWNERS.
 *
 * End Copyright Notice
 */
package com.infor.ln.wb.common.client;

import com.google.gwt.core.shared.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.rpc.HasRpcToken;
import com.infor.component.client.utils.SuccessCallback;
import com.infor.ln.wb.common.shared.resources.CommonLNEnums;
import com.infor.ln.wb.common.shared.resources.CommonLNLabels;
import com.infor.ln.wb.common.shared.resources.CommonLNMessages;
import com.infor.ln.wb.common.shared.resources.FakeCommonLNLabels;
import com.infor.ln.wb.common.shared.resources.FakeCommonLNMessages;
import com.infor.ln.wb.common.shared.rpc.IWbCommonService;
import com.infor.ln.wb.common.shared.rpc.IWbCommonServiceAsync;
import com.infor.ln.workbench.client.WorkbenchLib;
import com.infor.ln.workbench.shared.resources.LNResources;

/**
 *
 */
public final class WbCommon {
    private static CommonLNLabels sLabels;
    private static CommonLNEnums sEnums;
    private static CommonLNMessages sMessages;

    private static IWbCommonServiceAsync sRpcService = GWT.create(IWbCommonService.class);
    static {
        ((HasRpcToken) sRpcService).setRpcToken(WorkbenchLib.getInstance().getToken());   // Set CSRF token
    }

    private WbCommon() {
    }

    /**
     * Initialize resources (labels, messages, questions) fetched from the backend.
     * @param cback The callback to call when the response is received. May be null, but then it is indeterminate
     * whether resources can be used.
     * @see #labels
     * @see #enums
     * @see #messages
     */
    public static void initializeResources(SuccessCallback<Void> cback) {
        initializeResources(false, cback);
    }

    /**
     * Initialize resources (labels, messages, questions) fetched from the backend.
     * @param fakeResources If true, no call to the backend is performed, but fake translations are used. This is useful
     * for both manual and automatic testing.
     * @see #labels
     * @see #enums
     * @see #messages
     */
    public static void initializeResources(boolean fakeResources) {
        initializeResources(fakeResources, null);
    }

    private static void initializeResources(boolean fakeResources, final SuccessCallback<Void> cback) {
        if (fakeResources) {
            sLabels = new FakeCommonLNLabels();
            sMessages = new FakeCommonLNMessages();
            sEnums = new CommonLNEnums();
            if (cback != null) {
                cback.onSuccess(null);
            }
        } else {
            sRpcService.getResources(WorkbenchLib.getInstance().getConnectionId(),
                    new AsyncCallback<LNResources<CommonLNLabels, CommonLNEnums, CommonLNMessages>>() {
                        @Override
                        public void onSuccess(LNResources<CommonLNLabels, CommonLNEnums, CommonLNMessages> result) {
                            sLabels = result.getLabels();
                            sEnums = result.getEnums();
                            sMessages = result.getMessages();
                            if (cback != null) {
                                cback.onSuccess(null);
                            }
                        }

                        @Override
                        public void onFailure(Throwable caught) {
                            WorkbenchLib.getInstance().showException(caught);
                        }
            });
        }
    }

    /**
     * Get the labels retrieved from the backend.
     * @return the {@link CommonLNLabels}.
     */
    public static CommonLNLabels labels() {
        return sLabels;
    }

    /**
     * Get the enums retrieved from the backend.
     * @return the {@link CommonLNEnums}.
     */
    public static CommonLNEnums enums() {
        return sEnums;
    }

    /**
     * Get the messages retrieved from the backend.
     * @return the {@link CommonLNMessages}.
     */
    public static CommonLNMessages messages() {
        return sMessages;
    }
}
