/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client.ui;

import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.BeforeSelectionEvent;
import com.google.gwt.event.logical.shared.BeforeSelectionHandler;
import com.google.gwt.event.logical.shared.HasBeforeSelectionHandlers;
import com.google.gwt.event.logical.shared.HasSelectionHandlers;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.layout.client.Layout;
import com.google.gwt.resources.client.CommonResources;
import com.google.gwt.safehtml.shared.SafeHtml;
import com.google.gwt.safehtml.shared.annotations.IsSafeHtml;
import com.google.gwt.safehtml.shared.annotations.SuppressIsSafeHtmlCastCheck;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.ui.AnimatedLayout;
import com.google.gwt.user.client.ui.DeckLayoutPanel;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasWidgets;
import com.google.gwt.user.client.ui.IndexedPanel;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.LayoutPanel;
import com.google.gwt.user.client.ui.ProvidesResize;
import com.google.gwt.user.client.ui.ResizeComposite;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Iterator;

public class TabLayoutPanel
extends ResizeComposite
implements HasWidgets,
ProvidesResize,
IndexedPanel.ForIsWidget,
AnimatedLayout,
HasBeforeSelectionHandlers<Integer>,
HasSelectionHandlers<Integer> {
    private static final String CONTENT_CONTAINER_STYLE = "gwt-TabLayoutPanelContentContainer";
    private static final String CONTENT_STYLE = "gwt-TabLayoutPanelContent";
    private static final String TAB_STYLE = "gwt-TabLayoutPanelTab";
    private static final String TAB_INNER_STYLE = "gwt-TabLayoutPanelTabInner";
    private static final int BIG_ENOUGH_TO_NOT_WRAP = 16384;
    private final TabbedDeckLayoutPanel deckPanel = new TabbedDeckLayoutPanel();
    private final FlowPanel tabBar = new FlowPanel();
    private final ArrayList<Tab> tabs = new ArrayList();
    private int selectedIndex = -1;

    public TabLayoutPanel(double barHeight, Style.Unit barUnit) {
        LayoutPanel panel = new LayoutPanel();
        this.initWidget(panel);
        panel.add(this.tabBar);
        panel.setWidgetLeftRight(this.tabBar, 0.0, Style.Unit.PX, 0.0, Style.Unit.PX);
        panel.setWidgetTopHeight(this.tabBar, 0.0, Style.Unit.PX, barHeight, barUnit);
        panel.setWidgetVerticalPosition(this.tabBar, Layout.Alignment.END);
        this.deckPanel.addStyleName(CONTENT_CONTAINER_STYLE);
        panel.add(this.deckPanel);
        panel.setWidgetLeftRight(this.deckPanel, 0.0, Style.Unit.PX, 0.0, Style.Unit.PX);
        panel.setWidgetTopBottom(this.deckPanel, barHeight, barUnit, 0.0, Style.Unit.PX);
        this.tabBar.getElement().getStyle().setWidth(16384.0, Style.Unit.PX);
        this.tabBar.setStyleName("gwt-TabLayoutPanelTabs");
        this.setStyleName("gwt-TabLayoutPanel");
    }

    public void add(IsWidget w) {
        this.add(TabLayoutPanel.asWidgetOrNull(w));
    }

    public void add(IsWidget w, IsWidget tab) {
        this.add(TabLayoutPanel.asWidgetOrNull(w), TabLayoutPanel.asWidgetOrNull(tab));
    }

    public void add(IsWidget w, String text) {
        this.add(TabLayoutPanel.asWidgetOrNull(w), text);
    }

    public void add(IsWidget w, @IsSafeHtml String text, boolean asHtml) {
        this.add(TabLayoutPanel.asWidgetOrNull(w), text, asHtml);
    }

    @Override
    public void add(Widget w) {
        this.insert(w, this.getWidgetCount());
    }

    public void add(Widget child, String text) {
        this.insert(child, text, this.getWidgetCount());
    }

    public void add(Widget child, SafeHtml html) {
        this.add(child, html.asString(), true);
    }

    public void add(Widget child, @IsSafeHtml String text, boolean asHtml) {
        this.insert(child, text, asHtml, this.getWidgetCount());
    }

    public void add(Widget child, Widget tab) {
        this.insert(child, tab, this.getWidgetCount());
    }

    @Override
    public HandlerRegistration addBeforeSelectionHandler(BeforeSelectionHandler<Integer> handler) {
        return this.addHandler(handler, BeforeSelectionEvent.getType());
    }

    @Override
    public HandlerRegistration addSelectionHandler(SelectionHandler<Integer> handler) {
        return this.addHandler(handler, SelectionEvent.getType());
    }

    @Override
    public void animate(int duration) {
        this.animate(duration, null);
    }

    @Override
    public void animate(int duration, Layout.AnimationCallback callback) {
        this.deckPanel.animate(duration, callback);
    }

    @Override
    public void clear() {
        Iterator<Widget> it = this.iterator();
        while (it.hasNext()) {
            it.next();
            it.remove();
        }
    }

    @Override
    public void forceLayout() {
        this.deckPanel.forceLayout();
    }

    public int getAnimationDuration() {
        return this.deckPanel.getAnimationDuration();
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    public Widget getTabWidget(int index) {
        this.checkIndex(index);
        return this.tabs.get(index).getWidget();
    }

    public Widget getTabWidget(IsWidget child) {
        return this.getTabWidget(TabLayoutPanel.asWidgetOrNull(child));
    }

    public Widget getTabWidget(Widget child) {
        this.checkChild(child);
        return this.getTabWidget(this.getWidgetIndex(child));
    }

    @Override
    public Widget getWidget(int index) {
        return this.deckPanel.getWidget(index);
    }

    @Override
    public int getWidgetCount() {
        return this.deckPanel.getWidgetCount();
    }

    @Override
    public int getWidgetIndex(IsWidget child) {
        return this.getWidgetIndex(TabLayoutPanel.asWidgetOrNull(child));
    }

    @Override
    public int getWidgetIndex(Widget child) {
        return this.deckPanel.getWidgetIndex(child);
    }

    public void insert(IsWidget child, int beforeIndex) {
        this.insert(TabLayoutPanel.asWidgetOrNull(child), beforeIndex);
    }

    public void insert(IsWidget child, IsWidget tab, int beforeIndex) {
        this.insert(TabLayoutPanel.asWidgetOrNull(child), TabLayoutPanel.asWidgetOrNull(tab), beforeIndex);
    }

    public void insert(IsWidget child, @IsSafeHtml String text, boolean asHtml, int beforeIndex) {
        this.insert(TabLayoutPanel.asWidgetOrNull(child), text, asHtml, beforeIndex);
    }

    public void insert(IsWidget child, String text, int beforeIndex) {
        this.insert(TabLayoutPanel.asWidgetOrNull(child), text, beforeIndex);
    }

    public void insert(Widget child, int beforeIndex) {
        this.insert(child, "", beforeIndex);
    }

    public void insert(Widget child, SafeHtml html, int beforeIndex) {
        this.insert(child, html.asString(), true, beforeIndex);
    }

    public void insert(Widget child, @IsSafeHtml String text, boolean asHtml, int beforeIndex) {
        Label contents = asHtml ? new HTML(text) : new Label(text);
        this.insert(child, contents, beforeIndex);
    }

    @SuppressIsSafeHtmlCastCheck
    public void insert(Widget child, String text, int beforeIndex) {
        this.insert(child, text, false, beforeIndex);
    }

    public void insert(Widget child, Widget tab, int beforeIndex) {
        this.insert(child, new Tab(tab), beforeIndex);
    }

    public boolean isAnimationVertical() {
        return this.deckPanel.isAnimationVertical();
    }

    @Override
    public Iterator<Widget> iterator() {
        return this.deckPanel.iterator();
    }

    @Override
    public boolean remove(int index) {
        if (index < 0 || index >= this.getWidgetCount()) {
            return false;
        }
        Widget child = this.getWidget(index);
        this.tabBar.remove(index);
        this.deckPanel.removeProtected(child);
        child.removeStyleName(CONTENT_STYLE);
        Tab tab = this.tabs.remove(index);
        tab.getWidget().removeFromParent();
        if (index == this.selectedIndex) {
            this.selectedIndex = -1;
            if (this.getWidgetCount() > 0) {
                this.selectTab(0);
            }
        } else if (index < this.selectedIndex) {
            --this.selectedIndex;
        }
        return true;
    }

    @Override
    public boolean remove(Widget w) {
        int index = this.getWidgetIndex(w);
        if (index == -1) {
            return false;
        }
        return this.remove(index);
    }

    public void selectTab(int index) {
        this.selectTab(index, true);
    }

    public void selectTab(int index, boolean fireEvents) {
        BeforeSelectionEvent<Integer> event;
        this.checkIndex(index);
        if (index == this.selectedIndex) {
            return;
        }
        if (fireEvents && (event = BeforeSelectionEvent.fire(this, index)) != null && event.isCanceled()) {
            return;
        }
        if (this.selectedIndex != -1) {
            this.tabs.get(this.selectedIndex).setSelected(false);
        }
        this.deckPanel.showWidget(index);
        this.tabs.get(index).setSelected(true);
        this.selectedIndex = index;
        if (fireEvents) {
            SelectionEvent.fire(this, index);
        }
    }

    public void selectTab(IsWidget child) {
        this.selectTab(TabLayoutPanel.asWidgetOrNull(child));
    }

    public void selectTab(IsWidget child, boolean fireEvents) {
        this.selectTab(TabLayoutPanel.asWidgetOrNull(child), fireEvents);
    }

    public void selectTab(Widget child) {
        this.selectTab(this.getWidgetIndex(child));
    }

    public void selectTab(Widget child, boolean fireEvents) {
        this.selectTab(this.getWidgetIndex(child), fireEvents);
    }

    public void setAnimationDuration(int duration) {
        this.deckPanel.setAnimationDuration(duration);
    }

    public void setAnimationVertical(boolean isVertical) {
        this.deckPanel.setAnimationVertical(isVertical);
    }

    public void setTabHTML(int index, @IsSafeHtml String html) {
        this.checkIndex(index);
        this.tabs.get(index).setWidget(new HTML(html));
    }

    public void setTabHTML(int index, SafeHtml html) {
        this.setTabHTML(index, html.asString());
    }

    public void setTabText(int index, String text) {
        this.checkIndex(index);
        this.tabs.get(index).setWidget(new Label(text));
    }

    private void checkChild(Widget child) {
        assert (this.getWidgetIndex(child) >= 0) : "Child is not a part of this panel";
    }

    private void checkIndex(int index) {
        assert (index >= 0 && index < this.getWidgetCount()) : "Index out of bounds";
    }

    private void insert(final Widget child, Tab tab, int beforeIndex) {
        assert (beforeIndex >= 0 && beforeIndex <= this.getWidgetCount()) : "beforeIndex out of bounds";
        int idx = this.getWidgetIndex(child);
        if (idx != -1) {
            this.remove(child);
            if (idx < beforeIndex) {
                --beforeIndex;
            }
        }
        this.deckPanel.insertProtected(child, beforeIndex);
        this.tabs.add(beforeIndex, tab);
        this.tabBar.insert(tab, beforeIndex);
        tab.addClickHandler(new ClickHandler(){

            @Override
            public void onClick(ClickEvent event) {
                TabLayoutPanel.this.selectTab(child);
            }
        });
        child.addStyleName(CONTENT_STYLE);
        if (this.selectedIndex == -1) {
            this.selectTab(0);
        } else if (this.selectedIndex >= beforeIndex) {
            ++this.selectedIndex;
        }
    }

    private class TabbedDeckLayoutPanel
    extends DeckLayoutPanel {
        private TabbedDeckLayoutPanel() {
        }

        @Override
        public void add(Widget w) {
            throw new UnsupportedOperationException("Use TabLayoutPanel.add() to alter the DeckLayoutPanel");
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException("Use TabLayoutPanel.clear() to alter the DeckLayoutPanel");
        }

        @Override
        public void insert(Widget w, int beforeIndex) {
            throw new UnsupportedOperationException("Use TabLayoutPanel.insert() to alter the DeckLayoutPanel");
        }

        @Override
        public boolean remove(Widget w) {
            return TabLayoutPanel.this.remove(w);
        }

        protected void insertProtected(Widget w, int beforeIndex) {
            super.insert(w, beforeIndex);
        }

        protected void removeProtected(Widget w) {
            super.remove(w);
        }
    }

    private class Tab
    extends SimplePanel {
        private com.google.gwt.dom.client.Element inner;
        private boolean replacingWidget;

        public Tab(Widget child) {
            super(Document.get().createDivElement());
            this.inner = Document.get().createDivElement();
            this.getElement().appendChild(this.inner);
            this.setWidget(child);
            this.setStyleName(TabLayoutPanel.TAB_STYLE);
            this.inner.setClassName(TabLayoutPanel.TAB_INNER_STYLE);
            this.getElement().addClassName(CommonResources.getInlineBlockStyle());
        }

        public HandlerRegistration addClickHandler(ClickHandler handler) {
            return this.addDomHandler(handler, ClickEvent.getType());
        }

        @Override
        public boolean remove(Widget w) {
            int index = TabLayoutPanel.this.tabs.indexOf(this);
            if (this.replacingWidget || index < 0) {
                return super.remove(w);
            }
            return TabLayoutPanel.this.remove(index);
        }

        public void setSelected(boolean selected) {
            if (selected) {
                this.addStyleDependentName("selected");
            } else {
                this.removeStyleDependentName("selected");
            }
        }

        @Override
        public void setWidget(Widget w) {
            this.replacingWidget = true;
            super.setWidget(w);
            this.replacingWidget = false;
        }

        @Override
        protected Element getContainerElement() {
            return (Element)this.inner.cast();
        }
    }
}

