/*
 * Decompiled with CFR 0.152.
 */
package com.infor.erpln.util.encryption;

public class HexString {
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final String HEX_DIGITS_STR = "0123456789ABCDEF";

    public static byte[] hexString2ByteArray(String hexString) {
        if (hexString.length() % 2 != 0) {
            return null;
        }
        hexString = hexString.toUpperCase();
        int byteArrayLength = hexString.length() / 2;
        byte[] byteArray = new byte[byteArrayLength];
        int byteArrayCounter = 0;
        int hexStringCounter = 0;
        for (byteArrayCounter = 0; byteArrayCounter < byteArrayLength; ++byteArrayCounter) {
            byte nibble1 = HexString.indexInHexString(hexString.charAt(hexStringCounter));
            byte nibble2 = HexString.indexInHexString(hexString.charAt(++hexStringCounter));
            ++hexStringCounter;
            if (nibble1 < 0 || nibble2 < 0) {
                return null;
            }
            byteArray[byteArrayCounter] = (byte)(nibble1 * 16 + nibble2);
        }
        return byteArray;
    }

    public static String byteArray2HexString(byte[] ba) {
        return new String(HexString.toByteArray(ba, 0, ba.length));
    }

    public static byte[] byteArray2HexByteArray(byte[] ba) {
        return HexString.toByteArray(ba, 0, ba.length);
    }

    private static byte[] toByteArray(byte[] ba, int offset, int length) {
        byte[] buf = new byte[length * 2];
        int i = offset;
        int j = 0;
        while (i < offset + length) {
            byte k = ba[i++];
            buf[j++] = (byte)HEX_DIGITS[k >>> 4 & 0xF];
            buf[j++] = (byte)HEX_DIGITS[k & 0xF];
        }
        return buf;
    }

    private static byte indexInHexString(char c) {
        for (byte i = 0; i < 16; i = (byte)(i + 1)) {
            if (HEX_DIGITS_STR.charAt(i) != c) continue;
            return i;
        }
        return -1;
    }
}

