/*
 * Decompiled with CFR 0.152.
 */
package com.infor.erpln.util;

import com.infor.erpln.util.NiceW3CDOMWriter;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class XmlUtil {
    private static final String XML_FEATURES_DISALLOW_DOCTYPE_DECL = "http://apache.org/xml/features/disallow-doctype-decl";
    private static final Logger LOG = ESAPI.getLogger(XmlUtil.class);

    public static Document newDocument() {
        try {
            return XmlUtil.newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException e) {
            throw new IllegalStateException(e);
        }
    }

    public static String getPrettyXml(byte[] iXmlInput) {
        String formattedString = "";
        try {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(iXmlInput);
            Document xmlDocument = XmlUtil.newDocumentBuilder().parse(inputStream);
            formattedString = NiceW3CDOMWriter.getPrettyXml(xmlDocument, 4);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            LOG.error(Logger.EVENT_FAILURE, "Exception in getPrettyXml()", (Throwable)e);
        }
        return formattedString;
    }

    public static Element createChildElement(Node parent, String name) {
        Element child = parent.getOwnerDocument().createElement(name);
        parent.appendChild(child);
        return child;
    }

    public static Element createChildElementWithText(Element parent, String name, String textValue) {
        Element child = parent.getOwnerDocument().createElement(name);
        parent.appendChild(child);
        Text textNode = parent.getOwnerDocument().createTextNode(textValue);
        child.appendChild(textNode);
        return child;
    }

    public static Node appendChild(Node parent, Node child) {
        Node nodeToAppend;
        if (parent.getOwnerDocument() != child.getOwnerDocument()) {
            Document doc = parent.getOwnerDocument();
            nodeToAppend = doc.importNode(child, true);
        } else {
            nodeToAppend = child;
        }
        parent.appendChild(nodeToAppend);
        return nodeToAppend;
    }

    public static Node appendText(Node parent, String textValue) {
        Text textNode = parent.getOwnerDocument().createTextNode(textValue);
        parent.appendChild(textNode);
        return textNode;
    }

    public static Element getFirstChildElementNamed(Element parent, String childName, boolean deepSearch) {
        if (parent == null) {
            throw new NullPointerException("Parent element cannot be null");
        }
        NodeList children = parent.getChildNodes();
        Element child = null;
        for (int i = 0; i < children.getLength() && child == null; ++i) {
            if (children.item(i).getNodeName().equals(childName)) {
                child = (Element)children.item(i);
                continue;
            }
            if (!deepSearch || children.item(i).getNodeType() != 1) continue;
            child = XmlUtil.getFirstChildElementNamed((Element)children.item(i), childName, deepSearch);
        }
        return child;
    }

    public static Element getFirstChildElement(Element parent) {
        if (parent == null) {
            throw new NullPointerException("Parent element cannot be null");
        }
        NodeList children = parent.getChildNodes();
        Element child = null;
        for (int i = 0; i < children.getLength() && child == null; ++i) {
            if (children.item(i).getNodeType() != 1) continue;
            child = (Element)children.item(i);
        }
        return child;
    }

    public static Element getNextSiblingElement(Element start) {
        if (start == null) {
            throw new NullPointerException("Start element cannot be null");
        }
        Node siblingNode = start;
        Element siblingElement = null;
        while ((siblingNode = siblingNode.getNextSibling()) != null) {
            if (siblingNode.getNodeType() != 1) continue;
            siblingElement = (Element)siblingNode;
            break;
        }
        return siblingElement;
    }

    public static String getTextForNode(Node node) {
        String returnString = "";
        NodeList children = node.getChildNodes();
        if (children != null) {
            for (int i = 0; i < children.getLength(); ++i) {
                Node childNode = children.item(i);
                if (childNode.getNodeType() != 3 && childNode.getNodeType() != 4) continue;
                returnString = childNode.getNodeValue();
                break;
            }
        }
        return returnString;
    }

    public static Node convertStringToNode(String a_string) {
        try {
            byte[] currentXMLBytes = a_string.getBytes("UTF-8");
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(currentXMLBytes);
            Document doc = XmlUtil.newDocumentBuilder().parse(byteArrayInputStream);
            return doc.getDocumentElement();
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            LOG.error(Logger.EVENT_FAILURE, "Exception in convertStringToNode()", (Throwable)e);
            return null;
        }
    }

    public static final String escapeAttributeValue(String iValue) {
        StringBuffer buffer = new StringBuffer(iValue);
        int size = buffer.length();
        block9: for (int i = 0; i < size; ++i) {
            switch (buffer.charAt(i)) {
                case '<': {
                    buffer.replace(i, i + 1, "&lt;");
                    size += 3;
                    i += 3;
                    continue block9;
                }
                case '>': {
                    buffer.replace(i, i + 1, "&gt;");
                    size += 3;
                    i += 3;
                    continue block9;
                }
                case '&': {
                    buffer.replace(i, i + 1, "&amp;");
                    size += 4;
                    i += 4;
                    continue block9;
                }
                case '\'': {
                    buffer.replace(i, i + 1, "&apos;");
                    size += 5;
                    i += 5;
                    continue block9;
                }
                case '\"': {
                    buffer.replace(i, i + 1, "&quot;");
                    size += 5;
                    i += 5;
                    continue block9;
                }
                case '\r': {
                    buffer.replace(1, 2, "&#13;");
                    size += 5;
                    i += 5;
                    continue block9;
                }
                case '\n': {
                    buffer.replace(1, 2, "&#10;");
                    size += 5;
                    i += 5;
                }
            }
        }
        return buffer.toString();
    }

    public static DocumentBuilder newDocumentBuilder() throws ParserConfigurationException {
        return XmlUtil.newDocumentBuilder(false);
    }

    public static DocumentBuilder newDocumentBuilder(boolean awareness) throws ParserConfigurationException {
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        docBuilderFactory.setFeature(XML_FEATURES_DISALLOW_DOCTYPE_DECL, true);
        docBuilderFactory.setXIncludeAware(false);
        docBuilderFactory.setExpandEntityReferences(false);
        docBuilderFactory.setNamespaceAware(awareness);
        return docBuilderFactory.newDocumentBuilder();
    }

    public static TransformerFactory newTransformerFactory() throws TransformerConfigurationException {
        TransformerFactory instance = TransformerFactory.newInstance();
        instance.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        return instance;
    }

    public static SAXParserFactory createSAXParserFactory() {
        try {
            SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
            saxParserFactory.setFeature(XML_FEATURES_DISALLOW_DOCTYPE_DECL, true);
            return saxParserFactory;
        }
        catch (ParserConfigurationException | SAXException e) {
            throw new IllegalStateException(e);
        }
    }

    private XmlUtil() {
    }
}

