/*
 * Decompiled with CFR 0.152.
 */
package com.infor.erpln.util;

import com.infor.erpln.util.ConnectionPoint;
import com.infor.erpln.util.ConnectionPointActivation;
import com.infor.erpln.util.XmlUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ParseXml
extends DefaultHandler {
    private static final String MISSING_ATTRIBUTE_STRING = "Missing attribute: ";
    private final Map<String, ConnectionPoint> m_EndpointHashmap = new HashMap<String, ConnectionPoint>();
    private static final String CONNECTIONPOINT = "connectionpoint";
    private static final String CONN_NAME = "name";
    private static final String CONN_HOSTNAME = "hostname";
    private static final String CONN_PORT = "port";
    private static final String CONN_TIMERDELAY = "timerdelay";
    private static final String CONN_MAXCONNECTIONS = "maxconnections";
    private static final String CONN_MAXREFERENCES = "maxreferences";
    private static final String CONN_MAXTHREADS = "maxthreads";
    private static final String CONN_FORCECLEANUP = "forcecleanup";
    private static final String ALIAS = "alias";
    private static final String ALIAS_LINKTO = "linkto";
    private static final String ACTIVATION = "activation";
    private static final String ACT_TYPE = "type";
    private static final String ACT_BSE = "bse";
    private static final String ACT_COMPANY = "company";
    private static final String ACT_BSHELL = "bshell";
    private static final String ACT_DAEMONOPTIONS = "daemonoptions";
    private static final String ACT_ENVIRONMENT = "environment";
    private static final String ACT_USER = "user";
    private static final String ACT_PASSWORD = "password";
    private static final String ACT_TENANT = "tenant";
    private ConnectionPoint mEndpoint;
    private boolean mConnectionPointsRoot = false;
    private static final Logger LOG = ESAPI.getLogger(ParseXml.class);
    private static final SAXParserFactory SAX_PARSER_FACTORY = XmlUtil.createSAXParserFactory();

    public void parse(String filename) {
        try (FileInputStream in = new FileInputStream(new File(filename));){
            SAXParser saxParser = SAX_PARSER_FACTORY.newSAXParser();
            saxParser.parse((InputStream)in, (DefaultHandler)this);
            LOG.info(Logger.EVENT_SUCCESS, "Parsed connection points file " + filename);
        }
        catch (IOException e) {
            LOG.error(Logger.EVENT_FAILURE, "Failed to read: " + filename, (Throwable)e);
        }
        catch (SAXException e) {
            LOG.error(Logger.EVENT_FAILURE, "Failed to parse: " + filename, (Throwable)e);
        }
        catch (ParserConfigurationException e) {
            LOG.error(Logger.EVENT_FAILURE, "Failed to create parser", (Throwable)e);
        }
    }

    @Override
    public void startElement(String iNamespaceURI, String iSimpleName, String iQualifiedName, Attributes iAttrs) throws SAXException {
        if (iQualifiedName.equals("connectionpoints")) {
            this.mConnectionPointsRoot = true;
        }
        if (iQualifiedName.equals(CONNECTIONPOINT)) {
            this.getConnectionPointString(iAttrs);
        }
        if (iQualifiedName.equals(ALIAS)) {
            this.getAliasString(iAttrs);
        }
        if (iQualifiedName.equals(ACTIVATION)) {
            this.getActivationString(iAttrs);
        }
    }

    private void getActivationString(Attributes iAttrs) throws SAXException {
        String tenant;
        String password;
        String user;
        String environment;
        String bshell;
        if (this.mEndpoint == null) {
            throw new SAXException("Activation element only inside ConnectionPoint element, or element (connnectionpoint) not found (maybe a spelling issue)");
        }
        ConnectionPointActivation cpActivation = this.mEndpoint.createActivation();
        String type = iAttrs.getValue(ACT_TYPE);
        if (type == null) {
            throw new SAXException("Missing attribute: type");
        }
        cpActivation.setActivationType(type);
        String bse = iAttrs.getValue(ACT_BSE);
        if (bse == null) {
            throw new SAXException("Missing attribute: bse");
        }
        cpActivation.setActivationBse(bse);
        String company = iAttrs.getValue(ACT_COMPANY);
        if (company != null) {
            cpActivation.setActivationCompany(company);
        }
        if ((bshell = iAttrs.getValue(ACT_BSHELL)) == null) {
            throw new SAXException("Missing attribute: bshell");
        }
        cpActivation.setActivationBshell(bshell);
        String daemonoptions = iAttrs.getValue(ACT_DAEMONOPTIONS);
        if (daemonoptions != null) {
            cpActivation.setActivationDaemonOptions(daemonoptions);
        }
        if ((environment = iAttrs.getValue(ACT_ENVIRONMENT)) != null) {
            cpActivation.setActivationEnvironment(environment);
        }
        if ((user = iAttrs.getValue(ACT_USER)) != null) {
            cpActivation.setActivationUser(user);
        }
        if ((password = iAttrs.getValue(ACT_PASSWORD)) != null) {
            cpActivation.setActivationPassword(password);
        }
        if ((tenant = iAttrs.getValue(ACT_TENANT)) != null) {
            cpActivation.setActivationTenant(tenant);
        }
    }

    private void getAliasString(Attributes iAttrs) throws SAXException {
        if (!this.mConnectionPointsRoot) {
            throw new SAXException("alias element should always be inside of ConnectionPoints root element, or root element(connectionpoints) not found (maybe a spelling issue)");
        }
        this.mEndpoint = new ConnectionPoint();
        String strValue = iAttrs.getValue(CONN_NAME);
        if (strValue == null) {
            throw new SAXException("Missing attribute: name");
        }
        this.mEndpoint.setName(strValue);
        strValue = iAttrs.getValue(ALIAS_LINKTO);
        if (strValue == null) {
            throw new SAXException("Missing attribute: linkto");
        }
        this.mEndpoint.setLinkTo(strValue);
        strValue = iAttrs.getValue(ACT_COMPANY);
        if (strValue != null) {
            this.mEndpoint.setBdeManagerCompany(strValue);
        }
    }

    private void getConnectionPointString(Attributes iAttrs) throws SAXException {
        if (!this.mConnectionPointsRoot) {
            throw new SAXException("ConnectionPoint element should always be inside of ConnectionPoints root element, or root element(connectionpoints) not found (maybe a spelling issue)");
        }
        this.mEndpoint = new ConnectionPoint();
        String strValue = iAttrs.getValue(CONN_NAME);
        if (strValue == null) {
            throw new SAXException("Missing attribute: name");
        }
        this.mEndpoint.setName(strValue);
        strValue = iAttrs.getValue(CONN_HOSTNAME);
        if (strValue == null) {
            throw new SAXException("Missing attribute: hostname");
        }
        this.mEndpoint.setHostName(strValue);
        strValue = iAttrs.getValue(CONN_PORT);
        if (strValue == null) {
            throw new SAXException("Missing attribute: port");
        }
        this.mEndpoint.setPort(strValue);
        strValue = iAttrs.getValue(CONN_TIMERDELAY);
        if (strValue != null) {
            this.mEndpoint.setTimerDelay(strValue);
        }
        if ((strValue = iAttrs.getValue(CONN_MAXCONNECTIONS)) != null) {
            this.mEndpoint.setMaxConnections(strValue);
        }
        if ((strValue = iAttrs.getValue(CONN_MAXREFERENCES)) != null) {
            this.mEndpoint.setMaxReferences(strValue);
        }
        if ((strValue = iAttrs.getValue(CONN_MAXTHREADS)) != null) {
            this.mEndpoint.setMaxThreads(strValue);
        }
        if ("false".equals(strValue = iAttrs.getValue(CONN_FORCECLEANUP))) {
            this.mEndpoint.setForceCleanup(false);
        }
    }

    @Override
    public void endElement(String iNamespaceURI, String iSimpleName, String iQualifiedName) throws SAXException {
        if (iQualifiedName.equals("connectionpoints")) {
            this.mConnectionPointsRoot = false;
        }
        if (iQualifiedName.equals(CONNECTIONPOINT) || iQualifiedName.equals(ALIAS)) {
            this.m_EndpointHashmap.put(this.mEndpoint.getName(), this.mEndpoint);
            this.mEndpoint = null;
        }
    }

    public Map<String, ConnectionPoint> getConnectionPoints() {
        return this.m_EndpointHashmap;
    }
}

