/*
 * Decompiled with CFR 0.152.
 */
package com.infor.erpln.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class DomSerializer {
    private static final String s_encoding = "UTF8";
    private OutputStreamWriter mWriter;
    private OutputStream mOutput;
    private boolean mInitialized = false;
    private Node mRoot;
    private static final char[] AMP = new char[]{'&', 'a', 'm', 'p', ';'};
    private static final char[] LT = new char[]{'&', 'l', 't', ';'};
    private static final char[] GT = new char[]{'&', 'g', 't', ';'};
    private static final char[] QUOTE_ENTITY = new char[]{'&', 'q', 'u', 'o', 't', ';'};
    private static final char[] APOS_ENTITY = new char[]{'&', 'a', 'p', 'o', 's', ';'};

    public DomSerializer(Node iNode) throws IOException {
        this(iNode, new ByteArrayOutputStream(512));
    }

    public DomSerializer(Node iNode, OutputStream iOutputstream) throws IOException {
        this.mRoot = iNode;
        this.mOutput = iOutputstream;
        this.initialize();
    }

    private void initialize() throws IOException {
        this.mWriter = new OutputStreamWriter(this.mOutput, s_encoding);
        this.write(this.mRoot);
        this.mWriter.flush();
        this.mInitialized = true;
    }

    public void close() {
        if (this.mWriter != null) {
            try {
                this.mWriter.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.mOutput != null) {
            try {
                this.mOutput.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public String toString() {
        try {
            if (!(this.mOutput instanceof ByteArrayOutputStream)) {
                return super.toString();
            }
            return ((ByteArrayOutputStream)this.mOutput).toString(s_encoding);
        }
        catch (Exception exception) {
            return super.toString();
        }
    }

    public byte[] getBytes() {
        if (this.mOutput instanceof ByteArrayOutputStream) {
            try {
                if (!this.mInitialized) {
                    this.initialize();
                }
                return ((ByteArrayOutputStream)this.mOutput).toByteArray();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return super.toString().getBytes();
    }

    private void write(Node node) throws IOException {
        if (node == null) {
            return;
        }
        switch (node.getNodeType()) {
            default: {
                break;
            }
            case 9: {
                this.mWriter.write("<?xml version=\"1.0\"?>");
                for (Node node1 = node.getFirstChild(); node1 != null; node1 = node1.getNextSibling()) {
                    this.write(node1);
                }
                break;
            }
            case 1: {
                Node node2;
                NamedNodeMap namednodemap;
                this.mWriter.write(60);
                String s = node.getNodeName();
                if (s != null) {
                    this.mWriter.write(s);
                }
                if ((namednodemap = node.getAttributes()) != null) {
                    int i1 = namednodemap.getLength();
                    for (int k1 = 0; k1 < i1; ++k1) {
                        this.write(namednodemap.item(k1));
                    }
                }
                if ((node2 = node.getFirstChild()) == null) {
                    this.mWriter.write(47);
                    this.mWriter.write(62);
                    break;
                }
                this.mWriter.write(62);
                while (node2 != null) {
                    this.write(node2);
                    node2 = node2.getNextSibling();
                }
                this.mWriter.write(60);
                this.mWriter.write(47);
                this.mWriter.write(s);
                this.mWriter.write(62);
                break;
            }
            case 3: {
                String s1 = node.getNodeValue();
                if (s1 == null) break;
                int k = s1.length();
                for (int j1 = 0; j1 < k; ++j1) {
                    char c1 = s1.charAt(j1);
                    if (c1 == '<') {
                        this.mWriter.write(LT);
                        continue;
                    }
                    if (c1 == '&') {
                        this.mWriter.write(AMP);
                        continue;
                    }
                    if (c1 == '>') {
                        this.mWriter.write(GT);
                        continue;
                    }
                    this.mWriter.write(c1);
                }
                break;
            }
            case 2: {
                this.mWriter.write(32);
                this.mWriter.write(node.getNodeName());
                this.mWriter.write(61);
                this.mWriter.write(34);
                String s2 = node.getNodeValue();
                if (s2 != null) {
                    for (int l = 0; l < s2.length(); ++l) {
                        char c = s2.charAt(l);
                        if (c == '\"') {
                            this.mWriter.write(QUOTE_ENTITY);
                            continue;
                        }
                        if (c == '\'') {
                            this.mWriter.write(APOS_ENTITY);
                            continue;
                        }
                        if (c == '<') {
                            this.mWriter.write(LT);
                            continue;
                        }
                        if (c == '&') {
                            this.mWriter.write(AMP);
                            continue;
                        }
                        this.mWriter.write(c);
                    }
                }
                this.mWriter.write(34);
                break;
            }
            case 4: {
                this.writeCDATA(node);
                break;
            }
            case 8: {
                this.mWriter.write("<!--");
                this.mWriter.write(node.getNodeValue());
                this.mWriter.write("-->");
                break;
            }
            case 11: {
                this.writeDocumentFragment(node);
                break;
            }
            case 10: {
                this.writeDTD(node);
                break;
            }
            case 6: {
                this.writeEntity(node);
                break;
            }
            case 5: {
                this.writeEntityReference(node);
                break;
            }
            case 12: {
                this.writeNotation(node);
                break;
            }
            case 7: {
                this.writePI(node);
            }
        }
    }

    private void writePI(Node node) throws IOException {
    }

    private void writeCDATA(Node node) throws IOException {
        this.mWriter.write("<![CDATA[");
        this.mWriter.write(node.getNodeValue());
        this.mWriter.write("]]>");
    }

    private void writeNotation(Node node) throws IOException {
    }

    private void writeEntityReference(Node node) throws IOException {
    }

    private void writeEntity(Node node) throws IOException {
    }

    private void writeDocumentFragment(Node node) throws IOException {
    }

    private void writeDTD(Node node) throws IOException {
    }
}

