/*
 * Decompiled with CFR 0.152.
 */
package com.infor.erpln.util;

import com.infor.erpln.util.ConnectionPoint;
import com.infor.erpln.util.ConnectionPointActivation;
import com.infor.erpln.util.ParseXml;
import com.infor.erpln.util.encryption.PasswordEncryption;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.Logger;

public class ConnectionPointsManager {
    private Map<String, ConnectionPoint> mConnectionPoints = new HashMap<String, ConnectionPoint>();
    private String mFilename;
    private boolean mInitialized;
    private static final Logger LOG = ESAPI.getLogger(ConnectionPointsManager.class);

    public void setConnectionPointsLocation(String iFilename) {
        this.mFilename = iFilename;
    }

    public ConnectionPoint getCP(String iConnectionName) {
        if (this.mInitialized) {
            return this.mConnectionPoints.get(iConnectionName);
        }
        return null;
    }

    public synchronized void load() {
        if (!this.mInitialized) {
            if (this.mFilename == null) {
                LOG.info(Logger.EVENT_UNSPECIFIED, "Filename not found (connectionpoints.xml)");
                return;
            }
            ParseXml saxobj = new ParseXml();
            saxobj.parse(this.mFilename);
            this.mConnectionPoints = saxobj.getConnectionPoints();
            this.mInitialized = true;
        }
    }

    public void cleanup() {
        this.mInitialized = false;
        this.mConnectionPoints = null;
    }

    public void setConnectionPoints(Map<String, ConnectionPoint> iConnectionPoints) {
        this.mConnectionPoints = iConnectionPoints;
    }

    public Map<String, ConnectionPoint> getConnectionPoints() {
        return this.mConnectionPoints;
    }

    public void save() {
        File connPointOutFile = new File(this.mFilename);
        try (FileWriter connPointFile = new FileWriter(connPointOutFile);){
            StringBuilder sBuilder = new StringBuilder();
            sBuilder.append("<?xml version='1.0'?>\n<connectionpoints>\n");
            Collection<ConnectionPoint> col = this.mConnectionPoints.values();
            for (ConnectionPoint connPoint : col) {
                if (connPoint.isAlias()) {
                    sBuilder.append("\t<alias\n\t\tname='" + connPoint.getName() + "'\n\t\tlinkto='" + connPoint.getLinkTo() + "'\n\t\tcompany='" + connPoint.getBdeManagerCompany() + "'>\n\t</alias>\n");
                    continue;
                }
                sBuilder.append("\t<connectionpoint\n\t\tname='" + connPoint.getName() + "'\n\t\thostname='" + connPoint.getHostName() + "'\n\t\tport='" + connPoint.getPort() + "'\n\t\ttimerdelay='" + connPoint.getTimerDelay() + "'\n\t\tmaxconnections='" + connPoint.getMaxConnections() + "'\n\t\tmaxreferences='" + connPoint.getMaxReferences() + "'\n\t\tmaxthreads='" + connPoint.getMaxThreads() + "'\n\t\tforcecleanup='" + (connPoint.getForceCleanup() ? "true" : "false") + "'>\n");
                ConnectionPointActivation activation = connPoint.getActivation();
                if (activation != null) {
                    this.appendActivationString(sBuilder, activation);
                }
                sBuilder.append("\t</connectionpoint>\n");
            }
            sBuilder.append("</connectionpoints>");
            String result = new String(sBuilder);
            connPointFile.write(result);
        }
        catch (IOException e) {
            LOG.error(Logger.EVENT_FAILURE, "Failed writing " + this.mFilename + " file, cause: " + e.getMessage(), (Throwable)e);
        }
    }

    void appendActivationString(StringBuilder sBuilder, ConnectionPointActivation activation) {
        sBuilder.append("\t\t\t<activation\n\t\t\ttype='" + activation.getActivationType() + "'\n\t\t\tbse='" + activation.getActivationBse() + "'\n\t\t\tbshell='" + activation.getActivationBshell() + "'\n\t\t\tcompany='" + activation.getActivationCompany() + "'\n");
        if (!activation.getActivationUser().equals("")) {
            sBuilder.append("\t\t\tuser='" + activation.getActivationUser() + "'\n");
        }
        if (!activation.getActivationPassword().equals("")) {
            sBuilder.append("\t\t\tpassword='" + PasswordEncryption.getEncryptionPassword(activation.getActivationPassword()) + "'\n");
        }
        if (!activation.getActivationTenant().equals("")) {
            sBuilder.append("\t\t\ttenant='" + activation.getActivationTenant() + "'\n");
        }
        if (activation.getActivationEnvironment() != null) {
            sBuilder.append("\t\t\tenvironment='" + activation.getActivationEnvironment() + "'\n");
        }
        if (activation.getActivationDaemonOptions() != null) {
            sBuilder.append("\t\t\tdaemonoptions='" + activation.getActivationDaemonOptions() + "'\n");
        }
        sBuilder.append("\t\t/>\n");
    }
}

