/*
 * Decompiled with CFR 0.152.
 */
package com.infor.erpln.util;

import com.infor.erpln.util.encryption.PasswordEncryption;
import java.io.Serializable;

public class ConnectionPointActivation
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String mActivationType = "none";
    private String mActivationUser = "";
    private String mActivationPassword = "";
    private String mActivationTenant = "";
    private String mActivationBse = "";
    private String mActivationBshell = "";
    private String mActivationDaemonOptions;
    private String mActivationEnvironment;
    private int mActivationCompany = -1;

    public String getActivationType() {
        return this.mActivationType;
    }

    public String getActivationUser() {
        if (this.mActivationUser != null && this.mActivationUser.length() > 0) {
            return this.mActivationUser;
        }
        return "";
    }

    public String getActivationPassword() {
        String encryptedString = this.mActivationPassword;
        if (encryptedString != null && encryptedString.length() > 0) {
            return PasswordEncryption.getDecryptedPasswords(this.mActivationPassword);
        }
        return "";
    }

    public String getActivationTenant() {
        if (this.mActivationTenant != null) {
            return this.mActivationTenant;
        }
        return "";
    }

    public String getActivationBse() {
        return this.mActivationBse;
    }

    public int getActivationCompany() {
        return this.mActivationCompany;
    }

    public String getActivationBshell() {
        return this.mActivationBshell;
    }

    public String getActivationDaemonOptions() {
        return this.mActivationDaemonOptions;
    }

    public String getActivationEnvironment() {
        return this.mActivationEnvironment;
    }

    public void setActivationType(String iActivationType) {
        this.mActivationType = iActivationType;
    }

    public void setActivationUser(String iActivationUser) {
        this.mActivationUser = iActivationUser;
    }

    public void setActivationPassword(String iActivationPassword) {
        this.setActivationPassword(iActivationPassword, true);
    }

    public void setActivationPassword(String iActivationPassword, boolean iEncrypted) {
        this.mActivationPassword = iEncrypted ? iActivationPassword : PasswordEncryption.getEncryptionPassword(iActivationPassword);
    }

    public void setActivationTenant(String iActivationTenant) {
        this.mActivationTenant = iActivationTenant;
    }

    public void setActivationBse(String iActivationBse) {
        this.mActivationBse = iActivationBse;
    }

    public void setActivationCompany(String iActivationCompany) {
        Integer activationCompany = new Integer(iActivationCompany);
        this.mActivationCompany = activationCompany;
    }

    public void setActivationBshell(String iActivationBshell) {
        this.mActivationBshell = iActivationBshell;
    }

    public void setActivationDaemonOptions(String iActivationDaemonOptions) {
        this.mActivationDaemonOptions = iActivationDaemonOptions;
    }

    public void setActivationEnvironment(String iActivationEnvironment) {
        this.mActivationEnvironment = iActivationEnvironment;
    }
}

