/*
 * Decompiled with CFR 0.152.
 */
package com.infor.erpln.protocol;

import com.infor.erpln.jca.BDEConsumer;
import com.infor.erpln.protocol.BaanConnectionException;
import com.infor.erpln.protocol.ConnectionConfig;
import com.infor.erpln.protocol.EISMetaData;
import com.infor.erpln.protocol.JcaHandler;
import com.infor.erpln.protocol.SessionLayer;
import com.infor.erpln.protocol.SockConnector;
import com.infor.erpln.protocol.SockListener;
import com.infor.erpln.protocol.SockMessageServer;
import com.infor.erpln.protocol.SockNetReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.Logger;

public class SocketSessionLayer
implements SessionLayer {
    private Socket m_socket;
    private DataInputStream m_is;
    private DataOutputStream m_os;
    private String m_backend;
    private int m_port;
    private SockMessageServer m_mesServer;
    private SockListener m_listener;
    private static final Logger LOG = ESAPI.getLogger(SocketSessionLayer.class);

    @Override
    public boolean isValid() {
        return this.m_socket != null && this.m_mesServer != null && this.m_mesServer.isRunning();
    }

    @Override
    public synchronized void connect(ConnectionConfig a_connectData) throws BaanConnectionException {
        LOG.debug(Logger.EVENT_UNSPECIFIED, "Enter: connect()");
        if (a_connectData.getConnectionMethod() == 4) {
            this.m_listener = new SockListener();
            this.m_port = a_connectData.getPort();
        } else {
            if (this.m_socket != null && this.m_backend != null && this.m_backend.equals(a_connectData.getBackend()) && this.m_port == a_connectData.getPort()) {
                return;
            }
            this.doConnect(a_connectData);
            this.m_mesServer = new SockMessageServer(this.m_socket, new SockNetReader(this.m_is), a_connectData);
            this.m_mesServer.setConnectorObject(new SockConnector(this.m_os));
            this.m_mesServer.start();
            try {
                this.m_mesServer.initProtocol(4, a_connectData);
            }
            catch (BaanConnectionException e) {
                this.close();
                throw e;
            }
        }
        LOG.debug(Logger.EVENT_SUCCESS, "Leave: connect()");
    }

    @Override
    public synchronized void validate(ConnectionConfig a_connectData) throws BaanConnectionException {
        LOG.debug(Logger.EVENT_UNSPECIFIED, "Enter: validate()");
        if (a_connectData.getConnectionMethod() == 3) {
            this.doConnect(a_connectData);
        }
        LOG.debug(Logger.EVENT_SUCCESS, "Leave: validate()");
    }

    @Override
    public synchronized void activateListener(BDEConsumer iConsumer, byte[] iConsumerMetaData) throws BaanConnectionException {
        if (this.m_listener != null) {
            this.m_listener.activateListener(this.m_port, iConsumer, iConsumerMetaData);
        }
    }

    @Override
    public synchronized void close() {
        LOG.debug(Logger.EVENT_UNSPECIFIED, "Enter: close()");
        if (this.m_mesServer != null) {
            this.m_mesServer.stopServer();
            this.m_mesServer = null;
        }
        this.m_socket = null;
        if (this.m_listener != null) {
            this.m_listener.endListener();
            this.m_listener = null;
        }
        LOG.debug(Logger.EVENT_SUCCESS, "Leave: close()");
    }

    @Override
    public JcaHandler getBdeManager(int iCompany) throws BaanConnectionException {
        if (this.m_socket == null) {
            throw new BaanConnectionException("Not (yet) ready to accept requests", 6);
        }
        JcaHandler manager = this.m_mesServer.getBdeManager(iCompany);
        return manager;
    }

    @Override
    public InputStream openForRead(String a_serverFile, boolean a_textMode, boolean a_polling) throws IOException, BaanConnectionException {
        if (this.m_socket == null) {
            throw new BaanConnectionException("Not (yet) ready to accept requests", 6);
        }
        InputStream is = this.m_mesServer.openForRead(a_serverFile, a_textMode, a_polling);
        return is;
    }

    @Override
    public OutputStream openForWrite(String a_serverFile, boolean a_textMode) throws IOException, BaanConnectionException {
        if (this.m_socket == null) {
            throw new BaanConnectionException("Not (yet) ready to accept requests", 6);
        }
        OutputStream os = this.m_mesServer.openForWrite(a_serverFile, a_textMode);
        return os;
    }

    @Override
    public EISMetaData getMetaData() {
        return this.m_mesServer.getMetaData();
    }

    @Override
    public String getStartupMessages() {
        return null;
    }

    private void doConnect(ConnectionConfig a_connectData) throws BaanConnectionException {
        this.close();
        try {
            this.m_backend = a_connectData.getBackend();
            this.m_port = a_connectData.getPort();
            this.m_socket = new Socket(this.m_backend, this.m_port);
            this.m_socket.setTcpNoDelay(true);
            this.m_is = new DataInputStream(this.m_socket.getInputStream());
            this.m_os = new DataOutputStream(this.m_socket.getOutputStream());
        }
        catch (IOException e) {
            throw new BaanConnectionException("Connect failed with host: " + a_connectData.getBackend() + " and port: " + a_connectData.getPort(), 1);
        }
    }
}

