/*
 * Decompiled with CFR 0.152.
 */
package com.infor.erpln.protocol;

import com.infor.erpln.protocol.BdeConnector;
import com.infor.erpln.protocol.ConnectionConfig;
import com.infor.erpln.protocol.DsAttribute;
import com.infor.erpln.protocol.DsMessage;
import com.infor.erpln.protocol.JcaHandler;
import com.infor.erpln.protocol.JcaHandlerImpl;
import com.infor.erpln.protocol.MessageServer;
import com.infor.erpln.protocol.SockNetReader;
import com.infor.erpln.protocol.ThreeGLException;
import java.io.IOException;
import java.net.Socket;
import java.util.Hashtable;

public class SockMessageServer
extends MessageServer {
    public static final int CONDAEMON = 1;
    public static final int BDEMANAGER = 2;
    public static final int PUBLISHER = 3;
    Hashtable<Integer, JcaHandler> m_bdeManagers = new Hashtable();

    public SockMessageServer(Socket a_socket, SockNetReader a_netReader, ConnectionConfig a_connectData) {
        super(a_socket, a_netReader, a_connectData);
    }

    @Override
    public void run() {
        this.logConnectionData();
        while (this.m_running) {
            try {
                DsMessage mess = this.m_netReader.readMessage();
                try {
                    switch (mess.getFamily()) {
                        case 1: {
                            this.dispatchReplyMessage(mess);
                            break;
                        }
                        case 2: {
                            this.dispatchBdeManager(mess);
                            break;
                        }
                        case 3: {
                            this.dispatchPubMessage(mess);
                            break;
                        }
                        default: {
                            throw new IOException("Unexpected message family");
                        }
                    }
                }
                catch (ThreeGLException e) {
                    this.m_errors.add(new String("3GL programming error for " + mess.getName() + ": " + e.getMessage()));
                    this.signalException(e);
                }
            }
            catch (IOException e) {
                if (!this.m_running) continue;
                this.signalException(e);
            }
        }
        this.stopServer();
    }

    private void dispatchBdeManager(DsMessage reply) throws ThreeGLException {
        JcaHandlerImpl bdeMan = null;
        DsAttribute dsAttr = reply.getAttribute(8);
        int bdeId = dsAttr.getValueInt();
        dsAttr = reply.getAttribute(353);
        switch (dsAttr.getValueInt()) {
            case 17: {
                if (bdeId > 0) {
                    bdeMan = new JcaHandlerImpl(this, (BdeConnector)((Object)this.m_connector), bdeId);
                    this.m_bdeManagers.put(new Integer(bdeId), bdeMan);
                    this.setBdeManager(bdeMan);
                    break;
                }
                this.dispatchReplyMessage(reply);
                break;
            }
            case 27: {
                bdeMan = (JcaHandlerImpl)this.m_bdeManagers.remove(new Integer(bdeId));
            }
            default: {
                if (bdeMan == null) {
                    bdeMan = (JcaHandlerImpl)this.m_bdeManagers.get(new Integer(bdeId));
                }
                if (bdeMan != null) {
                    bdeMan.dispatchReplyMessage(reply);
                    break;
                }
                throw new ThreeGLException("BDEManager not found");
            }
        }
    }
}

