/*
 * Decompiled with CFR 0.152.
 */
package com.infor.erpln.protocol;

import com.infor.erpln.protocol.BdeConnector;
import com.infor.erpln.protocol.ConnectionConfig;
import com.infor.erpln.protocol.Connector;
import com.infor.erpln.util.encryption.PasswordEncryption;
import java.io.DataOutputStream;
import java.io.IOException;

public class SockConnector
implements Connector,
BdeConnector {
    private DataOutputStream m_os;
    private int m_protocolVersion = 1;

    public SockConnector(DataOutputStream a_os) {
        this.m_os = a_os;
    }

    @Override
    public synchronized void sendInitProtocol(int a_protocolVersion, ConnectionConfig a_connectData) {
        try {
            this.m_os.writeInt(14);
            this.m_os.writeInt(a_protocolVersion);
            switch (a_connectData.getConnectionMethod()) {
                case 3: {
                    this.m_os.writeInt(1);
                    this.m_os.writeInt(a_connectData.getCompany());
                    this.m_os.writeUTF(a_connectData.getUser());
                    this.m_os.writeUTF("");
                    break;
                }
                case 7: {
                    throw new UnsupportedOperationException("Infor CAS SSO not supported");
                }
                case 9: {
                    this.m_os.writeInt(3);
                    this.m_os.writeInt(a_connectData.getCompany());
                    String ticket = a_connectData.getPassword();
                    String encryptedTicket = "";
                    if (ticket.length() > 0) {
                        encryptedTicket = PasswordEncryption.getEncryptionPassword(ticket);
                    }
                    this.m_os.writeUTF(encryptedTicket);
                }
            }
            this.m_os.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public synchronized void sendOpenBdeRequest(int iCompany) {
        try {
            this.m_os.writeInt(16);
            if (this.m_protocolVersion > 1) {
                this.m_os.writeInt(iCompany);
            }
            this.m_os.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public synchronized void sendOpenFileRequest(String a_serverFile, int a_mode, boolean a_polling) {
        try {
            if (a_polling) {
                this.m_os.writeInt(12);
            } else {
                this.m_os.writeInt(3);
            }
            this.m_os.writeInt(a_mode);
            this.m_os.writeUTF(a_serverFile);
            this.m_os.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public synchronized void sendReadRequest(int a_fileId) {
        try {
            this.m_os.writeInt(5);
            this.m_os.writeInt(a_fileId);
            this.m_os.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public synchronized void sendWriteRequest(int a_fileId, boolean a_eof, byte[] a_buffer) {
        try {
            this.m_os.writeInt(7);
            this.m_os.writeInt(a_fileId);
            this.m_os.writeInt(a_eof ? 1 : 0);
            this.m_os.writeInt(a_buffer.length);
            this.m_os.write(a_buffer, 0, a_buffer.length);
            this.m_os.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public synchronized void sendCloseRequest(int a_fileId) {
        try {
            this.m_os.writeInt(9);
            this.m_os.writeInt(a_fileId);
            this.m_os.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void sendStopConnector() {
    }

    @Override
    public synchronized void sendPubInitAck(int a_consumerVersion, int a_returnValue, byte[] a_metaData) {
        try {
            this.m_os.writeInt(33);
            this.m_os.writeInt(a_consumerVersion);
            this.m_os.writeInt(a_returnValue);
            this.m_os.writeInt(a_metaData.length);
            this.m_os.write(a_metaData, 0, a_metaData.length);
            this.m_os.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public synchronized void sendPubBdeAck(int a_returnValue) {
        try {
            this.m_os.writeInt(35);
            this.m_os.writeInt(a_returnValue);
            this.m_os.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public synchronized void sendDispatchBde(int a_bdeId, String a_bdeName, String a_bdeMethod, byte[] a_request) {
        try {
            this.m_os.writeInt(18);
            this.m_os.writeInt(a_bdeId);
            this.m_os.writeUTF(a_bdeName);
            this.m_os.writeUTF(a_bdeMethod);
            this.m_os.writeInt(a_request.length);
            this.m_os.write(a_request, 0, a_request.length);
            this.m_os.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void sendDispatchHTTP(int a_bdeId, int a_indicator, byte[] a_header, byte[] a_request) {
        try {
            this.m_os.writeInt(a_indicator);
            this.m_os.writeInt(a_bdeId);
            if (a_header != null) {
                this.m_os.writeInt(a_header.length);
                this.m_os.write(a_header, 0, a_header.length);
            } else {
                this.m_os.writeInt(0);
            }
            if (a_request != null) {
                this.m_os.writeInt(a_request.length);
                this.m_os.write(a_request, 0, a_request.length);
            } else {
                this.m_os.writeInt(0);
            }
            this.m_os.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public synchronized void sendExecuteDll(int a_bdeId, byte[] a_request) {
        try {
            this.m_os.writeInt(1);
            this.m_os.writeInt(a_bdeId);
            this.m_os.writeInt(a_request.length);
            this.m_os.write(a_request, 0, a_request.length);
            this.m_os.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public synchronized void sendExecuteQuery(int a_bdeId, byte[] a_request) {
        try {
            this.m_os.writeInt(30);
            this.m_os.writeInt(a_bdeId);
            this.m_os.writeInt(a_request.length);
            this.m_os.write(a_request, 0, a_request.length);
            this.m_os.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public synchronized void sendSimpleCommand(int a_bdeId, int a_indicator) {
        try {
            this.m_os.writeInt(a_indicator);
            this.m_os.writeInt(a_bdeId);
            this.m_os.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void setProtocolVersion(int iVersion) {
        this.m_protocolVersion = iVersion;
    }

    public int getProtocolVersion() {
        return this.m_protocolVersion;
    }
}

